/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl;

import graphql.GraphQL;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent;
import io.vertx.ext.web.handler.graphql.ApolloWSHandler;
import io.vertx.ext.web.handler.graphql.ApolloWSMessage;
import io.vertx.ext.web.handler.graphql.ApolloWSOptions;
import io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext;
import io.vertx.ext.web.handler.graphql.impl.ApolloWSConnectionHandler;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.Utils;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.dataloader.DataLoaderRegistry;

public class ApolloWSHandlerImpl
implements ApolloWSHandler {
    private static final Function<ApolloWSMessage, Object> DEFAULT_QUERY_CONTEXT_FACTORY = context -> context;
    private static final Function<ApolloWSMessage, DataLoaderRegistry> DEFAULT_DATA_LOADER_REGISTRY_FACTORY = rc -> null;
    private static final Function<ApolloWSMessage, Locale> DEFAULT_LOCALE_FACTORY = rc -> null;
    private final GraphQL graphQL;
    private final long keepAlive;
    private final Origin origin;
    private Function<ApolloWSMessage, Object> queryContextFactory = DEFAULT_QUERY_CONTEXT_FACTORY;
    private Function<ApolloWSMessage, DataLoaderRegistry> dataLoaderRegistryFactory = DEFAULT_DATA_LOADER_REGISTRY_FACTORY;
    private Function<ApolloWSMessage, Locale> localeFactory = DEFAULT_LOCALE_FACTORY;
    private Handler<ServerWebSocket> connectionHandler;
    private Handler<ApolloWSConnectionInitEvent> connectionInitHandler;
    private Handler<ServerWebSocket> endHandler;
    private Handler<ApolloWSMessage> messageHandler;
    private Handler<ExecutionInputBuilderWithContext<ApolloWSMessage>> beforeExecute;

    public ApolloWSHandlerImpl(GraphQL graphQL, ApolloWSOptions options) {
        Objects.requireNonNull(graphQL, "graphQL");
        Objects.requireNonNull(options, "options");
        this.graphQL = graphQL;
        this.keepAlive = options.getKeepAlive();
        this.origin = options.getOrigin() != null ? Origin.parse((String)options.getOrigin()) : null;
    }

    GraphQL getGraphQL() {
        return this.graphQL;
    }

    long getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public synchronized ApolloWSHandler connectionHandler(Handler<ServerWebSocket> connectionHandler) {
        this.connectionHandler = connectionHandler;
        return this;
    }

    synchronized Handler<ServerWebSocket> getConnectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public ApolloWSHandler connectionInitHandler(Handler<ApolloWSConnectionInitEvent> connectionInitHandler) {
        this.connectionInitHandler = connectionInitHandler;
        return this;
    }

    synchronized Handler<ApolloWSConnectionInitEvent> getConnectionInitHandler() {
        return this.connectionInitHandler;
    }

    @Override
    public synchronized ApolloWSHandler messageHandler(Handler<ApolloWSMessage> messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    synchronized Handler<ApolloWSMessage> getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public synchronized ApolloWSHandler endHandler(Handler<ServerWebSocket> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    synchronized Handler<ServerWebSocket> getEndHandler() {
        return this.endHandler;
    }

    @Override
    public synchronized ApolloWSHandler queryContext(Function<ApolloWSMessage, Object> factory) {
        this.queryContextFactory = factory != null ? factory : DEFAULT_QUERY_CONTEXT_FACTORY;
        return this;
    }

    synchronized Function<ApolloWSMessage, Object> getQueryContext() {
        return this.queryContextFactory;
    }

    @Override
    public synchronized ApolloWSHandler dataLoaderRegistry(Function<ApolloWSMessage, DataLoaderRegistry> factory) {
        this.dataLoaderRegistryFactory = factory != null ? factory : DEFAULT_DATA_LOADER_REGISTRY_FACTORY;
        return this;
    }

    synchronized Function<ApolloWSMessage, DataLoaderRegistry> getDataLoaderRegistry() {
        return this.dataLoaderRegistryFactory;
    }

    @Override
    public synchronized ApolloWSHandler locale(Function<ApolloWSMessage, Locale> factory) {
        this.localeFactory = factory != null ? factory : DEFAULT_LOCALE_FACTORY;
        return this;
    }

    synchronized Function<ApolloWSMessage, Locale> getLocale() {
        return this.localeFactory;
    }

    @Override
    public ApolloWSHandler beforeExecute(Handler<ExecutionInputBuilderWithContext<ApolloWSMessage>> beforeExecute) {
        this.beforeExecute = beforeExecute;
        return this;
    }

    synchronized Handler<ExecutionInputBuilderWithContext<ApolloWSMessage>> getBeforeExecute() {
        return this.beforeExecute;
    }

    public void handle(RoutingContext ctx) {
        if (Utils.canUpgradeToWebsocket((HttpServerRequest)ctx.request())) {
            if (!Origin.check((Origin)this.origin, (RoutingContext)ctx)) {
                ctx.fail(403, (Throwable)new IllegalStateException("Invalid Origin"));
                return;
            }
            ContextInternal context = (ContextInternal)ctx.vertx().getOrCreateContext();
            ctx.request().toWebSocket().onFailure(arg_0 -> ((RoutingContext)ctx).fail(arg_0)).onSuccess(ws -> {
                ApolloWSConnectionHandler connectionHandler = new ApolloWSConnectionHandler(this, context, (ServerWebSocket)ws);
                connectionHandler.handleConnection();
            });
        } else {
            ctx.next();
        }
    }
}

