/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class GraphiQLHandlerOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, GraphiQLHandlerOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "enabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setEnabled((Boolean)member.getValue());
                    break;
                }
                case "graphQLUri": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setGraphQLUri((String)member.getValue());
                    break;
                }
                case "headers": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setHeaders(map);
                    break;
                }
                case "query": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setQuery((String)member.getValue());
                    break;
                }
                case "variables": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setVariables(((JsonObject)member.getValue()).copy());
                }
            }
        }
    }

    public static void toJson(GraphiQLHandlerOptions obj, JsonObject json) {
        GraphiQLHandlerOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(GraphiQLHandlerOptions obj, Map<String, Object> json) {
        json.put("enabled", obj.isEnabled());
        if (obj.getGraphQLUri() != null) {
            json.put("graphQLUri", obj.getGraphQLUri());
        }
        if (obj.getHeaders() != null) {
            JsonObject map = new JsonObject();
            obj.getHeaders().forEach((key, value) -> map.put(key, value));
            json.put("headers", map);
        }
        if (obj.getQuery() != null) {
            json.put("query", obj.getQuery());
        }
        if (obj.getVariables() != null) {
            json.put("variables", obj.getVariables());
        }
    }
}

