/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.common.WebEnvironment;
import io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptionsConverter;
import java.util.HashMap;
import java.util.Map;

@DataObject(generateConverter=true)
public class GraphiQLHandlerOptions {
    public static final boolean DEFAULT_ENABLED = WebEnvironment.development();
    private boolean enabled = DEFAULT_ENABLED;
    private String graphQLUri;
    private Map<String, String> headers;
    private String query;
    private JsonObject variables;

    public GraphiQLHandlerOptions() {
    }

    public GraphiQLHandlerOptions(GraphiQLHandlerOptions other) {
        this.enabled = other.enabled;
        this.graphQLUri = other.graphQLUri;
        this.headers = other.headers == null ? null : new HashMap<String, String>(other.headers);
        this.query = other.query;
        this.variables = other.variables == null ? null : other.variables.copy();
    }

    public GraphiQLHandlerOptions(JsonObject json) {
        this();
        GraphiQLHandlerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        GraphiQLHandlerOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GraphiQLHandlerOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getGraphQLUri() {
        return this.graphQLUri;
    }

    public GraphiQLHandlerOptions setGraphQLUri(String graphQLUri) {
        this.graphQLUri = graphQLUri;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public GraphiQLHandlerOptions setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public GraphiQLHandlerOptions setQuery(String query) {
        this.query = query;
        return this;
    }

    public JsonObject getVariables() {
        return this.variables;
    }

    public GraphiQLHandlerOptions setVariables(JsonObject variables) {
        this.variables = variables;
        return this;
    }
}

