/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl.ws;

import graphql.GraphQL;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext;
import io.vertx.ext.web.handler.graphql.impl.ws.ConnectionHandler;
import io.vertx.ext.web.handler.graphql.ws.ConnectionInitEvent;
import io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler;
import io.vertx.ext.web.handler.graphql.ws.GraphQLWSOptions;
import io.vertx.ext.web.handler.graphql.ws.Message;
import java.util.Objects;

public class GraphQLWSHandlerImpl
implements GraphQLWSHandler {
    private final GraphQL graphQL;
    private final long connectionInitWaitTimeout;
    private Handler<ExecutionInputBuilderWithContext<Message>> beforeExecute;
    private Handler<ConnectionInitEvent> connectionInitHandler;

    public GraphQLWSHandlerImpl(GraphQL graphQL, GraphQLWSOptions options) {
        Objects.requireNonNull(graphQL, "graphQL instance is null");
        Objects.requireNonNull(options, "options instance is null");
        this.graphQL = graphQL;
        this.connectionInitWaitTimeout = options.getConnectionInitWaitTimeout();
    }

    GraphQL getGraphQL() {
        return this.graphQL;
    }

    long getConnectionInitWaitTimeout() {
        return this.connectionInitWaitTimeout;
    }

    @Override
    public GraphQLWSHandler connectionInitHandler(Handler<ConnectionInitEvent> connectionInitHandler) {
        this.connectionInitHandler = connectionInitHandler;
        return this;
    }

    synchronized Handler<ConnectionInitEvent> getConnectionInitHandler() {
        return this.connectionInitHandler;
    }

    @Override
    public GraphQLWSHandler beforeExecute(Handler<ExecutionInputBuilderWithContext<Message>> beforeExecute) {
        this.beforeExecute = beforeExecute;
        return this;
    }

    synchronized Handler<ExecutionInputBuilderWithContext<Message>> getBeforeExecute() {
        return this.beforeExecute;
    }

    public void handle(RoutingContext rc) {
        MultiMap headers = rc.request().headers();
        if (headers.contains(HttpHeaders.CONNECTION) && headers.contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
            ContextInternal context = (ContextInternal)rc.vertx().getOrCreateContext();
            rc.request().toWebSocket().onComplete(ar -> {
                if (ar.succeeded()) {
                    ConnectionHandler handler = new ConnectionHandler(this, context, (ServerWebSocket)ar.result());
                    handler.handleConnection();
                } else {
                    rc.fail(ar.cause());
                }
            });
        } else {
            rc.next();
        }
    }
}

