/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.common.WebEnvironment;
import io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent;
import io.vertx.ext.web.handler.graphql.ApolloWSMessage;
import io.vertx.ext.web.handler.graphql.ApolloWSMessageType;
import io.vertx.ext.web.handler.graphql.impl.ApolloWSHandlerImpl;
import io.vertx.ext.web.handler.graphql.impl.ApolloWSMessageImpl;
import io.vertx.ext.web.handler.graphql.impl.GraphQLQuery;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.dataloader.DataLoaderRegistry;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ApolloWSConnectionHandler {
    private static final Logger log = LoggerFactory.getLogger(ApolloWSConnectionHandler.class);
    private static final short WS_INTERNAL_ERROR = 1011;
    private final ApolloWSHandlerImpl apolloWSHandler;
    private final ServerWebSocket serverWebSocket;
    private final ContextInternal context;
    private final Executor executor;
    private final ConcurrentMap<String, Subscription> subscriptions;
    private final Promise<Object> connectionPromise;
    private final AtomicBoolean connectionInitialized;

    ApolloWSConnectionHandler(ApolloWSHandlerImpl apolloWSHandler, ContextInternal context, ServerWebSocket serverWebSocket) {
        this.apolloWSHandler = apolloWSHandler;
        this.context = context;
        this.serverWebSocket = serverWebSocket;
        this.executor = task -> context.runOnContext(v -> task.run());
        this.subscriptions = new ConcurrentHashMap<String, Subscription>();
        this.connectionPromise = context.promise();
        this.connectionInitialized = new AtomicBoolean(false);
    }

    void handleConnection() {
        Handler<ServerWebSocket> ch = this.apolloWSHandler.getConnectionHandler();
        if (ch != null) {
            ch.handle((Object)this.serverWebSocket);
        }
        this.serverWebSocket.binaryMessageHandler(this::handleBinaryMessage);
        this.serverWebSocket.textMessageHandler(this::handleTextMessage);
        this.serverWebSocket.closeHandler(this::close);
    }

    private void handleBinaryMessage(Buffer buffer) {
        this.handleMessage(new JsonObject(buffer));
    }

    private void handleTextMessage(String text) {
        this.handleMessage(new JsonObject(text));
    }

    private void handleMessage(JsonObject jsonObject) {
        String opId = jsonObject.getString("id");
        ApolloWSMessageType type = ApolloWSMessageType.from(jsonObject.getString("type"));
        if (type == null) {
            this.sendMessage(opId, ApolloWSMessageType.ERROR, "Unknown message type: " + jsonObject.getString("type"));
            return;
        }
        final ApolloWSMessageImpl message = new ApolloWSMessageImpl(this.serverWebSocket, type, jsonObject);
        Handler<ApolloWSMessage> mh = this.apolloWSHandler.getMessageHandler();
        if (mh != null) {
            mh.handle((Object)message);
        }
        Handler<ApolloWSConnectionInitEvent> connectionInitHandler = this.apolloWSHandler.getConnectionInitHandler();
        switch (type) {
            case CONNECTION_INIT: {
                if (!this.connectionInitialized.compareAndSet(false, true)) {
                    this.sendMessage(opId, ApolloWSMessageType.ERROR, "CONNECTION_INIT can only be sent once").onComplete(v -> this.serverWebSocket.close((short)1011));
                    break;
                }
                if (connectionInitHandler != null) {
                    connectionInitHandler.handle((Object)new ApolloWSConnectionInitEvent(){

                        @Override
                        public ApolloWSMessage message() {
                            return message;
                        }

                        public boolean tryComplete(Object o) {
                            return ApolloWSConnectionHandler.this.connectionPromise.tryComplete(o);
                        }

                        public boolean tryFail(Throwable throwable) {
                            return ApolloWSConnectionHandler.this.connectionPromise.tryFail(throwable);
                        }

                        public Future<Object> future() {
                            return ApolloWSConnectionHandler.this.connectionPromise.future();
                        }
                    });
                } else {
                    this.connectionPromise.complete();
                }
                this.connectionPromise.future().onComplete(ar -> {
                    if (ar.succeeded()) {
                        this.connect();
                    } else {
                        this.sendMessage(opId, ApolloWSMessageType.CONNECTION_ERROR, ar.cause().getMessage()).onComplete(v -> this.serverWebSocket.close((short)1011));
                    }
                });
                break;
            }
            case CONNECTION_TERMINATE: {
                this.serverWebSocket.close();
                break;
            }
            case START: {
                if (!this.connectionInitialized.get()) {
                    this.sendMessage(opId, ApolloWSMessageType.ERROR, "CONNECTION_INIT has to be sent before START").onComplete(v -> this.serverWebSocket.close((short)1011));
                    break;
                }
                this.connectionPromise.future().onComplete(ar -> {
                    if (ar.succeeded()) {
                        ApolloWSMessageImpl messageWithParams = new ApolloWSMessageImpl(this.serverWebSocket, type, jsonObject, ar.result());
                        this.start(messageWithParams);
                    } else {
                        this.sendMessage(opId, ApolloWSMessageType.ERROR, ar.cause().getMessage());
                        this.stop(opId);
                    }
                });
                break;
            }
            case STOP: {
                this.stop(opId);
                break;
            }
            default: {
                this.sendMessage(opId, ApolloWSMessageType.ERROR, "Unsupported message type: " + (Object)((Object)type));
            }
        }
    }

    private void connect() {
        this.sendMessage(null, ApolloWSMessageType.CONNECTION_ACK, null);
        long keepAlive = this.apolloWSHandler.getKeepAlive();
        if (keepAlive > 0L) {
            this.sendMessage(null, ApolloWSMessageType.CONNECTION_KEEP_ALIVE, null);
            this.context.setPeriodic(keepAlive, timerId -> {
                if (this.serverWebSocket.isClosed()) {
                    this.context.owner().cancelTimer(timerId.longValue());
                } else {
                    this.sendMessage(null, ApolloWSMessageType.CONNECTION_KEEP_ALIVE, null);
                }
            });
        }
    }

    private void start(ApolloWSMessage message) {
        Map<String, Object> variables;
        String operationName;
        Locale locale;
        String opId = message.content().getString("id");
        if (this.subscriptions.containsKey(opId)) {
            this.stop(opId);
        }
        GraphQLQuery payload = new GraphQLQuery(message.content().getJsonObject("payload"));
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput();
        builder.query(payload.getQuery());
        builder.context(this.apolloWSHandler.getQueryContext().apply(message));
        DataLoaderRegistry registry = this.apolloWSHandler.getDataLoaderRegistry().apply(message);
        if (registry != null) {
            builder.dataLoaderRegistry(registry);
        }
        if ((locale = this.apolloWSHandler.getLocale().apply(message)) != null) {
            builder.locale(locale);
        }
        if ((operationName = payload.getOperationName()) != null) {
            builder.operationName(operationName);
        }
        if ((variables = payload.getVariables()) != null) {
            builder.variables(variables);
        }
        this.apolloWSHandler.getGraphQL().executeAsync(builder).whenCompleteAsync((executionResult, throwable) -> {
            if (throwable == null) {
                if (executionResult.getData() instanceof Publisher) {
                    this.subscribe(opId, (ExecutionResult)executionResult);
                } else {
                    this.sendMessage(opId, ApolloWSMessageType.DATA, new JsonObject(executionResult.toSpecification()));
                    this.sendMessage(opId, ApolloWSMessageType.COMPLETE, null);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to execute GraphQL query, opId=" + opId), throwable);
                }
                this.sendMessage(opId, ApolloWSMessageType.ERROR, this.toJsonObject((Throwable)throwable));
            }
        }, this.executor);
    }

    private void subscribe(final String opId, ExecutionResult executionResult) {
        Publisher publisher = (Publisher)executionResult.getData();
        final AtomicReference subscriptionRef = new AtomicReference();
        publisher.subscribe((Subscriber)new Subscriber<ExecutionResult>(){

            public void onSubscribe(Subscription s) {
                subscriptionRef.set(s);
                ApolloWSConnectionHandler.this.subscriptions.put(opId, s);
                s.request(1L);
            }

            public void onNext(ExecutionResult er) {
                ApolloWSConnectionHandler.this.sendMessage(opId, ApolloWSMessageType.DATA, new JsonObject(er.toSpecification()));
                ((Subscription)subscriptionRef.get()).request(1L);
            }

            public void onError(Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GraphQL subscription terminated with error, opId=" + opId), t);
                }
                ApolloWSConnectionHandler.this.sendMessage(opId, ApolloWSMessageType.ERROR, ApolloWSConnectionHandler.this.toJsonObject(t));
                ApolloWSConnectionHandler.this.subscriptions.remove(opId);
            }

            public void onComplete() {
                ApolloWSConnectionHandler.this.sendMessage(opId, ApolloWSMessageType.COMPLETE, null);
                ApolloWSConnectionHandler.this.subscriptions.remove(opId);
            }
        });
    }

    private void stop(String opId) {
        Subscription subscription = (Subscription)this.subscriptions.get(opId);
        if (subscription != null) {
            subscription.cancel();
            this.subscriptions.remove(opId);
        }
    }

    private JsonObject toJsonObject(Throwable t) {
        JsonObject res = new JsonObject().put("message", (Object)t.toString());
        if (WebEnvironment.development()) {
            StringWriter sw = new StringWriter();
            try (PrintWriter writer = new PrintWriter(sw);){
                t.printStackTrace(writer);
                writer.flush();
            }
            res.put("extensions", (Object)new JsonObject().put("exception", (Object)new JsonObject().put("stacktrace", (Object)sw.toString())));
        }
        return res;
    }

    private Future<Void> sendMessage(String opId, ApolloWSMessageType type, Object payload) {
        Objects.requireNonNull(type, "type is null");
        JsonObject message = new JsonObject();
        if (opId != null) {
            message.put("id", (Object)opId);
        }
        message.put("type", (Object)type.getText());
        if (payload != null) {
            message.put("payload", payload);
        }
        return this.serverWebSocket.writeTextMessage(message.toString());
    }

    private void close(Void v) {
        this.subscriptions.values().forEach(Subscription::cancel);
        Handler<ServerWebSocket> eh = this.apolloWSHandler.getEndHandler();
        if (eh != null) {
            eh.handle((Object)this.serverWebSocket);
        }
    }
}

