/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql;

import io.vertx.core.Promise;
import io.vertx.ext.web.handler.graphql.TriConsumer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.MappedBatchLoaderWithContext;

public class VertxMappedBatchLoader<K, V>
implements MappedBatchLoaderWithContext<K, V> {
    private final TriConsumer<Set<K>, BatchLoaderEnvironment, Promise<Map<K, V>>> batchLoader;

    public VertxMappedBatchLoader(TriConsumer<Set<K>, BatchLoaderEnvironment, Promise<Map<K, V>>> batchLoader) {
        this.batchLoader = batchLoader;
    }

    public CompletionStage<Map<K, V>> load(Set<K> keys, BatchLoaderEnvironment environment) {
        CompletableFuture cf = new CompletableFuture();
        Promise promise = Promise.promise();
        promise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                cf.complete((Map)ar.result());
            } else {
                cf.completeExceptionally(ar.cause());
            }
        });
        this.batchLoader.accept(keys, environment, promise);
        return cf;
    }
}

