/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.cache;

import io.vertx.core.MultiMap;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import java.util.Objects;
import java.util.stream.Collectors;

class CacheVariationsKey {
    protected final String host;
    protected final int port;
    protected final String path;
    protected final String queryString;

    CacheVariationsKey(HttpRequest<?> request) {
        HttpRequestImpl impl = (HttpRequestImpl)request;
        this.host = impl.host();
        this.port = impl.port();
        this.path = impl.uri();
        this.queryString = this.queryString(impl.queryParams());
    }

    public String toString() {
        return this.host + ":" + this.port + this.path + "?" + this.queryString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheVariationsKey that = (CacheVariationsKey)o;
        return this.port == that.port && this.host.equals(that.host) && this.path.equals(that.path) && this.queryString.equals(that.queryString);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.path, this.queryString);
    }

    private String queryString(MultiMap queryParams) {
        return queryParams.entries().stream().sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
    }
}

