/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.HttpResponseImpl;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.codec.spi.BodyStream;
import java.util.Map;

class HttpRequestImpl<T>
implements HttpRequest<T> {
    private final HttpClient client;
    private final WebClientOptions options;
    private MultiMap params;
    private io.vertx.core.http.HttpMethod method;
    private int port;
    private String host;
    private String uri;
    private MultiMap headers;
    private long timeout = -1L;
    private BodyCodec<T> codec;
    private boolean followRedirects;
    private boolean ssl;

    HttpRequestImpl(HttpClient client, io.vertx.core.http.HttpMethod method, boolean ssl, int port, String host, String uri, BodyCodec<T> codec, WebClientOptions options) {
        this.client = client;
        this.method = method;
        this.codec = codec;
        this.port = port;
        this.host = host;
        this.uri = uri;
        this.ssl = ssl;
        this.followRedirects = options.isFollowRedirects();
        this.options = options;
        if (options.isUserAgentEnabled()) {
            this.headers = new CaseInsensitiveHeaders().add(HttpHeaders.USER_AGENT, (CharSequence)options.getUserAgent());
        }
    }

    private HttpRequestImpl(HttpRequestImpl<T> other) {
        this.client = other.client;
        this.options = other.options;
        this.method = other.method;
        this.port = other.port;
        this.host = other.host;
        this.timeout = other.timeout;
        this.uri = other.uri;
        this.headers = other.headers != null ? new CaseInsensitiveHeaders().addAll(other.headers) : null;
        this.params = other.params != null ? new CaseInsensitiveHeaders().addAll(other.params) : null;
        this.codec = other.codec;
        this.followRedirects = other.followRedirects;
    }

    @Override
    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        this.codec = responseCodec;
        return this;
    }

    @Override
    public HttpRequest<T> method(io.vertx.core.http.HttpMethod value) {
        this.method = value;
        return this;
    }

    @Override
    public HttpRequest<T> port(int value) {
        this.port = value;
        return this;
    }

    @Override
    public HttpRequest<T> host(String value) {
        this.host = value;
        return this;
    }

    @Override
    public HttpRequest<T> uri(String value) {
        this.params = null;
        this.uri = value;
        return this;
    }

    @Override
    public HttpRequest<T> putHeader(String name, String value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new CaseInsensitiveHeaders();
        }
        return this.headers;
    }

    @Override
    public HttpRequest<T> ssl(boolean value) {
        this.ssl = value;
        return this;
    }

    @Override
    public HttpRequest<T> timeout(long value) {
        this.timeout = value;
        return this;
    }

    @Override
    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.queryParams().add(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.queryParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> followRedirects(boolean value) {
        this.followRedirects = value;
        return this;
    }

    @Override
    public MultiMap queryParams() {
        int idx;
        if (this.params == null) {
            this.params = new CaseInsensitiveHeaders();
        }
        if (this.params.isEmpty() && (idx = this.uri.indexOf(63)) >= 0) {
            QueryStringDecoder dec = new QueryStringDecoder(this.uri);
            dec.parameters().forEach((name, value) -> this.params.add(name, (Iterable)value));
            this.uri = this.uri.substring(0, idx);
        }
        return this.params;
    }

    @Override
    public HttpRequest<T> copy() {
        return new HttpRequestImpl<T>(this);
    }

    @Override
    public void sendStream(ReadStream<Buffer> body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, body, handler);
    }

    @Override
    public void send(Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, null, handler);
    }

    @Override
    public void sendBuffer(Buffer body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, body, handler);
    }

    @Override
    public void sendJsonObject(JsonObject body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("application/json", body, handler);
    }

    @Override
    public void sendJson(Object body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("application/json", body, handler);
    }

    @Override
    public void sendForm(MultiMap body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("application/x-www-form-urlencoded", body, handler);
    }

    private void send(String contentType, Object body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        String requestURI;
        Future responseFuture = Future.future().setHandler(ar -> {
            if (ar.succeeded()) {
                HttpClientResponse resp = (HttpClientResponse)ar.result();
                Future fut = Future.future();
                fut.setHandler(handler);
                resp.exceptionHandler(err -> {
                    if (!fut.isComplete()) {
                        fut.fail(err);
                    }
                });
                resp.pause();
                this.codec.create(ar2 -> {
                    resp.resume();
                    if (ar2.succeeded()) {
                        BodyStream stream = (BodyStream)ar2.result();
                        stream.exceptionHandler(err -> {
                            if (!fut.isComplete()) {
                                fut.fail(err);
                            }
                        });
                        resp.endHandler(v -> {
                            if (!fut.isComplete()) {
                                stream.end();
                                if (stream.result().succeeded()) {
                                    fut.complete(new HttpResponseImpl<Object>(resp, null, stream.result().result()));
                                } else {
                                    fut.fail(stream.result().cause());
                                }
                            }
                        });
                        Pump responsePump = Pump.pump((ReadStream)resp, (WriteStream)stream);
                        responsePump.start();
                    } else {
                        handler.handle((Object)Future.failedFuture((Throwable)ar2.cause()));
                    }
                });
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
        if (this.params != null && this.params.size() > 0) {
            QueryStringEncoder enc = new QueryStringEncoder(this.uri);
            this.params.forEach(param -> enc.addParam((String)param.getKey(), (String)param.getValue()));
            requestURI = enc.toString();
        } else {
            requestURI = this.uri;
        }
        HttpClientRequest req = this.ssl != this.options.isSsl() ? this.client.request(this.method, new RequestOptions().setSsl(this.ssl).setHost(this.host).setPort(this.port).setURI(this.uri)) : this.client.request(this.method, this.port, this.host, requestURI);
        req.setFollowRedirects(this.followRedirects);
        if (this.headers != null) {
            req.headers().addAll(this.headers);
        }
        req.exceptionHandler(err -> {
            if (!responseFuture.isComplete()) {
                responseFuture.fail(err);
            }
        });
        req.handler(resp -> {
            if (!responseFuture.isComplete()) {
                responseFuture.complete(resp);
            }
        });
        if (this.timeout > 0L) {
            req.setTimeout(this.timeout);
        }
        if (body != null) {
            if (contentType != null) {
                String prev = req.headers().get(HttpHeaders.CONTENT_TYPE);
                if (prev == null) {
                    req.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                } else {
                    contentType = prev;
                }
            }
            if (body instanceof ReadStream) {
                ReadStream stream = (ReadStream)body;
                if (this.headers == null || !this.headers.contains(HttpHeaders.CONTENT_LENGTH)) {
                    req.setChunked(true);
                }
                Pump pump = Pump.pump((ReadStream)stream, (WriteStream)req);
                stream.exceptionHandler(err -> {
                    req.reset();
                    if (!responseFuture.isComplete()) {
                        responseFuture.fail(err);
                    }
                });
                stream.endHandler(v -> {
                    pump.stop();
                    req.end();
                });
                pump.start();
            } else {
                Buffer buffer;
                if (body instanceof Buffer) {
                    buffer = (Buffer)body;
                } else if (body instanceof MultiMap) {
                    try {
                        MultiMap attributes = (MultiMap)body;
                        boolean multipart = "multipart/form-data".equals(contentType);
                        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
                        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((io.netty.handler.codec.http.HttpRequest)request, multipart);
                        for (Map.Entry attribute : attributes) {
                            encoder.addBodyAttribute((String)attribute.getKey(), (String)attribute.getValue());
                        }
                        encoder.finalizeRequest();
                        for (String headerName : request.headers().names()) {
                            req.putHeader(headerName, request.headers().get(headerName));
                        }
                        if (encoder.isChunked()) {
                            HttpContent chunk;
                            ByteBuf content;
                            buffer = Buffer.buffer();
                            while ((content = (chunk = encoder.readChunk((ByteBufAllocator)new UnpooledByteBufAllocator(false))).content()).readableBytes() != 0) {
                                buffer.appendBuffer(Buffer.buffer((ByteBuf)content));
                            }
                        }
                        ByteBuf content = request.content();
                        buffer = Buffer.buffer((ByteBuf)content);
                    }
                    catch (Exception e) {
                        throw new VertxException((Throwable)e);
                    }
                } else {
                    buffer = body instanceof JsonObject ? Buffer.buffer((String)((JsonObject)body).encode()) : Buffer.buffer((String)Json.encode((Object)body));
                }
                req.end(buffer);
            }
        } else {
            req.end();
        }
    }
}

