/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.service;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.service.ServiceRequestConverter;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class ServiceRequest {
    private JsonObject params;
    private MultiMap headers;
    private JsonObject user;
    private JsonObject extra;

    public ServiceRequest() {
        this.init();
    }

    public ServiceRequest(JsonObject json) {
        this.init();
        ServiceRequestConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        JsonObject hdrs = json.getJsonObject("headers", null);
        if (hdrs != null) {
            this.headers = HttpHeaders.headers();
            for (Map.Entry entry : hdrs) {
                if (!(entry.getValue() instanceof String)) {
                    throw new IllegalStateException("Invalid type for message header value " + entry.getValue().getClass());
                }
                this.headers.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public ServiceRequest(JsonObject params, MultiMap headers, JsonObject user, JsonObject extra) {
        this.params = params;
        this.headers = headers;
        this.user = user;
        this.extra = extra;
    }

    public ServiceRequest(ServiceRequest other) {
        this.params = other.getParams();
        this.headers = other.getHeaders();
        this.user = other.getUser();
        this.extra = other.getExtra();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ServiceRequestConverter.toJson(this, json);
        if (this.headers != null) {
            JsonObject hJson = new JsonObject();
            this.headers.entries().forEach(entry -> hJson.put((String)entry.getKey(), entry.getValue()));
            json.put("headers", (Object)hJson);
        }
        return json;
    }

    private void init() {
        this.params = new JsonObject();
        this.headers = MultiMap.caseInsensitiveMultiMap();
        this.user = null;
        this.extra = null;
    }

    public JsonObject getParams() {
        return this.params;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public JsonObject getUser() {
        return this.user;
    }

    public JsonObject getExtra() {
        return this.extra;
    }

    @Fluent
    public ServiceRequest setParams(JsonObject params) {
        this.params = params;
        return this;
    }

    @Fluent
    public ServiceRequest setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @Fluent
    public ServiceRequest setUser(JsonObject user) {
        this.user = user;
        return this;
    }

    @Fluent
    public ServiceRequest setExtra(JsonObject extra) {
        this.extra = extra;
        return this;
    }
}

