require 'vertx-web-api-contract/parameter_type_validator'
require 'vertx-web-api-contract/request_parameter'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.validation.ParameterValidationRule
module VertxWebApiContract
  #  This function is an inner wrapper for ParameterTypeValidator inside ValidationHandler parameter maps. <b>Don't
  #  instantiate this class</b>, if you want to add custom ParameterTypeValidator to a parameter use functions in
  #  {::VertxWebApiContract::HTTPRequestValidationHandler}
  class ParameterValidationRule
    # @private
    # @param j_del [::VertxWebApiContract::ParameterValidationRule] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebApiContract::ParameterValidationRule] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ParameterValidationRule
    end
    def @@j_api_type.wrap(obj)
      ParameterValidationRule.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebApiValidation::ParameterValidationRule.java_class
    end
    #  This function return the name of the parameter expected into parameter lists
    # @return [String] name of the parameter
    def get_name
      if !block_given?
        return @j_del.java_method(:getName, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_name()"
    end
    #  This function will be called when there is only a string as parameter. It will throw a ValidationError in an
    #  error during validation occurs
    # @param [String] value list of values that will be validated
    # @return [::VertxWebApiContract::RequestParameter]
    def validate_single_param(value=nil)
      if value.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:validateSingleParam, [Java::java.lang.String.java_class]).call(value),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling validate_single_param(#{value})"
    end
    #  This function will be called when there is a List<String> that need to be validated. It must check if array is
    #  expected or not. It will throw a ValidationError in an error during validation occurs
    # @param [Array<String>] value list of values that will be validated
    # @return [::VertxWebApiContract::RequestParameter]
    def validate_array_param(value=nil)
      if value.class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:validateArrayParam, [Java::JavaUtil::List.java_class]).call(value.map { |element| element }),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling validate_array_param(#{value})"
    end
    #  Return true if parameter is optional
    # @return [true,false] true if is optional, false otherwise
    def optional?
      if !block_given?
        return @j_del.java_method(:isOptional, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling optional?()"
    end
    #  Return ParameterTypeValidator instance used inside this parameter validation rule
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def parameter_type_validator
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:parameterTypeValidator, []).call(),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling parameter_type_validator()"
    end
    #  allowEmptyValue is used in query, header, cookie and form parameters. This is its behaviour:
    #  <ol>
    #  <li>During validation, the ValidationHandler check if there's a parameter with combination of location and name
    #  as defined in this rule </li>
    #  <li>If it not exists, It will check allowEmptyValue and if there's a default value set inside
    #  ParameterTypeValidator:</li>
    #  <ul>
    #  <li>If this condition it's true, It marks as validated the parameter and returns the default value (inside
    #  RequestParameter)</li>
    #  <li>If this condition it's false, It throws ValidationException</li>
    #  </ul>
    #  <li>If the parameter exists, It checks if parameter is null or empty string:</li>
    #  <ul>
    #  <li>If allowEmptyValue it's true, It marks as validated the parameter and returns the default value if it exists
    #  (inside RequestParameter)</li>
    #  <li>If allowEmptyValue it's false, It throws ValidationException</li>
    #  </ul>
    #  </ol>
    # @return [true,false] value of allowEmptyValue
    def allow_empty_value?
      if !block_given?
        return @j_del.java_method(:allowEmptyValue, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling allow_empty_value?()"
    end
  end
end
