require 'vertx-web-api-contract/request_parameter'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.validation.ParameterTypeValidator
module VertxWebApiContract
  #  Interface for declaration of method for validate a specific parameter type.<br/>
  #  If you want to implement your own type validator, you need only to implement
  #  {::VertxWebApiContract::ParameterTypeValidator#is_valid}:
  #  <ul>
  #  <li>If parameter is valid, call  to put value (maybe modified) inside
  #  RequestParameters. The validation flow will care about set parameter name</li>
  #  <li>If parameter is invalid, throw a new ValidationException with message
  #  (<init>) and/or with
  #  ErrorType
  #  (). As for value, the
  #  validation flow will care about setting all other ValidationException fields</li>
  #  </ul>
  class ParameterTypeValidator
    # @private
    # @param j_del [::VertxWebApiContract::ParameterTypeValidator] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebApiContract::ParameterTypeValidator] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ParameterTypeValidator
    end
    def @@j_api_type.wrap(obj)
      ParameterTypeValidator.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_class
    end
    #  Function that checks if parameter is valid. It returns a RequestParameter object that will be linked inside
    #  . For more info, check .
    # @param [String] value value of parameter to test
    # @return [::VertxWebApiContract::RequestParameter] request parameter value
    def is_valid(value=nil)
      if value.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:isValid, [Java::java.lang.String.java_class]).call(value),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling is_valid(#{value})"
    end
    #  Function that checks if array of values of a specific parameter. It returns a RequestParameter object that will
    #  be linked inside . For more info, check .
    # @param [Array<String>] value list of values of parameter to test
    # @return [::VertxWebApiContract::RequestParameter] request parameter value
    def is_valid_collection(value=nil)
      if value.class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:isValidCollection, [Java::JavaUtil::List.java_class]).call(value.map { |element| element }),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling is_valid_collection(#{value})"
    end
    #  Returns default value of parameter
    # @return [Object] 
    def get_default
      if !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getDefault, []).call())
      end
      raise ArgumentError, "Invalid arguments when calling get_default()"
    end
    #  Returns true if this type validator has default value
    # @return [true,false] 
    def has_default?
      if !block_given?
        return @j_del.java_method(:hasDefault, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling has_default?()"
    end
    #  Create a new type validator for integer values
    # @overload createIntegerTypeValidator(defaultValue)
    #   @param [Fixnum] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createIntegerTypeValidator(maximum,minimum,multipleOf,defaultValue)
    #   @param [Float] maximum Maximum value. It can be null
    #   @param [Float] minimum Minimum value. It can be null
    #   @param [Float] multipleOf Multiple of value. It can be null
    #   @param [Fixnum] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createIntegerTypeValidator(exclusiveMaximum,maximum,exclusiveMinimum,minimum,multipleOf,defaultValue)
    #   @param [true,false] exclusiveMaximum If true, value will be mark as valid if value < maximum. If false, value will be mark as valid if value <= maximum. The default value is false. It can be null
    #   @param [Float] maximum Maximum value. It can be null
    #   @param [true,false] exclusiveMinimum If true, value will be mark as valid if value > minimum. If false, value will be mark as valid if value >= minimum. The default value is false. It can be null
    #   @param [Float] minimum Minimum value. It can be null
    #   @param [Float] multipleOf Multiple of value. It can be null
    #   @param [Object] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_integer_type_validator(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil)
      if param_1.class == Fixnum && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createIntegerTypeValidator, [Java::JavaLang::Integer.java_class]).call(::Vertx::Util::Utils.to_integer(param_1)),::VertxWebApiContract::ParameterTypeValidator)
      elsif param_1.class == Float && param_2.class == Float && param_3.class == Float && param_4.class == Fixnum && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createIntegerTypeValidator, [Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Integer.java_class]).call(::Vertx::Util::Utils.to_double(param_1),::Vertx::Util::Utils.to_double(param_2),::Vertx::Util::Utils.to_double(param_3),::Vertx::Util::Utils.to_integer(param_4)),::VertxWebApiContract::ParameterTypeValidator)
      elsif (param_1.class == TrueClass || param_1.class == FalseClass) && param_2.class == Float && (param_3.class == TrueClass || param_3.class == FalseClass) && param_4.class == Float && param_5.class == Float && ::Vertx::Util::unknown_type.accept?(param_6) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createIntegerTypeValidator, [Java::JavaLang::Boolean.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Boolean.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::java.lang.Object.java_class]).call(param_1,::Vertx::Util::Utils.to_double(param_2),param_3,::Vertx::Util::Utils.to_double(param_4),::Vertx::Util::Utils.to_double(param_5),::Vertx::Util::Utils.to_object(param_6)),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_integer_type_validator(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6})"
    end
    #  Create a new type validator for long integer values
    # @overload createLongTypeValidator(defaultValue)
    #   @param [Fixnum] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createLongTypeValidator(maximum,minimum,multipleOf,defaultValue)
    #   @param [Float] maximum Maximum value. It can be null
    #   @param [Float] minimum Minimum value. It can be null
    #   @param [Float] multipleOf Multiple of value. It can be null
    #   @param [Fixnum] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createLongTypeValidator(exclusiveMaximum,maximum,exclusiveMinimum,minimum,multipleOf,defaultValue)
    #   @param [true,false] exclusiveMaximum If true, value will be mark as valid if value < maximum. If false, value will be mark as valid if value <= maximum. The default value is false. It can be null
    #   @param [Float] maximum Maximum value. It can be null
    #   @param [true,false] exclusiveMinimum If true, value will be mark as valid if value > minimum. If false, value will be mark as valid if value >= minimum. The default value is false. It can be null
    #   @param [Float] minimum Minimum value. It can be null
    #   @param [Float] multipleOf Multiple of value. It can be null
    #   @param [Object] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_long_type_validator(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil)
      if param_1.class == Fixnum && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createLongTypeValidator, [Java::JavaLang::Long.java_class]).call(param_1),::VertxWebApiContract::ParameterTypeValidator)
      elsif param_1.class == Float && param_2.class == Float && param_3.class == Float && param_4.class == Fixnum && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createLongTypeValidator, [Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Long.java_class]).call(::Vertx::Util::Utils.to_double(param_1),::Vertx::Util::Utils.to_double(param_2),::Vertx::Util::Utils.to_double(param_3),param_4),::VertxWebApiContract::ParameterTypeValidator)
      elsif (param_1.class == TrueClass || param_1.class == FalseClass) && param_2.class == Float && (param_3.class == TrueClass || param_3.class == FalseClass) && param_4.class == Float && param_5.class == Float && ::Vertx::Util::unknown_type.accept?(param_6) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createLongTypeValidator, [Java::JavaLang::Boolean.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Boolean.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::java.lang.Object.java_class]).call(param_1,::Vertx::Util::Utils.to_double(param_2),param_3,::Vertx::Util::Utils.to_double(param_4),::Vertx::Util::Utils.to_double(param_5),::Vertx::Util::Utils.to_object(param_6)),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_long_type_validator(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6})"
    end
    #  Create a new type validator for float values
    # @overload createFloatTypeValidator(defaultValue)
    #   @param [Float] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createFloatTypeValidator(maximum,minimum,multipleOf,defaultValue)
    #   @param [Float] maximum Maximum value. It can be null
    #   @param [Float] minimum Minimum value. It can be null
    #   @param [Float] multipleOf Multiple of value. It can be null
    #   @param [Float] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createFloatTypeValidator(exclusiveMaximum,maximum,exclusiveMinimum,minimum,multipleOf,defaultValue)
    #   @param [true,false] exclusiveMaximum If true, value will be mark as valid if value < maximum. If false, value will be mark as valid if value <= maximum. The default value is false. It can be null
    #   @param [Float] maximum Maximum value. It can be null
    #   @param [true,false] exclusiveMinimum If true, value will be mark as valid if value > minimum. If false, value will be mark as valid if value >= minimum. The default value is false. It can be null
    #   @param [Float] minimum Minimum value. It can be null
    #   @param [Float] multipleOf Multiple of value. It can be null
    #   @param [Object] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_float_type_validator(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil)
      if param_1.class == Float && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createFloatTypeValidator, [Java::JavaLang::Float.java_class]).call(::Vertx::Util::Utils.to_float(param_1)),::VertxWebApiContract::ParameterTypeValidator)
      elsif param_1.class == Float && param_2.class == Float && param_3.class == Float && param_4.class == Float && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createFloatTypeValidator, [Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Float.java_class]).call(::Vertx::Util::Utils.to_double(param_1),::Vertx::Util::Utils.to_double(param_2),::Vertx::Util::Utils.to_double(param_3),::Vertx::Util::Utils.to_float(param_4)),::VertxWebApiContract::ParameterTypeValidator)
      elsif (param_1.class == TrueClass || param_1.class == FalseClass) && param_2.class == Float && (param_3.class == TrueClass || param_3.class == FalseClass) && param_4.class == Float && param_5.class == Float && ::Vertx::Util::unknown_type.accept?(param_6) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createFloatTypeValidator, [Java::JavaLang::Boolean.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Boolean.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::java.lang.Object.java_class]).call(param_1,::Vertx::Util::Utils.to_double(param_2),param_3,::Vertx::Util::Utils.to_double(param_4),::Vertx::Util::Utils.to_double(param_5),::Vertx::Util::Utils.to_object(param_6)),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_float_type_validator(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6})"
    end
    #  Create a new type validator for double values
    # @overload createDoubleTypeValidator(defaultValue)
    #   @param [Float] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createDoubleTypeValidator(maximum,minimum,multipleOf,defaultValue)
    #   @param [Float] maximum Maximum value. It can be null
    #   @param [Float] minimum Minimum value. It can be null
    #   @param [Float] multipleOf Multiple of value. It can be null
    #   @param [Float] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createDoubleTypeValidator(exclusiveMaximum,maximum,exclusiveMinimum,minimum,multipleOf,defaultValue)
    #   @param [true,false] exclusiveMaximum If true, value will be mark as valid if value < maximum. If false, value will be mark as valid if value <= maximum. The default value is false. It can be null
    #   @param [Float] maximum Maximum value. It can be null
    #   @param [true,false] exclusiveMinimum If true, value will be mark as valid if value > minimum. If false, value will be mark as valid if value >= minimum. The default value is false. It can be null
    #   @param [Float] minimum Minimum value. It can be null
    #   @param [Float] multipleOf Multiple of value. It can be null
    #   @param [Object] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_double_type_validator(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil)
      if param_1.class == Float && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createDoubleTypeValidator, [Java::JavaLang::Double.java_class]).call(::Vertx::Util::Utils.to_double(param_1)),::VertxWebApiContract::ParameterTypeValidator)
      elsif param_1.class == Float && param_2.class == Float && param_3.class == Float && param_4.class == Float && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createDoubleTypeValidator, [Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class]).call(::Vertx::Util::Utils.to_double(param_1),::Vertx::Util::Utils.to_double(param_2),::Vertx::Util::Utils.to_double(param_3),::Vertx::Util::Utils.to_double(param_4)),::VertxWebApiContract::ParameterTypeValidator)
      elsif (param_1.class == TrueClass || param_1.class == FalseClass) && param_2.class == Float && (param_3.class == TrueClass || param_3.class == FalseClass) && param_4.class == Float && param_5.class == Float && ::Vertx::Util::unknown_type.accept?(param_6) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createDoubleTypeValidator, [Java::JavaLang::Boolean.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Boolean.java_class,Java::JavaLang::Double.java_class,Java::JavaLang::Double.java_class,Java::java.lang.Object.java_class]).call(param_1,::Vertx::Util::Utils.to_double(param_2),param_3,::Vertx::Util::Utils.to_double(param_4),::Vertx::Util::Utils.to_double(param_5),::Vertx::Util::Utils.to_object(param_6)),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_double_type_validator(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6})"
    end
    #  Create a new string type validator
    # @overload createStringTypeValidator(defaultValue)
    #   @param [Object] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createStringTypeValidator(pattern,defaultValue)
    #   @param [String] pattern pattern that string have to match. It can be null
    #   @param [Object] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @overload createStringTypeValidator(pattern,minLength,maxLength,defaultValue)
    #   @param [String] pattern pattern that string have to match. It can be null
    #   @param [Fixnum] minLength Minimum length of string. It can be null
    #   @param [Fixnum] maxLength Maximum length of string. It can be null
    #   @param [Object] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_string_type_validator(param_1=nil,param_2=nil,param_3=nil,param_4=nil)
      if ::Vertx::Util::unknown_type.accept?(param_1) && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createStringTypeValidator, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(param_1)),::VertxWebApiContract::ParameterTypeValidator)
      elsif param_1.class == String && ::Vertx::Util::unknown_type.accept?(param_2) && !block_given? && param_3 == nil && param_4 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createStringTypeValidator, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(param_1,::Vertx::Util::Utils.to_object(param_2)),::VertxWebApiContract::ParameterTypeValidator)
      elsif param_1.class == String && param_2.class == Fixnum && param_3.class == Fixnum && ::Vertx::Util::unknown_type.accept?(param_4) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createStringTypeValidator, [Java::java.lang.String.java_class,Java::JavaLang::Integer.java_class,Java::JavaLang::Integer.java_class,Java::java.lang.Object.java_class]).call(param_1,::Vertx::Util::Utils.to_integer(param_2),::Vertx::Util::Utils.to_integer(param_3),::Vertx::Util::Utils.to_object(param_4)),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_string_type_validator(#{param_1},#{param_2},#{param_3},#{param_4})"
    end
    #  Create a boolean type validator
    # @param [Object] defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {::VertxWebApiContract::ParameterValidationRule#allow_empty_value} true. It can be null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_boolean_type_validator(defaultValue=nil)
      if ::Vertx::Util::unknown_type.accept?(defaultValue) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createBooleanTypeValidator, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(defaultValue)),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_boolean_type_validator(#{defaultValue})"
    end
    #  Create an enum type validator
    # @param [Array<String>] allowedValues allowed values. It <b>can't be</b> null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_string_enum_type_validator(allowedValues=nil)
      if allowedValues.class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createStringEnumTypeValidator, [Java::JavaUtil::List.java_class]).call(allowedValues.map { |element| element }),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_string_enum_type_validator(#{allowedValues})"
    end
    #  Create an enum type validator
    # @param [Array<String>] allowedValues allowed values. It <b>can't be</b> null
    # @param [::VertxWebApiContract::ParameterTypeValidator] innerValidator After check if value is one of the lists, you can pass the value to an inner validator. It can be null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_enum_type_validator_with_inner_validator(allowedValues=nil,innerValidator=nil)
      if allowedValues.class == Array && innerValidator.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createEnumTypeValidatorWithInnerValidator, [Java::JavaUtil::List.java_class,Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_class]).call(allowedValues.map { |element| element },innerValidator.j_del),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_enum_type_validator_with_inner_validator(#{allowedValues},#{innerValidator})"
    end
    #  Create an array type validator
    # @param [::VertxWebApiContract::ParameterTypeValidator] arrayMembersValidator Type validator that describe array items. It <b>can't be</b> null
    # @param [String] collectionFormat String that represent a ContainerSerializationStyle. Check out ContainerSerializationStyle for more informations. The default value is "csv". It can be null
    # @param [Fixnum] maxItems Maximum items in array. It can be null
    # @param [Fixnum] minItems Minimum items in array. It can be null
    # @return [::VertxWebApiContract::ParameterTypeValidator] 
    def self.create_array_type_validator(arrayMembersValidator=nil,collectionFormat=nil,maxItems=nil,minItems=nil)
      if arrayMembersValidator.class.method_defined?(:j_del) && !block_given? && collectionFormat == nil && maxItems == nil && minItems == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createArrayTypeValidator, [Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_class]).call(arrayMembersValidator.j_del),::VertxWebApiContract::ParameterTypeValidator)
      elsif arrayMembersValidator.class.method_defined?(:j_del) && collectionFormat.class == String && maxItems.class == Fixnum && minItems.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_method(:createArrayTypeValidator, [Java::IoVertxExtWebApiValidation::ParameterTypeValidator.java_class,Java::java.lang.String.java_class,Java::JavaLang::Integer.java_class,Java::JavaLang::Integer.java_class]).call(arrayMembersValidator.j_del,collectionFormat,::Vertx::Util::Utils.to_integer(maxItems),::Vertx::Util::Utils.to_integer(minItems)),::VertxWebApiContract::ParameterTypeValidator)
      end
      raise ArgumentError, "Invalid arguments when calling create_array_type_validator(#{arrayMembersValidator},#{collectionFormat},#{maxItems},#{minItems})"
    end
  end
end
