/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/request_parameter */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JRequestParameter = Java.type('io.vertx.ext.web.api.RequestParameter');

/**
 Request parameter holder

 @class
*/
var RequestParameter = function(j_val) {

  var j_requestParameter = j_val;
  var that = this;

  /**
   Set parameter name

   @public
   @param name {string} 
   */
  this.setName = function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_requestParameter["setName(java.lang.String)"](name);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set value

   @public
   @param value {Object} 
   */
  this.setValue = function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] !== 'function') {
      j_requestParameter["setValue(java.lang.Object)"](utils.convParamTypeUnknown(value));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get parameter name

   @public

   @return {string} 
   */
  this.getName = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getName()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   If value is a map of fields, it returns keys of map, otherwise it returns null

   @public

   @return {Array.<string>} 
   */
  this.getObjectKeys = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getObjectKeys()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   If value is a map of fields, it returns value of field with key provided, otherwise it returns null

   @public
   @param key {string} 
   @return {RequestParameter} 
   */
  this.getObjectValue = function(key) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameter["getObjectValue(java.lang.String)"](key));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a map of fields

   @public

   @return {boolean} 
   */
  this.isObject = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isObject()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a list, otherwise it returns value

   @public

   @return {Array.<RequestParameter>} 
   */
  this.getArray = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_requestParameter["getArray()"](), RequestParameter);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is an array

   @public

   @return {boolean} 
   */
  this.isArray = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isArray()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a String, otherwise it returns value

   @public

   @return {string} 
   */
  this.getString = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getString()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a String instance

   @public

   @return {boolean} 
   */
  this.isString = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isString()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not an Integer, otherwise it returns value

   @public

   @return {number} 
   */
  this.getInteger = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getInteger()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is an Integer instance

   @public

   @return {boolean} 
   */
  this.isInteger = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isInteger()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a Long, otherwise it returns value

   @public

   @return {number} 
   */
  this.getLong = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnLong(j_requestParameter["getLong()"]());
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a Long instance

   @public

   @return {boolean} 
   */
  this.isLong = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isLong()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a Float, otherwise it returns value

   @public

   @return {number} 
   */
  this.getFloat = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getFloat()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a Float instance

   @public

   @return {boolean} 
   */
  this.isFloat = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isFloat()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a Double, otherwise it returns value

   @public

   @return {number} 
   */
  this.getDouble = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getDouble()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a Double instance

   @public

   @return {boolean} 
   */
  this.isDouble = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isDouble()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a Boolean, otherwise it returns value

   @public

   @return {boolean} 
   */
  this.getBoolean = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["getBoolean()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a Boolean instance

   @public

   @return {boolean} 
   */
  this.isBoolean = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isBoolean()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a JsonObject, otherwise it returns value

   @public

   @return {Object} 
   */
  this.getJsonObject = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_requestParameter["getJsonObject()"]());
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a JsonObject instance

   @public

   @return {boolean} 
   */
  this.isJsonObject = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isJsonObject()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns null if value is not a JsonArray, otherwise it returns value

   @public

   @return {todo} 
   */
  this.getJsonArray = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_requestParameter["getJsonArray()"]());
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value of RequestParameter is a JsonArray instance

   @public

   @return {boolean} 
   */
  this.isJsonArray = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isJsonArray()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if value is null

   @public

   @return {boolean} 
   */
  this.isNull = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isNull()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Alias of {@link RequestParameter#isNull}

   @public

   @return {boolean} 
   */
  this.isEmpty = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameter["isEmpty()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Merge this request parameter with another one. Note: the parameter passed by argument has the priority

   @public
   @param otherParameter {RequestParameter} 
   @return {RequestParameter} 
   */
  this.merge = function(otherParameter) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameter["merge(io.vertx.ext.web.api.RequestParameter)"](otherParameter._jdel));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_requestParameter;
};

RequestParameter._jclass = utils.getJavaClass("io.vertx.ext.web.api.RequestParameter");
RequestParameter._jtype = {
  accept: function(obj) {
    return RequestParameter._jclass.isInstance(obj._jdel);
  },
  wrap: function(jdel) {
    var obj = Object.create(RequestParameter.prototype, {});
    RequestParameter.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RequestParameter._create = function(jdel) {
  var obj = Object.create(RequestParameter.prototype, {});
  RequestParameter.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-web-api-contract-js/request_parameter
 @param name {string} 
 @param value {Object} 
 @return {RequestParameter}
 */
RequestParameter.create = function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] !== 'function') {
    return utils.convReturnVertxGen(RequestParameter, JRequestParameter["create(java.lang.Object)"](utils.convParamTypeUnknown(__args[0])));
  }else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] !== 'function') {
    return utils.convReturnVertxGen(RequestParameter, JRequestParameter["create(java.lang.String,java.lang.Object)"](__args[0], utils.convParamTypeUnknown(__args[1])));
  } else throw new TypeError('function invoked with invalid arguments');
};

module.exports = RequestParameter;