/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ValidationException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLTypeValidator
implements ParameterTypeValidator {
    private Validator schemaValidator;

    private XMLTypeValidator(Validator schemaValidator) {
        this.schemaValidator = schemaValidator;
    }

    @Override
    public RequestParameter isValid(String value) throws ValidationException {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(value);
            this.schemaValidator.validate(new DOMSource(document));
            return RequestParameter.create(document);
        }
        catch (Exception e) {
            throw ValidationException.ValidationExceptionFactory.generateInvalidXMLBodyException(e.getMessage());
        }
    }

    public static class XMLTypeValidatorFactory {
        public static XMLTypeValidator createXMLTypeValidator(String xmlSchema) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource xmlSchemaSource = new StreamSource(new StringReader(xmlSchema));
            try {
                return new XMLTypeValidator(factory.newSchema(xmlSchemaSource).newValidator());
            }
            catch (SAXException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

