/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.stomp.StompClientOptions;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class StompClientOptionsConverter {
    public static void fromJson(JsonObject json, StompClientOptions obj) {
        if (json.getValue("acceptedVersions") instanceof JsonArray) {
            ArrayList<String> list = new ArrayList<String>();
            json.getJsonArray("acceptedVersions").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setAcceptedVersions(list);
        }
        if (json.getValue("autoComputeContentLength") instanceof Boolean) {
            obj.setAutoComputeContentLength((Boolean)json.getValue("autoComputeContentLength"));
        }
        if (json.getValue("bypassHostHeader") instanceof Boolean) {
            obj.setBypassHostHeader((Boolean)json.getValue("bypassHostHeader"));
        }
        if (json.getValue("heartbeat") instanceof JsonObject) {
            obj.setHeartbeat(((JsonObject)json.getValue("heartbeat")).copy());
        }
        if (json.getValue("host") instanceof String) {
            obj.setHost((String)json.getValue("host"));
        }
        if (json.getValue("login") instanceof String) {
            obj.setLogin((String)json.getValue("login"));
        }
        if (json.getValue("passcode") instanceof String) {
            obj.setPasscode((String)json.getValue("passcode"));
        }
        if (json.getValue("port") instanceof Number) {
            obj.setPort(((Number)json.getValue("port")).intValue());
        }
        if (json.getValue("trailingLine") instanceof Boolean) {
            obj.setTrailingLine((Boolean)json.getValue("trailingLine"));
        }
        if (json.getValue("useStompFrame") instanceof Boolean) {
            obj.setUseStompFrame((Boolean)json.getValue("useStompFrame"));
        }
        if (json.getValue("virtualHost") instanceof String) {
            obj.setVirtualHost((String)json.getValue("virtualHost"));
        }
    }

    public static void toJson(StompClientOptions obj, JsonObject json) {
        if (obj.getAcceptedVersions() != null) {
            json.put("acceptedVersions", new JsonArray(obj.getAcceptedVersions().stream().map(item -> item).collect(Collectors.toList())));
        }
        json.put("autoComputeContentLength", Boolean.valueOf(obj.isAutoComputeContentLength()));
        json.put("bypassHostHeader", Boolean.valueOf(obj.isBypassHostHeader()));
        if (obj.getHeartbeat() != null) {
            json.put("heartbeat", obj.getHeartbeat());
        }
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        if (obj.getLogin() != null) {
            json.put("login", obj.getLogin());
        }
        if (obj.getPasscode() != null) {
            json.put("passcode", obj.getPasscode());
        }
        json.put("port", Integer.valueOf(obj.getPort()));
        json.put("trailingLine", Boolean.valueOf(obj.isTrailingLine()));
        json.put("useStompFrame", Boolean.valueOf(obj.isUseStompFrame()));
        if (obj.getVirtualHost() != null) {
            json.put("virtualHost", obj.getVirtualHost());
        }
    }
}

