/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.sqlclient.SqlConnectOptionsConverter;
import io.vertx.sqlclient.spi.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Predicate;

@DataObject
@JsonGen(publicConverter=false)
public class SqlConnectOptions {
    public static final int DEFAULT_RECONNECT_ATTEMPTS = 0;
    public static final long DEFAULT_RECONNECT_INTERVAL = 1000L;
    public static final boolean DEFAULT_CACHE_PREPARED_STATEMENTS = false;
    public static final int DEFAULT_PREPARED_STATEMENT_CACHE_MAX_SIZE = 256;
    public static final int DEFAULT_PREPARED_STATEMENT_CACHE_SQL_LIMIT = 2048;
    public static final Predicate<String> DEFAULT_PREPARED_STATEMENT_CACHE_FILTER = sql -> sql.length() < 2048;
    public static final String DEFAULT_METRICS_NAME = "";
    private String host;
    private int port;
    private String user;
    private String password;
    private String database;
    private boolean cachePreparedStatements;
    private int preparedStatementCacheMaxSize;
    private Predicate<String> preparedStatementCacheSqlFilter;
    private Map<String, String> properties;
    private TracingPolicy tracingPolicy;
    private int reconnectAttempts;
    private long reconnectInterval;
    private String metricsName;
    private ClientSSLOptions sslOptions;

    public static SqlConnectOptions fromUri(String connectionUri) throws IllegalArgumentException, ServiceConfigurationError {
        ArrayList<SqlConnectOptions> candidates = new ArrayList<SqlConnectOptions>(1);
        for (Driver d : ServiceLoader.load(Driver.class)) {
            SqlConnectOptions options = d.parseConnectionUri(connectionUri);
            if (options == null) continue;
            candidates.add(options);
        }
        if (candidates.size() == 0) {
            throw new ServiceConfigurationError("No implementations of " + String.valueOf(Driver.class) + " found that accept connection uri " + connectionUri);
        }
        if (candidates.size() > 1) {
            throw new ServiceConfigurationError("Multiple implementations of " + String.valueOf(Driver.class) + " found: " + String.valueOf(candidates));
        }
        return (SqlConnectOptions)candidates.get(0);
    }

    public SqlConnectOptions() {
        this.init();
    }

    public SqlConnectOptions(JsonObject json) {
        this.init();
        SqlConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public SqlConnectOptions(SqlConnectOptions other) {
        this.host = other.host;
        this.port = other.port;
        this.user = other.user;
        this.password = other.password;
        this.database = other.database;
        this.cachePreparedStatements = other.cachePreparedStatements;
        this.preparedStatementCacheMaxSize = other.preparedStatementCacheMaxSize;
        this.preparedStatementCacheSqlFilter = other.preparedStatementCacheSqlFilter;
        if (other.properties != null) {
            this.properties = new HashMap<String, String>(other.properties);
        }
        this.tracingPolicy = other.tracingPolicy;
        this.reconnectAttempts = other.reconnectAttempts;
        this.reconnectInterval = other.reconnectInterval;
        this.metricsName = other.metricsName;
        ClientSSLOptions sslOptions = other.sslOptions;
        this.sslOptions = sslOptions != null ? sslOptions.copy() : null;
    }

    public String getHost() {
        return this.host;
    }

    public SqlConnectOptions setHost(String host) {
        Objects.requireNonNull(host, "Host can not be null");
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public SqlConnectOptions setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port should range in 0-65535");
        }
        this.port = port;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public SqlConnectOptions setUser(String user) {
        Objects.requireNonNull(user, "User account can not be null");
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public SqlConnectOptions setPassword(String password) {
        Objects.requireNonNull(password, "Password can not be null");
        this.password = password;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public SqlConnectOptions setDatabase(String database) {
        Objects.requireNonNull(database, "Database name can not be null");
        this.database = database;
        return this;
    }

    public boolean getCachePreparedStatements() {
        return this.cachePreparedStatements;
    }

    public SqlConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        this.cachePreparedStatements = cachePreparedStatements;
        return this;
    }

    public int getPreparedStatementCacheMaxSize() {
        return this.preparedStatementCacheMaxSize;
    }

    public SqlConnectOptions setPreparedStatementCacheMaxSize(int preparedStatementCacheMaxSize) {
        this.preparedStatementCacheMaxSize = preparedStatementCacheMaxSize;
        return this;
    }

    @GenIgnore
    public Predicate<String> getPreparedStatementCacheSqlFilter() {
        return this.preparedStatementCacheSqlFilter;
    }

    @GenIgnore
    public SqlConnectOptions setPreparedStatementCacheSqlFilter(Predicate<String> predicate) {
        this.preparedStatementCacheSqlFilter = predicate;
        return this;
    }

    public SqlConnectOptions setPreparedStatementCacheSqlLimit(int preparedStatementCacheSqlLimit) {
        return this.setPreparedStatementCacheSqlFilter(sql -> sql.length() <= preparedStatementCacheSqlLimit);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public SqlConnectOptions setProperties(Map<String, String> properties) {
        Objects.requireNonNull(properties, "Properties can not be null");
        this.properties = properties;
        return this;
    }

    @GenIgnore
    public SqlConnectOptions addProperty(String key, String value) {
        Objects.requireNonNull(key, "Property key can not be null");
        Objects.requireNonNull(value, "Property value can not be null");
        this.properties.put(key, value);
        return this;
    }

    @GenIgnore
    public SocketAddress getSocketAddress() {
        return SocketAddress.inetSocketAddress((int)this.getPort(), (String)this.getHost());
    }

    public TracingPolicy getTracingPolicy() {
        return this.tracingPolicy;
    }

    public SqlConnectOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        this.tracingPolicy = tracingPolicy;
        return this;
    }

    public boolean isUsingDomainSocket() {
        return false;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public SqlConnectOptions setReconnectAttempts(int attempts) {
        if (attempts < -1) {
            throw new IllegalArgumentException("reconnect attempts must be >= -1");
        }
        this.reconnectAttempts = attempts;
        return this;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public SqlConnectOptions setReconnectInterval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("reconnect interval must be >= 1");
        }
        this.reconnectInterval = interval;
        return this;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public SqlConnectOptions setMetricsName(String metricsName) {
        this.metricsName = metricsName;
        return this;
    }

    public ClientSSLOptions getSslOptions() {
        return this.sslOptions;
    }

    public SqlConnectOptions setSslOptions(ClientSSLOptions sslOptions) {
        this.sslOptions = sslOptions;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        SqlConnectOptionsConverter.toJson(this, json);
        return json;
    }

    protected void init() {
        this.cachePreparedStatements = false;
        this.preparedStatementCacheMaxSize = 256;
        this.preparedStatementCacheSqlFilter = DEFAULT_PREPARED_STATEMENT_CACHE_FILTER;
        this.properties = new HashMap<String, String>(4);
        this.reconnectAttempts = 0;
        this.reconnectInterval = 1000L;
    }

    public SqlConnectOptions merge(JsonObject other) {
        JsonObject json = this.toJson();
        json.mergeIn(other);
        return new SqlConnectOptions(json);
    }
}

