/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.internal.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.VertxException;
import io.vertx.sqlclient.internal.command.CommandBase;

public class CommandResponse<R> {
    public CommandBase<R> cmd;
    private final AsyncResult<R> res;

    public static <R> CommandResponse<R> failure(String msg) {
        return CommandResponse.failure((Throwable)VertxException.noStackTrace((String)msg));
    }

    public static <R> CommandResponse<R> failure(Throwable cause) {
        return new CommandResponse<R>(Future.failedFuture((Throwable)cause));
    }

    public static <R> CommandResponse<R> success(R result) {
        return new CommandResponse<R>(Future.succeededFuture(result));
    }

    public CommandResponse(AsyncResult<R> res) {
        this.res = res;
    }

    public AsyncResult<R> toAsyncResult() {
        return this.res;
    }

    public void fire() {
        if (this.cmd.handler != null) {
            this.cmd.handler.complete(this.res.result(), this.res.cause());
        }
    }
}

