/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.cache.PreparedStatementCache;
import io.vertx.sqlclient.impl.codec.InvalidCachedStatementEvent;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.PreparedStatement;
import io.vertx.sqlclient.internal.command.CloseConnectionCommand;
import io.vertx.sqlclient.internal.command.CloseStatementCommand;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.CommandResponse;
import io.vertx.sqlclient.internal.command.CompositeCommand;
import io.vertx.sqlclient.internal.command.ExtendedQueryCommand;
import io.vertx.sqlclient.internal.command.PrepareStatementCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.Predicate;

public abstract class SocketConnectionBase
implements Connection {
    public static final Logger logger = LoggerFactory.getLogger(SocketConnectionBase.class);
    private static final String PENDING_CMD_CONNECTION_CORRUPT_MSG = "Pending requests failed to be sent due to connection has been closed.";
    private final ClientMetrics metrics;
    protected final PreparedStatementCache psCache;
    protected final ContextInternal context;
    private final Predicate<String> preparedStatementCacheSqlFilter;
    private Connection.Holder holder;
    private final int pipeliningLimit;
    private final ArrayDeque<CommandBase<?>> pending = new ArrayDeque();
    private boolean executing;
    private int inflight;
    private boolean paused;
    protected final NetSocketInternal socket;
    protected Status status = Status.CONNECTED;

    public SocketConnectionBase(NetSocketInternal socket, ClientMetrics metrics, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, ContextInternal context) {
        this.socket = socket;
        this.context = context;
        this.pipeliningLimit = pipeliningLimit;
        this.metrics = metrics;
        this.paused = false;
        this.psCache = cachePreparedStatements ? new PreparedStatementCache(preparedStatementCacheSize) : null;
        this.preparedStatementCacheSqlFilter = preparedStatementCacheSqlFilter;
    }

    protected abstract SqlConnectOptions connectOptions();

    @Override
    public ClientMetrics metrics() {
        return this.metrics;
    }

    @Override
    public int pipeliningLimit() {
        return this.pipeliningLimit;
    }

    @Override
    public TracingPolicy tracingPolicy() {
        return this.connectOptions().getTracingPolicy();
    }

    @Override
    public String database() {
        return this.connectOptions().getDatabase();
    }

    @Override
    public String user() {
        return this.connectOptions().getUser();
    }

    @Override
    public DatabaseMetadata getDatabaseMetaData() {
        return null;
    }

    public Context context() {
        return this.context;
    }

    public void init() {
        this.socket.closeHandler(this::handleClosed);
        this.socket.exceptionHandler(this::handleException);
        this.socket.messageHandler(msg -> {
            try {
                this.handleMessage(msg);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        });
        this.socket.readCompletionHandler(this::handleReadComplete);
    }

    public NetSocketInternal socket() {
        return this.socket;
    }

    @Override
    public SocketAddress server() {
        return this.socket.remoteAddress();
    }

    @Override
    public boolean isSsl() {
        return this.socket.isSsl();
    }

    @Override
    public boolean isValid() {
        return this.status == Status.CONNECTED;
    }

    @Override
    public void init(Connection.Holder holder) {
        ContextInternal context = (ContextInternal)Vertx.currentContext();
        if (context == null || context.nettyEventLoop() != this.context.nettyEventLoop()) {
            throw new IllegalStateException();
        }
        if (this.status != Status.CONNECTED) {
            throw new IllegalStateException();
        }
        this.holder = holder;
    }

    @Override
    public int getProcessId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSecretKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close(Connection.Holder holder, Completable<Void> promise) {
        if (Vertx.currentContext() == this.context) {
            Channel ch = this.socket.channelHandlerContext().channel();
            if (this.status == Status.CONNECTED) {
                this.status = Status.CLOSING;
                this.pending.add(CloseConnectionCommand.INSTANCE);
                this.checkPending();
            }
            ch.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> promise.succeed()));
        } else {
            this.context.runOnContext(v -> this.close(holder, promise));
        }
    }

    @Override
    public <R> void schedule(CommandBase<R> cmd, Completable<R> handler) {
        this.context.emit(v -> this.doSchedule(cmd, handler));
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Completable<R> handler) {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        Context context = Vertx.currentContext();
        if (context != this.context) {
            throw new IllegalStateException();
        }
        cmd.handler = handler;
        if (this.status == Status.CONNECTED) {
            if (cmd instanceof CompositeCommand) {
                CompositeCommand composite = (CompositeCommand)cmd;
                List<CommandBase<?>> commands = composite.commands();
                this.pending.addAll(commands);
                composite.handler.succeed();
            } else {
                this.pending.add(cmd);
            }
            this.checkPending();
        } else {
            cmd.fail((Throwable)VertxException.noStackTrace((String)("Connection is not active now, current status: " + String.valueOf((Object)this.status))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPending() {
        if (this.executing) {
            return;
        }
        try {
            PrepareStatementCommand cmd;
            this.executing = true;
            ChannelHandlerContext ctx = this.socket.channelHandlerContext();
            int written = 0;
            while (!this.paused && this.inflight < this.pipeliningLimit && (cmd = this.pending.poll()) != null) {
                ++this.inflight;
                if (cmd instanceof ExtendedQueryCommand) {
                    ExtendedQueryCommand queryCmd = (ExtendedQueryCommand)((Object)cmd);
                    if (queryCmd.ps == null && this.psCache != null) {
                        queryCmd.ps = this.psCache.get(queryCmd.sql());
                    }
                    if (queryCmd.ps == null) {
                        CloseStatementCommand closeCmd;
                        boolean cache;
                        boolean bl = cache = this.psCache != null && this.preparedStatementCacheSqlFilter.test(queryCmd.sql());
                        if (cache && (closeCmd = this.evictStatementIfNecessary()) != null) {
                            ++this.inflight;
                            ++written;
                            ctx.write((Object)closeCmd, ctx.voidPromise());
                        }
                        PrepareStatementCommand prepareCmd = this.prepareCommand(queryCmd, cache, false);
                        this.paused = true;
                        ++this.inflight;
                        cmd = prepareCmd;
                    } else {
                        String msg = queryCmd.prepare();
                        if (msg != null) {
                            --this.inflight;
                            queryCmd.fail((Throwable)VertxException.noStackTrace((String)msg));
                            continue;
                        }
                    }
                }
                ++written;
                ctx.write(cmd, ctx.voidPromise());
            }
            if (written > 0) {
                ctx.flush();
            }
        }
        finally {
            this.executing = false;
        }
    }

    private PrepareStatementCommand prepareCommand(ExtendedQueryCommand<?> queryCmd, boolean cache, boolean sendParameterTypes) {
        PrepareStatementCommand prepareCmd = new PrepareStatementCommand(queryCmd.sql(), null, cache, sendParameterTypes ? queryCmd.parameterTypes() : null);
        prepareCmd.handler = (ps, cause) -> {
            this.paused = false;
            if (cause == null) {
                if (cache) {
                    this.cacheStatement((PreparedStatement)ps);
                }
                queryCmd.ps = ps;
                String msg = queryCmd.prepare();
                if (msg != null) {
                    --this.inflight;
                    queryCmd.fail((Throwable)VertxException.noStackTrace((String)msg));
                } else {
                    ChannelHandlerContext ctx = this.socket.channelHandlerContext();
                    ctx.write((Object)queryCmd, ctx.voidPromise());
                    ctx.flush();
                }
            } else if (this.isIndeterminatePreparedStatementError(cause) && !sendParameterTypes) {
                ChannelHandlerContext ctx = this.socket.channelHandlerContext();
                ctx.write((Object)this.prepareCommand(queryCmd, false, true), ctx.voidPromise());
                ctx.flush();
            } else {
                --this.inflight;
                queryCmd.fail(cause);
            }
        };
        return prepareCmd;
    }

    protected void handleMessage(Object msg) {
        if (msg instanceof CommandResponse) {
            --this.inflight;
            CommandResponse resp = (CommandResponse)msg;
            resp.fire();
        } else if (msg instanceof InvalidCachedStatementEvent) {
            InvalidCachedStatementEvent event = (InvalidCachedStatementEvent)msg;
            this.removeCachedStatement(event.sql());
        }
    }

    private void handleReadComplete(Void v) {
        this.checkPending();
    }

    protected void handleEvent(Object event) {
        if (this.holder != null) {
            this.holder.handleEvent(event);
        }
    }

    private CloseStatementCommand evictStatementIfNecessary() {
        if (this.psCache != null && this.psCache.isFull()) {
            PreparedStatement evicted = this.psCache.evict();
            CloseStatementCommand closeCmd = new CloseStatementCommand(evicted);
            closeCmd.handler = (res, err) -> {
                if (err != null) {
                    logger.error((Object)"Error when closing cached prepared statement", err);
                }
            };
            return closeCmd;
        }
        return null;
    }

    private void cacheStatement(PreparedStatement preparedStatement) {
        if (this.psCache != null) {
            List<PreparedStatement> evictedList = this.psCache.put(preparedStatement);
            assert (evictedList.size() == 0);
        }
    }

    private void removeCachedStatement(String sql) {
        if (this.psCache != null) {
            this.psCache.remove(sql);
        }
    }

    private void handleClosed(Void v) {
        this.handleClose(null);
    }

    protected void handleException(Throwable t) {
        if (t instanceof DecoderException) {
            DecoderException err = (DecoderException)t;
            t = err.getCause();
        }
        this.handleClose(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportException(Throwable t) {
        SocketConnectionBase socketConnectionBase = this;
        synchronized (socketConnectionBase) {
            if (this.holder != null) {
                this.holder.handleException(t);
            }
        }
    }

    protected void handleClose(Throwable t) {
        if (this.status != Status.CLOSED) {
            CommandBase<?> cmd;
            VertxException cause;
            this.status = Status.CLOSED;
            if (this.metrics != null) {
                this.metrics.close();
            }
            if (t != null) {
                this.reportException(t);
            }
            VertxException vertxException = cause = t == null ? VertxException.noStackTrace((String)PENDING_CMD_CONNECTION_CORRUPT_MSG) : new VertxException(PENDING_CMD_CONNECTION_CORRUPT_MSG, t);
            while ((cmd = this.pending.poll()) != null) {
                CommandBase<?> c = cmd;
                this.context.runOnContext(arg_0 -> SocketConnectionBase.lambda$handleClose$6(c, (Throwable)cause, arg_0));
            }
            if (this.holder != null) {
                this.holder.handleClosed();
            }
        }
    }

    public boolean pipeliningEnabled() {
        return this.pipeliningLimit > 1;
    }

    public void suspendPipeline() {
        this.paused = true;
    }

    public void resumePipeline() {
        this.paused = false;
    }

    private static /* synthetic */ void lambda$handleClose$6(CommandBase c, Throwable cause, Void v) {
        c.fail(cause);
    }

    public static enum Status {
        CLOSED,
        CONNECTED,
        CLOSING;

    }
}

