/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.accumulator;

import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.impl.accumulator.RowAccumulator;
import java.util.NoSuchElementException;
import java.util.function.IntUnaryOperator;

public class ChunkedRowAccumulator<T>
implements RowAccumulator<T> {
    private static final int FIRST_CHUNK_CAPACITY = 10;
    private final IntUnaryOperator extensionPolicy;
    private final Object[] firstChunk;
    private Object[] lastChunk;
    private int count;

    public ChunkedRowAccumulator(IntUnaryOperator extensionPolicy) {
        this.extensionPolicy = extensionPolicy;
        this.lastChunk = this.newChunk(10);
        this.firstChunk = this.lastChunk;
        this.count = 0;
    }

    private Object[] newChunk(int capacity) {
        return new Object[capacity + 1];
    }

    @Override
    public void accept(T item) {
        int chunkCapacity = ChunkedRowAccumulator.chunkCapacity(this.lastChunk);
        if (this.count == chunkCapacity) {
            Object[] chunk = this.newChunk(this.extensionPolicy.applyAsInt(chunkCapacity));
            chunk[0] = item;
            this.lastChunk[chunkCapacity] = chunk;
            this.lastChunk = chunk;
            this.count = 1;
        } else {
            this.lastChunk[this.count] = item;
            ++this.count;
        }
    }

    private static int chunkCapacity(Object[] chunk) {
        return chunk.length - 1;
    }

    @Override
    public RowIterator<T> iterator() {
        return ChunkedRowAccumulator.rowIterator(this.firstChunk, this.lastChunk, this.count);
    }

    private static <U> RowIterator<U> rowIterator(final Object[] firstChunk, final Object[] lastChunk, final int count) {
        return new RowIterator<U>(){
            Object[] curr;
            int idx;
            {
                this.curr = firstChunk;
                this.idx = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.curr != lastChunk) {
                    int chunkCapacity = ChunkedRowAccumulator.chunkCapacity(this.curr);
                    return this.idx < chunkCapacity || this.curr[chunkCapacity] != null;
                }
                return this.idx < count;
            }

            @Override
            public U next() {
                if (this.curr != lastChunk) {
                    int chunkCapacity = ChunkedRowAccumulator.chunkCapacity(this.curr);
                    if (this.idx == chunkCapacity) {
                        Object[] next = (Object[])this.curr[chunkCapacity];
                        if (next == null) {
                            throw new NoSuchElementException();
                        }
                        this.curr = next;
                        this.idx = 0;
                    }
                } else if (this.idx == count) {
                    throw new NoSuchElementException();
                }
                Object item = this.value();
                ++this.idx;
                return item;
            }

            private U value() {
                return this.curr[this.idx];
            }
        };
    }
}

