/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.TupleInternal;
import java.util.Arrays;
import java.util.Collection;

public class ArrayTuple
extends TupleInternal {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    public static Tuple EMPTY = new ArrayTuple(0);
    private Object[] values;
    private int size;

    public ArrayTuple(int len) {
        this.values = len == 0 ? EMPTY_ARRAY : new Object[len];
        this.size = 0;
    }

    public ArrayTuple(Collection<?> c) {
        this.values = new Object[c.size()];
        this.size = 0;
        for (Object elt : c) {
            this.addValue(elt);
        }
    }

    public ArrayTuple(Tuple tuple) {
        this.values = new Object[tuple.size()];
        this.size = this.values.length;
        for (int idx = 0; idx < this.size; ++idx) {
            this.values[idx] = tuple.getValue(idx);
        }
    }

    @Override
    public Object getValueInternal(int pos) {
        return pos >= 0 && pos < this.size ? this.values[pos] : null;
    }

    @Override
    public Tuple addValue(Object value) {
        if (this.size >= this.values.length) {
            Object[] copy = new Object[(this.values.length << 1) + 1];
            System.arraycopy(this.values, 0, copy, 0, this.values.length);
            this.values = copy;
        }
        this.values[this.size++] = value;
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public void setValue(int pos, Object value) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException("Invalid position " + pos + ": must be >= 0");
        }
        if (pos >= this.size) {
            throw new IndexOutOfBoundsException("Invalid position " + pos + ": must be < " + this.size);
        }
        this.values[pos] = value;
    }
}

