/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.redis.client;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicationConnectOptions;
import io.vertx.redis.client.RedisSentinelConnectOptions;
import io.vertx.redis.client.RedisStandaloneConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.MaybeHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.redis.client.RedisConnection;
import java.util.List;
import java.util.function.Supplier;

@RxGen(value=io.vertx.redis.client.Redis.class)
public class Redis
implements RxDelegate {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg(obj -> new Redis((io.vertx.redis.client.Redis)obj), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;
    private static final TypeArg<RedisConnection> TYPE_ARG_0 = new TypeArg(o1 -> RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    public Redis(Object delegate) {
        this.delegate = (io.vertx.redis.client.Redis)delegate;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    public static Redis createClient(io.vertx.rxjava3.core.Vertx vertx) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.rxjava3.core.Vertx vertx, String connectionString) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (String)connectionString));
        return ret;
    }

    public static Redis createClient(io.vertx.rxjava3.core.Vertx vertx, RedisOptions options) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options));
        return ret;
    }

    public static Redis createStandaloneClient(io.vertx.rxjava3.core.Vertx vertx, RedisOptions options, final Supplier<Single<RedisStandaloneConnectOptions>> connectOptions) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createStandaloneClient((Vertx)vertx.getDelegate(), (RedisOptions)options, (Supplier)new Supplier<Future<RedisStandaloneConnectOptions>>(){

            @Override
            public Future<RedisStandaloneConnectOptions> get() {
                Single ret = (Single)connectOptions.get();
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        }));
        return ret;
    }

    public static Redis createReplicationClient(io.vertx.rxjava3.core.Vertx vertx, RedisOptions options, final Supplier<Single<RedisReplicationConnectOptions>> connectOptions) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createReplicationClient((Vertx)vertx.getDelegate(), (RedisOptions)options, (Supplier)new Supplier<Future<RedisReplicationConnectOptions>>(){

            @Override
            public Future<RedisReplicationConnectOptions> get() {
                Single ret = (Single)connectOptions.get();
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        }));
        return ret;
    }

    public static Redis createSentinelClient(io.vertx.rxjava3.core.Vertx vertx, RedisOptions options, final Supplier<Single<RedisSentinelConnectOptions>> connectOptions) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createSentinelClient((Vertx)vertx.getDelegate(), (RedisOptions)options, (Supplier)new Supplier<Future<RedisSentinelConnectOptions>>(){

            @Override
            public Future<RedisSentinelConnectOptions> get() {
                Single ret = (Single)connectOptions.get();
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        }));
        return ret;
    }

    public static Redis createClusterClient(io.vertx.rxjava3.core.Vertx vertx, RedisOptions options, final Supplier<Single<RedisClusterConnectOptions>> connectOptions) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClusterClient((Vertx)vertx.getDelegate(), (RedisOptions)options, (Supplier)new Supplier<Future<RedisClusterConnectOptions>>(){

            @Override
            public Future<RedisClusterConnectOptions> get() {
                Single ret = (Single)connectOptions.get();
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        }));
        return ret;
    }

    public Single<RedisConnection> connect() {
        Single ret = this.rxConnect();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<RedisConnection> rxConnect() {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(), __value -> RedisConnection.newInstance(__value));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public Maybe<Response> send(Request command) {
        Maybe ret = this.rxSend(command);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<Response> rxSend(Request command) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.send(command), __value -> __value);
    }

    public Single<List<Response>> batch(List<Request> commands) {
        Single ret = this.rxBatch(commands);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return AsyncResultSingle.toSingle(() -> this.delegate.batch(commands), __value -> __value);
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

