/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.SocketAddress;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttWill;
import io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubAckReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubCompReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubRecReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubRelReasonCode;
import io.vertx.mqtt.messages.codes.MqttSubAckReasonCode;
import io.vertx.mqtt.messages.codes.MqttUnsubAckReasonCode;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.mqtt.messages.MqttAuthenticationExchangeMessage;
import io.vertx.rxjava3.mqtt.messages.MqttDisconnectMessage;
import io.vertx.rxjava3.mqtt.messages.MqttPubAckMessage;
import io.vertx.rxjava3.mqtt.messages.MqttPubCompMessage;
import io.vertx.rxjava3.mqtt.messages.MqttPubRecMessage;
import io.vertx.rxjava3.mqtt.messages.MqttPubRelMessage;
import io.vertx.rxjava3.mqtt.messages.MqttPublishMessage;
import io.vertx.rxjava3.mqtt.messages.MqttSubscribeMessage;
import io.vertx.rxjava3.mqtt.messages.MqttUnsubscribeMessage;
import java.util.List;

@RxGen(value=io.vertx.mqtt.MqttEndpoint.class)
public class MqttEndpoint
implements RxDelegate {
    public static final TypeArg<MqttEndpoint> __TYPE_ARG = new TypeArg(obj -> new MqttEndpoint((io.vertx.mqtt.MqttEndpoint)obj), MqttEndpoint::getDelegate);
    private final io.vertx.mqtt.MqttEndpoint delegate;
    private SocketAddress cached_0;
    private SocketAddress cached_1;
    private String cached_2;
    private MqttAuth cached_3;
    private MqttWill cached_4;
    private Integer cached_5;
    private String cached_6;
    private Boolean cached_7;
    private Integer cached_8;
    private Integer cached_9;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttEndpoint that = (MqttEndpoint)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MqttEndpoint(io.vertx.mqtt.MqttEndpoint delegate) {
        this.delegate = delegate;
    }

    public MqttEndpoint(Object delegate) {
        this.delegate = (io.vertx.mqtt.MqttEndpoint)delegate;
    }

    public io.vertx.mqtt.MqttEndpoint getDelegate() {
        return this.delegate;
    }

    public void close() {
        this.delegate.close();
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.remoteAddress();
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.localAddress();
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public MultiMap httpHeaders() {
        MultiMap ret = this.delegate.httpHeaders();
        return ret;
    }

    public String httpRequestURI() {
        String ret = this.delegate.httpRequestURI();
        return ret;
    }

    public String clientIdentifier() {
        String ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = this.delegate.clientIdentifier();
        return ret;
    }

    public MqttAuth auth() {
        MqttAuth ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = this.delegate.auth();
        return ret;
    }

    public MqttWill will() {
        MqttWill ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = this.delegate.will();
        return ret;
    }

    public int protocolVersion() {
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        int ret = this.delegate.protocolVersion();
        this.cached_5 = ret;
        return ret;
    }

    public String protocolName() {
        String ret;
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        this.cached_6 = ret = this.delegate.protocolName();
        return ret;
    }

    public boolean isCleanSession() {
        if (this.cached_7 != null) {
            return this.cached_7;
        }
        boolean ret = this.delegate.isCleanSession();
        this.cached_7 = ret;
        return ret;
    }

    public int keepAliveTimeSeconds() {
        if (this.cached_8 != null) {
            return this.cached_8;
        }
        int ret = this.delegate.keepAliveTimeSeconds();
        this.cached_8 = ret;
        return ret;
    }

    public int lastMessageId() {
        if (this.cached_9 != null) {
            return this.cached_9;
        }
        int ret = this.delegate.lastMessageId();
        this.cached_9 = ret;
        return ret;
    }

    public void subscriptionAutoAck(boolean isSubscriptionAutoAck) {
        this.delegate.subscriptionAutoAck(isSubscriptionAutoAck);
    }

    public boolean isSubscriptionAutoAck() {
        boolean ret = this.delegate.isSubscriptionAutoAck();
        return ret;
    }

    public MqttEndpoint publishAutoAck(boolean isPublishAutoAck) {
        this.delegate.publishAutoAck(isPublishAutoAck);
        return this;
    }

    public boolean isPublishAutoAck() {
        boolean ret = this.delegate.isPublishAutoAck();
        return ret;
    }

    public MqttEndpoint autoKeepAlive(boolean isAutoKeepAlive) {
        this.delegate.autoKeepAlive(isAutoKeepAlive);
        return this;
    }

    public boolean isAutoKeepAlive() {
        boolean ret = this.delegate.isAutoKeepAlive();
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public MqttEndpoint setClientIdentifier(String clientIdentifier) {
        this.delegate.setClientIdentifier(clientIdentifier);
        return this;
    }

    public MqttEndpoint disconnectHandler(Handler<Void> handler) {
        this.delegate.disconnectHandler(handler);
        return this;
    }

    public MqttEndpoint disconnectMessageHandler(Handler<MqttDisconnectMessage> handler) {
        this.delegate.disconnectMessageHandler(Helper.convertHandler(handler, event -> MqttDisconnectMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint subscribeHandler(Handler<MqttSubscribeMessage> handler) {
        this.delegate.subscribeHandler(Helper.convertHandler(handler, event -> MqttSubscribeMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint unsubscribeHandler(Handler<MqttUnsubscribeMessage> handler) {
        this.delegate.unsubscribeHandler(Helper.convertHandler(handler, event -> MqttUnsubscribeMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishHandler(Handler<MqttPublishMessage> handler) {
        this.delegate.publishHandler(Helper.convertHandler(handler, event -> MqttPublishMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishAcknowledgeHandler(Handler<Integer> handler) {
        this.delegate.publishAcknowledgeHandler(handler);
        return this;
    }

    public MqttEndpoint publishAcknowledgeMessageHandler(Handler<MqttPubAckMessage> handler) {
        this.delegate.publishAcknowledgeMessageHandler(Helper.convertHandler(handler, event -> MqttPubAckMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishReceivedHandler(Handler<Integer> handler) {
        this.delegate.publishReceivedHandler(handler);
        return this;
    }

    public MqttEndpoint publishReceivedMessageHandler(Handler<MqttPubRecMessage> handler) {
        this.delegate.publishReceivedMessageHandler(Helper.convertHandler(handler, event -> MqttPubRecMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishReleaseHandler(Handler<Integer> handler) {
        this.delegate.publishReleaseHandler(handler);
        return this;
    }

    public MqttEndpoint publishReleaseMessageHandler(Handler<MqttPubRelMessage> handler) {
        this.delegate.publishReleaseMessageHandler(Helper.convertHandler(handler, event -> MqttPubRelMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishCompletionHandler(Handler<Integer> handler) {
        this.delegate.publishCompletionHandler(handler);
        return this;
    }

    public MqttEndpoint publishCompletionMessageHandler(Handler<MqttPubCompMessage> handler) {
        this.delegate.publishCompletionMessageHandler(Helper.convertHandler(handler, event -> MqttPubCompMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint authenticationExchangeHandler(Handler<MqttAuthenticationExchangeMessage> handler) {
        this.delegate.authenticationExchangeHandler(Helper.convertHandler(handler, event -> MqttAuthenticationExchangeMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint pingHandler(Handler<Void> handler) {
        this.delegate.pingHandler(handler);
        return this;
    }

    public MqttEndpoint closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public MqttEndpoint exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttEndpoint accept() {
        this.delegate.accept();
        return this;
    }

    public MqttEndpoint accept(boolean sessionPresent) {
        this.delegate.accept(sessionPresent);
        return this;
    }

    public MqttEndpoint reject(MqttConnectReturnCode returnCode) {
        this.delegate.reject(returnCode);
        return this;
    }

    public MqttEndpoint subscribeAcknowledge(int subscribeMessageId, List<MqttQoS> grantedQoSLevels) {
        this.delegate.subscribeAcknowledge(subscribeMessageId, grantedQoSLevels);
        return this;
    }

    public MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId) {
        this.delegate.unsubscribeAcknowledge(unsubscribeMessageId);
        return this;
    }

    public MqttEndpoint publishAcknowledge(int publishMessageId) {
        this.delegate.publishAcknowledge(publishMessageId);
        return this;
    }

    public MqttEndpoint publishReceived(int publishMessageId) {
        this.delegate.publishReceived(publishMessageId);
        return this;
    }

    public MqttEndpoint publishRelease(int publishMessageId) {
        this.delegate.publishRelease(publishMessageId);
        return this;
    }

    public MqttEndpoint publishComplete(int publishMessageId) {
        this.delegate.publishComplete(publishMessageId);
        return this;
    }

    public Single<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        Single ret = this.rxPublish(topic, payload, qosLevel, isDup, isRetain);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxPublish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return AsyncResultSingle.toSingle(() -> this.delegate.publish(topic, payload, qosLevel, isDup, isRetain), __value -> __value);
    }

    public Single<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) {
        Single ret = this.rxPublish(topic, payload, qosLevel, isDup, isRetain, messageId);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxPublish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) {
        return AsyncResultSingle.toSingle(() -> this.delegate.publish(topic, payload, qosLevel, isDup, isRetain, messageId), __value -> __value);
    }

    public MqttEndpoint authenticationExchange(MqttAuthenticationExchangeMessage message) {
        this.delegate.authenticationExchange(message.getDelegate());
        return this;
    }

    public MqttEndpoint pong() {
        this.delegate.pong();
        return this;
    }

    public MqttProperties connectProperties() {
        MqttProperties ret = this.delegate.connectProperties();
        return ret;
    }

    public MqttEndpoint accept(boolean sessionPresent, MqttProperties properties) {
        this.delegate.accept(sessionPresent, properties);
        return this;
    }

    public MqttEndpoint reject(MqttConnectReturnCode returnCode, MqttProperties properties) {
        this.delegate.reject(returnCode, properties);
        return this;
    }

    public MqttEndpoint subscribeAcknowledge(int subscribeMessageId, List<MqttSubAckReasonCode> reasonCodes, MqttProperties properties) {
        this.delegate.subscribeAcknowledge(subscribeMessageId, reasonCodes, properties);
        return this;
    }

    public MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId, List<MqttUnsubAckReasonCode> reasonCodes, MqttProperties properties) {
        this.delegate.unsubscribeAcknowledge(unsubscribeMessageId, reasonCodes, properties);
        return this;
    }

    public MqttEndpoint publishAcknowledge(int publishMessageId, MqttPubAckReasonCode reasonCode, MqttProperties properties) {
        this.delegate.publishAcknowledge(publishMessageId, reasonCode, properties);
        return this;
    }

    public MqttEndpoint publishReceived(int publishMessageId, MqttPubRecReasonCode reasonCode, MqttProperties properties) {
        this.delegate.publishReceived(publishMessageId, reasonCode, properties);
        return this;
    }

    public MqttEndpoint publishRelease(int publishMessageId, MqttPubRelReasonCode reasonCode, MqttProperties properties) {
        this.delegate.publishRelease(publishMessageId, reasonCode, properties);
        return this;
    }

    public MqttEndpoint publishComplete(int publishMessageId, MqttPubCompReasonCode reasonCode, MqttProperties properties) {
        this.delegate.publishComplete(publishMessageId, reasonCode, properties);
        return this;
    }

    public Single<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, MqttProperties properties) {
        Single ret = this.rxPublish(topic, payload, qosLevel, isDup, isRetain, messageId, properties);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxPublish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, MqttProperties properties) {
        return AsyncResultSingle.toSingle(() -> this.delegate.publish(topic, payload, qosLevel, isDup, isRetain, messageId, properties), __value -> __value);
    }

    public MqttEndpoint disconnect(MqttDisconnectReasonCode code, MqttProperties properties) {
        this.delegate.disconnect(code, properties);
        return this;
    }

    public static MqttEndpoint newInstance(io.vertx.mqtt.MqttEndpoint arg) {
        return arg != null ? new MqttEndpoint(arg) : null;
    }
}

