/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.http.HttpConnection;
import io.vertx.rxjava3.core.http.HttpServerRequest;
import io.vertx.rxjava3.core.http.ServerWebSocket;
import io.vertx.rxjava3.core.http.ServerWebSocketHandshake;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;

@RxGen(value=io.vertx.core.http.HttpServer.class)
public class HttpServer
implements RxDelegate,
Measured {
    public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg(obj -> new HttpServer((io.vertx.core.http.HttpServer)obj), HttpServer::getDelegate);
    private final io.vertx.core.http.HttpServer delegate;
    private static final TypeArg<HttpServer> TYPE_ARG_0 = new TypeArg(o1 -> HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServer> TYPE_ARG_1 = new TypeArg(o1 -> HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServer> TYPE_ARG_2 = new TypeArg(o1 -> HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServer> TYPE_ARG_3 = new TypeArg(o1 -> HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServer that = (HttpServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    public HttpServer(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServer)delegate;
    }

    public io.vertx.core.http.HttpServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler(Helper.convertHandler(handler, event -> HttpServerRequest.newInstance(event)));
        return this;
    }

    public HttpServer invalidRequestHandler(Handler<HttpServerRequest> handler) {
        HttpServer ret = HttpServer.newInstance(this.delegate.invalidRequestHandler(Helper.convertHandler(handler, event -> HttpServerRequest.newInstance(event))));
        return ret;
    }

    public HttpServer connectionHandler(Handler<HttpConnection> handler) {
        this.delegate.connectionHandler(Helper.convertHandler(handler, event -> HttpConnection.newInstance(event)));
        return this;
    }

    public HttpServer webSocketHandshakeHandler(Handler<ServerWebSocketHandshake> handler) {
        this.delegate.webSocketHandshakeHandler(Helper.convertHandler(handler, event -> ServerWebSocketHandshake.newInstance(event)));
        return this;
    }

    public HttpServer exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServer webSocketHandler(Handler<ServerWebSocket> handler) {
        this.delegate.webSocketHandler(Helper.convertHandler(handler, event -> ServerWebSocket.newInstance(event)));
        return this;
    }

    public Single<Boolean> updateSSLOptions(ServerSSLOptions options) {
        Single ret = this.rxUpdateSSLOptions(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ServerSSLOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.updateSSLOptions(options), __value -> __value);
    }

    public Single<Boolean> updateSSLOptions(ServerSSLOptions options, boolean force) {
        Single ret = this.rxUpdateSSLOptions(options, force);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ServerSSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle(() -> this.delegate.updateSSLOptions(options, force), __value -> __value);
    }

    public Single<Boolean> updateTrafficShapingOptions(TrafficShapingOptions options) {
        Single ret = this.rxUpdateTrafficShapingOptions(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateTrafficShapingOptions(TrafficShapingOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.updateTrafficShapingOptions(options), __value -> __value);
    }

    public Single<HttpServer> listen() {
        Single ret = this.rxListen();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServer> rxListen() {
        return AsyncResultSingle.toSingle(() -> this.delegate.listen(), __value -> HttpServer.newInstance(__value));
    }

    public Single<HttpServer> listen(int port, String host) {
        Single ret = this.rxListen(port, host);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServer> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle(() -> this.delegate.listen(port, host), __value -> HttpServer.newInstance(__value));
    }

    public Single<HttpServer> listen(SocketAddress address) {
        Single ret = this.rxListen(address);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServer> rxListen(SocketAddress address) {
        return AsyncResultSingle.toSingle(() -> this.delegate.listen(address), __value -> HttpServer.newInstance(__value));
    }

    public Single<HttpServer> listen(int port) {
        Single ret = this.rxListen(port);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServer> rxListen(int port) {
        return AsyncResultSingle.toSingle(() -> this.delegate.listen(port), __value -> HttpServer.newInstance(__value));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public Completable shutdown() {
        Completable ret = this.rxShutdown();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown());
    }

    public Completable shutdown(long timeout, TimeUnit unit) {
        Completable ret = this.rxShutdown(timeout, unit);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown(timeout, unit));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

