/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.mail;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Vertx;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.mail.MailClient.class)
public class MailClient {
    public static final TypeArg<MailClient> __TYPE_ARG = new TypeArg(obj -> new MailClient((io.vertx.ext.mail.MailClient)obj), MailClient::getDelegate);
    private final io.vertx.ext.mail.MailClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailClient that = (MailClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MailClient(io.vertx.ext.mail.MailClient delegate) {
        this.delegate = delegate;
    }

    public MailClient(Object delegate) {
        this.delegate = (io.vertx.ext.mail.MailClient)delegate;
    }

    public io.vertx.ext.mail.MailClient getDelegate() {
        return this.delegate;
    }

    public static MailClient create(io.vertx.rxjava3.core.Vertx vertx, MailConfig config) {
        MailClient ret = MailClient.newInstance(io.vertx.ext.mail.MailClient.create((Vertx)vertx.getDelegate(), (MailConfig)config));
        return ret;
    }

    public static MailClient createShared(io.vertx.rxjava3.core.Vertx vertx, MailConfig config, String poolName) {
        MailClient ret = MailClient.newInstance(io.vertx.ext.mail.MailClient.createShared((Vertx)vertx.getDelegate(), (MailConfig)config, (String)poolName));
        return ret;
    }

    public static MailClient createShared(io.vertx.rxjava3.core.Vertx vertx, MailConfig config) {
        MailClient ret = MailClient.newInstance(io.vertx.ext.mail.MailClient.createShared((Vertx)vertx.getDelegate(), (MailConfig)config));
        return ret;
    }

    public Single<MailResult> sendMail(MailMessage email) {
        Single ret = this.rxSendMail(email);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<MailResult> rxSendMail(MailMessage email) {
        return AsyncResultSingle.toSingle(() -> this.delegate.sendMail(email), __value -> __value);
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public static MailClient newInstance(io.vertx.ext.mail.MailClient arg) {
        return arg != null ? new MailClient(arg) : null;
    }
}

