/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.auth.webauthn4j;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.ext.auth.webauthn4j.Authenticator;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.ext.auth.webauthn4j.CredentialStorage.class)
public class CredentialStorage {
    public static final TypeArg<CredentialStorage> __TYPE_ARG = new TypeArg(obj -> new CredentialStorage((io.vertx.ext.auth.webauthn4j.CredentialStorage)obj), CredentialStorage::getDelegate);
    private final io.vertx.ext.auth.webauthn4j.CredentialStorage delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialStorage that = (CredentialStorage)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public CredentialStorage(io.vertx.ext.auth.webauthn4j.CredentialStorage delegate) {
        this.delegate = delegate;
    }

    public CredentialStorage(Object delegate) {
        this.delegate = (io.vertx.ext.auth.webauthn4j.CredentialStorage)delegate;
    }

    public io.vertx.ext.auth.webauthn4j.CredentialStorage getDelegate() {
        return this.delegate;
    }

    public Single<List<Authenticator>> find(String userName, String credentialId) {
        Single ret = this.rxFind(userName, credentialId);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<Authenticator>> rxFind(String userName, String credentialId) {
        return AsyncResultSingle.toSingle(() -> this.delegate.find(userName, credentialId), __value -> __value);
    }

    public Completable storeCredential(Authenticator authenticator) {
        Completable ret = this.rxStoreCredential(authenticator);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxStoreCredential(Authenticator authenticator) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.storeCredential(authenticator));
    }

    public Completable updateCounter(Authenticator authenticator) {
        Completable ret = this.rxUpdateCounter(authenticator);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpdateCounter(Authenticator authenticator) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.updateCounter(authenticator));
    }

    public static CredentialStorage newInstance(io.vertx.ext.auth.webauthn4j.CredentialStorage arg) {
        return arg != null ? new CredentialStorage(arg) : null;
    }
}

