/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.http.ClientWebSocket;
import io.vertx.rxjava3.core.http.WebSocket;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;

@RxGen(value=io.vertx.core.http.WebSocketClient.class)
public class WebSocketClient
implements Measured {
    public static final TypeArg<WebSocketClient> __TYPE_ARG = new TypeArg(obj -> new WebSocketClient((io.vertx.core.http.WebSocketClient)obj), WebSocketClient::getDelegate);
    private final io.vertx.core.http.WebSocketClient delegate;
    private static final TypeArg<WebSocket> TYPE_ARG_0 = new TypeArg(o1 -> WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<WebSocket> TYPE_ARG_1 = new TypeArg(o1 -> WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<WebSocket> TYPE_ARG_2 = new TypeArg(o1 -> WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<WebSocket> TYPE_ARG_3 = new TypeArg(o1 -> WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketClient that = (WebSocketClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public WebSocketClient(io.vertx.core.http.WebSocketClient delegate) {
        this.delegate = delegate;
    }

    public WebSocketClient(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocketClient)delegate;
    }

    public io.vertx.core.http.WebSocketClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ClientWebSocket webSocket() {
        ClientWebSocket ret = ClientWebSocket.newInstance(this.delegate.webSocket());
        return ret;
    }

    public Single<WebSocket> connect(int port, String host, String requestURI) {
        Single ret = this.rxConnect(port, host, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxConnect(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(port, host, requestURI), __value -> WebSocket.newInstance(__value));
    }

    public Single<WebSocket> connect(String host, String requestURI) {
        Single ret = this.rxConnect(host, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxConnect(String host, String requestURI) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(host, requestURI), __value -> WebSocket.newInstance(__value));
    }

    public Single<WebSocket> connect(String requestURI) {
        Single ret = this.rxConnect(requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxConnect(String requestURI) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(requestURI), __value -> WebSocket.newInstance(__value));
    }

    public Single<WebSocket> connect(WebSocketConnectOptions options) {
        Single ret = this.rxConnect(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxConnect(WebSocketConnectOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(options), __value -> WebSocket.newInstance(__value));
    }

    public Completable shutdown() {
        Completable ret = this.rxShutdown();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown());
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public Single<Boolean> updateSSLOptions(ClientSSLOptions options) {
        Single ret = this.rxUpdateSSLOptions(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ClientSSLOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.updateSSLOptions(options), __value -> __value);
    }

    public Single<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        Single ret = this.rxUpdateSSLOptions(options, force);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ClientSSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle(() -> this.delegate.updateSSLOptions(options, force), __value -> __value);
    }

    public Completable shutdown(long timeout, TimeUnit unit) {
        Completable ret = this.rxShutdown(timeout, unit);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown(timeout, unit));
    }

    public static WebSocketClient newInstance(io.vertx.core.http.WebSocketClient arg) {
        return arg != null ? new WebSocketClient(arg) : null;
    }
}

