/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.redis.client;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  @Override 
  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.add/">FT.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.add/">FT.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAdd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aggregate/">FT.AGGREGATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAggregate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAggregate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aggregate/">FT.AGGREGATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAggregate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAggregate(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasadd/">FT.ALIASADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasadd/">FT.ALIASADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasdel/">FT.ALIASDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasdel/">FT.ALIASDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasdel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasupdate/">FT.ALIASUPDATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasupdate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasupdate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasupdate/">FT.ALIASUPDATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasupdate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasupdate(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.alter/">FT.ALTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAlter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAlter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.alter/">FT.ALTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAlter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAlter(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.config/">FT.CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftConfig(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtConfig(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.config/">FT.CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftConfig(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.create/">FT.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftCreate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtCreate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.create/">FT.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftCreate(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.cursor/">FT.CURSOR</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftCursor(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtCursor(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.cursor/">FT.CURSOR</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtCursor(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftCursor(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.debug/">FT.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.debug/">FT.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDebug(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.del/">FT.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.del/">FT.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictadd/">FT.DICTADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDictadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDictadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictadd/">FT.DICTADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDictadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDictadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdel/">FT.DICTDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDictdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDictdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdel/">FT.DICTDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDictdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDictdel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdump/">FT.DICTDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDictdump(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDictdump(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdump/">FT.DICTDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDictdump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDictdump(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.drop/">FT.DROP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDrop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDrop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.drop/">FT.DROP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDrop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDrop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dropindex/">FT.DROPINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDropindex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDropindex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dropindex/">FT.DROPINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDropindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDropindex(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explain/">FT.EXPLAIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftExplain(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtExplain(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explain/">FT.EXPLAIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtExplain(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftExplain(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explaincli/">FT.EXPLAINCLI</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftExplaincli(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtExplaincli(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explaincli/">FT.EXPLAINCLI</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtExplaincli(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftExplaincli(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.get/">FT.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftGet(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtGet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.get/">FT.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftGet(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.info/">FT.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.info/">FT.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftInfo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.mget/">FT.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftMget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.mget/">FT.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftMget(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.profile/">FT.PROFILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftProfile(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtProfile(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.profile/">FT.PROFILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtProfile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftProfile(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.safeadd/">FT.SAFEADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSafeadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSafeadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.safeadd/">FT.SAFEADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSafeadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSafeadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.search/">FT.SEARCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSearch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSearch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.search/">FT.SEARCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSearch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSearch(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.spellcheck/">FT.SPELLCHECK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSpellcheck(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSpellcheck(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.spellcheck/">FT.SPELLCHECK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSpellcheck(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSpellcheck(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugadd/">FT.SUGADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSugadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSugadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugadd/">FT.SUGADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSugadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSugadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugdel/">FT.SUGDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSugdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSugdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugdel/">FT.SUGDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSugdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSugdel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugget/">FT.SUGGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSugget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSugget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugget/">FT.SUGGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSugget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSugget(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.suglen/">FT.SUGLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSuglen(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSuglen(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.suglen/">FT.SUGLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSuglen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSuglen(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synadd/">FT.SYNADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSynadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSynadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synadd/">FT.SYNADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSynadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSynadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.syndump/">FT.SYNDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSyndump(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSyndump(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.syndump/">FT.SYNDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSyndump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSyndump(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synupdate/">FT.SYNUPDATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSynupdate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSynupdate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synupdate/">FT.SYNUPDATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSynupdate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSynupdate(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.tagvals/">FT.TAGVALS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftTagvals(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtTagvals(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.tagvals/">FT.TAGVALS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtTagvals(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftTagvals(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasaddifnx/">FT._ALIASADDIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasaddifnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasaddifnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasaddifnx/">FT._ALIASADDIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasaddifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasaddifnx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasdelifx/">FT._ALIASDELIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasdelifx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasdelifx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasdelifx/">FT._ALIASDELIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasdelifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasdelifx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._alterifnx/">FT._ALTERIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAlterifnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAlterifnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._alterifnx/">FT._ALTERIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAlterifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAlterifnx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._createifnx/">FT._CREATEIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftCreateifnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtCreateifnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._createifnx/">FT._CREATEIFNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtCreateifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftCreateifnx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropifx/">FT._DROPIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDropifx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDropifx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropifx/">FT._DROPIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDropifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDropifx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropindexifx/">FT._DROPINDEXIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDropindexifx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDropindexifx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropindexifx/">FT._DROPINDEXIFX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDropindexifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDropindexifx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._list/">FT._LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftList(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtList(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._list/">FT._LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftList(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for Access List Control commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/acl/">ACL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> acl(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAcl(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for Access List Control commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/acl/">ACL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAcl(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.acl(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Append a value to a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/append/">APPEND</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> append(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAppend(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Append a value to a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/append/">APPEND</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAppend(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.append(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Sent by cluster clients after an -ASK redirect.
   * <p>
   * Redis command <a href="https://redis.io/commands/asking/">ASKING</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> asking() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAsking();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Sent by cluster clients after an -ASK redirect.
   * <p>
   * Redis command <a href="https://redis.io/commands/asking/">ASKING</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAsking() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.asking(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Authenticate to the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/auth/">AUTH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> auth(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAuth(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Authenticate to the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/auth/">AUTH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAuth(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.auth(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add/">BF.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add/">BF.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfAdd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.card/">BF.CARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfCard(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfCard(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.card/">BF.CARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfCard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfCard(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug/">BF.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug/">BF.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfDebug(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists/">BF.EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfExists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfExists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists/">BF.EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfExists(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info/">BF.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info/">BF.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfInfo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert/">BF.INSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfInsert(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfInsert(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert/">BF.INSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfInsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfInsert(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk/">BF.LOADCHUNK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfLoadchunk(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfLoadchunk(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk/">BF.LOADCHUNK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfLoadchunk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfLoadchunk(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd/">BF.MADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfMadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfMadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd/">BF.MADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfMadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfMadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists/">BF.MEXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfMexists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfMexists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists/">BF.MEXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfMexists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfMexists(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve/">BF.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfReserve(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfReserve(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve/">BF.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfReserve(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump/">BF.SCANDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfScandump(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfScandump(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump/">BF.SCANDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfScandump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfScandump(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Asynchronously rewrite the append-only file.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgrewriteaof/">BGREWRITEAOF</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bgrewriteaof() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBgrewriteaof();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Asynchronously rewrite the append-only file.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgrewriteaof/">BGREWRITEAOF</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBgrewriteaof() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bgrewriteaof(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Asynchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgsave/">BGSAVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bgsave(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBgsave(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Asynchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgsave/">BGSAVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBgsave(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bgsave(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Count set bits in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitcount/">BITCOUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitcount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitcount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Count set bits in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitcount/">BITCOUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitcount(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield/">BITFIELD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitfield(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitfield(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield/">BITFIELD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitfield(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield_ro/">BITFIELD_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitfieldRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitfieldRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield_ro/">BITFIELD_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitfieldRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitfieldRo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Perform bitwise operations between strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitop/">BITOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Perform bitwise operations between strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitop/">BITOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Find first bit set or clear in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitpos/">BITPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitpos(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitpos(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Find first bit set or clear in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitpos/">BITPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitpos(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmove/">BLMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> blmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBlmove(arg0, arg1, arg2, arg3, arg4);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmove/">BLMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBlmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.blmove(arg0, arg1, arg2, arg3, arg4, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Pop elements from a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmpop/">BLMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> blmpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBlmpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Pop elements from a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmpop/">BLMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBlmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.blmpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and get the first element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blpop/">BLPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> blpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBlpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and get the first element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blpop/">BLPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBlpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.blpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and get the last element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpop/">BRPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> brpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBrpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and get the last element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpop/">BRPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.brpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpoplpush/">BRPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBrpoplpush(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpoplpush/">BRPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBrpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.brpoplpush(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzmpop/">BZMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bzmpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBzmpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzmpop/">BZMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBzmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bzmpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmax/">BZPOPMAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bzpopmax(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBzpopmax(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmax/">BZPOPMAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBzpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bzpopmax(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmin/">BZPOPMIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bzpopmin(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBzpopmin(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmin/">BZPOPMIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBzpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bzpopmin(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add/">CF.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add/">CF.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfAdd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx/">CF.ADDNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfAddnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfAddnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx/">CF.ADDNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfAddnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfAddnx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact/">CF.COMPACT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfCompact(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfCompact(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact/">CF.COMPACT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfCompact(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfCompact(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count/">CF.COUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfCount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfCount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count/">CF.COUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfCount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfCount(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug/">CF.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug/">CF.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfDebug(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del/">CF.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfDel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del/">CF.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfDel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists/">CF.EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfExists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfExists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists/">CF.EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfExists(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info/">CF.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info/">CF.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfInfo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert/">CF.INSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfInsert(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfInsert(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert/">CF.INSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfInsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfInsert(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx/">CF.INSERTNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfInsertnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfInsertnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx/">CF.INSERTNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfInsertnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfInsertnx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk/">CF.LOADCHUNK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfLoadchunk(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfLoadchunk(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk/">CF.LOADCHUNK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfLoadchunk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfLoadchunk(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists/">CF.MEXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfMexists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfMexists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists/">CF.MEXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfMexists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfMexists(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve/">CF.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfReserve(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfReserve(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve/">CF.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfReserve(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump/">CF.SCANDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfScandump(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfScandump(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump/">CF.SCANDUMP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfScandump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfScandump(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for client connection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/client/">CLIENT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> client(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxClient(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for client connection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/client/">CLIENT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxClient(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.client(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for cluster commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/cluster/">CLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cluster(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCluster(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for cluster commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/cluster/">CLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cluster(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby/">CMS.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsIncrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsIncrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby/">CMS.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsIncrby(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info/">CMS.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info/">CMS.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsInfo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim/">CMS.INITBYDIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsInitbydim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsInitbydim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim/">CMS.INITBYDIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsInitbydim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsInitbydim(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob/">CMS.INITBYPROB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsInitbyprob(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsInitbyprob(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob/">CMS.INITBYPROB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsInitbyprob(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsInitbyprob(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge/">CMS.MERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsMerge(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsMerge(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge/">CMS.MERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsMerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsMerge(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query/">CMS.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsQuery(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsQuery(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query/">CMS.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsQuery(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get array of Redis command details.
   * <p>
   * Redis command <a href="https://redis.io/commands/command/">COMMAND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> command(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCommand(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get array of Redis command details.
   * <p>
   * Redis command <a href="https://redis.io/commands/command/">COMMAND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCommand(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.command(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for server configuration commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/config/">CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> config(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxConfig(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for server configuration commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/config/">CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.config(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Copy a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/copy/">COPY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> copy(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCopy(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Copy a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/copy/">COPY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCopy(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.copy(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return the number of keys in the selected database.
   * <p>
   * Redis command <a href="https://redis.io/commands/dbsize/">DBSIZE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> dbsize() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDbsize();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return the number of keys in the selected database.
   * <p>
   * Redis command <a href="https://redis.io/commands/dbsize/">DBSIZE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDbsize() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.dbsize(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for debugging commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/debug/">DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> debug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for debugging commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/debug/">DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.debug(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Decrement the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/decr/">DECR</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> decr(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDecr(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Decrement the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/decr/">DECR</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDecr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.decr(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Decrement the integer value of a key by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/decrby/">DECRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> decrby(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDecrby(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Decrement the integer value of a key by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/decrby/">DECRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDecrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.decrby(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Delete a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/del/">DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> del(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Delete a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/del/">DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.del(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Discard all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/discard/">DISCARD</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> discard() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDiscard();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Discard all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/discard/">DISCARD</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDiscard() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.discard(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * <p>
   * Redis command <a href="https://redis.io/commands/dump/">DUMP</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> dump(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDump(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * <p>
   * Redis command <a href="https://redis.io/commands/dump/">DUMP</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDump(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.dump(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Echo the given string.
   * <p>
   * Redis command <a href="https://redis.io/commands/echo/">ECHO</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> echo(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEcho(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Echo the given string.
   * <p>
   * Redis command <a href="https://redis.io/commands/echo/">ECHO</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEcho(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.echo(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval/">EVAL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> eval(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEval(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval/">EVAL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEval(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.eval(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval_ro/">EVAL_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> evalRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEvalRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval_ro/">EVAL_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEvalRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.evalRo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha/">EVALSHA</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> evalsha(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEvalsha(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha/">EVALSHA</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEvalsha(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.evalsha(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha_ro/">EVALSHA_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> evalshaRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEvalshaRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha_ro/">EVALSHA_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEvalshaRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.evalshaRo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Execute all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/exec/">EXEC</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> exec() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExec();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Execute all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/exec/">EXEC</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExec() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.exec(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Determine if a key exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/exists/">EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> exists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Determine if a key exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/exists/">EXISTS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.exists(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set a key&#x27;s time to live in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/expire/">EXPIRE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> expire(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExpire(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set a key&#x27;s time to live in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/expire/">EXPIRE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExpire(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.expire(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp.
   * <p>
   * Redis command <a href="https://redis.io/commands/expireat/">EXPIREAT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> expireat(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExpireat(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp.
   * <p>
   * Redis command <a href="https://redis.io/commands/expireat/">EXPIREAT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExpireat(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.expireat(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the expiration Unix timestamp for a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/expiretime/">EXPIRETIME</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> expiretime(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExpiretime(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the expiration Unix timestamp for a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/expiretime/">EXPIRETIME</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExpiretime(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.expiretime(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Start a coordinated failover between this server and one of its replicas.
   * <p>
   * Redis command <a href="https://redis.io/commands/failover/">FAILOVER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> failover(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFailover(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Start a coordinated failover between this server and one of its replicas.
   * <p>
   * Redis command <a href="https://redis.io/commands/failover/">FAILOVER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFailover(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.failover(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Invoke a function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall/">FCALL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> fcall(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFcall(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Invoke a function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall/">FCALL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFcall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.fcall(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Invoke a read-only function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall_ro/">FCALL_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> fcallRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFcallRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Invoke a read-only function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall_ro/">FCALL_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFcallRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.fcallRo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove all keys from all databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushall/">FLUSHALL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> flushall(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFlushall(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove all keys from all databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushall/">FLUSHALL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFlushall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.flushall(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove all keys from the current database.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushdb/">FLUSHDB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> flushdb(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFlushdb(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove all keys from the current database.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushdb/">FLUSHDB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFlushdb(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.flushdb(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for function commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/function/">FUNCTION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> function(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFunction(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for function commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/function/">FUNCTION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFunction(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.function(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/geoadd/">GEOADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geoadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/geoadd/">GEOADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geoadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Returns the distance between two members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geodist/">GEODIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geodist(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeodist(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Returns the distance between two members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geodist/">GEODIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeodist(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geodist(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Returns members of a geospatial index as standard geohash strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/geohash/">GEOHASH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geohash(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeohash(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Returns members of a geospatial index as standard geohash strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/geohash/">GEOHASH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeohash(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geohash(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Returns longitude and latitude of members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geopos/">GEOPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geopos(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeopos(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Returns longitude and latitude of members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geopos/">GEOPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeopos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geopos(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius/">GEORADIUS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadius(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradius(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius/">GEORADIUS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradius(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadius(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A read-only variant for GEORADIUS.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius_ro/">GEORADIUS_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A read-only variant for GEORADIUS.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius_ro/">GEORADIUS_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusRo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember/">GEORADIUSBYMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusbymember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusbymember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember/">GEORADIUSBYMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusbymember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusbymember(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro/">GEORADIUSBYMEMBER_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusbymemberRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusbymemberRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro/">GEORADIUSBYMEMBER_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusbymemberRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusbymemberRo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearch/">GEOSEARCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geosearch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeosearch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearch/">GEOSEARCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeosearch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geosearch(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearchstore/">GEOSEARCHSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geosearchstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeosearchstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearchstore/">GEOSEARCHSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeosearchstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geosearchstore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/get/">GET</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> get(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGet(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/get/">GET</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGet(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.get(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Returns the bit value at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getbit/">GETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getbit(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetbit(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Returns the bit value at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getbit/">GETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetbit(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getbit(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the value of a key and delete the key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getdel/">GETDEL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getdel(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetdel(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the value of a key and delete the key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getdel/">GETDEL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetdel(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getdel(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the value of a key and optionally set its expiration.
   * <p>
   * Redis command <a href="https://redis.io/commands/getex/">GETEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the value of a key and optionally set its expiration.
   * <p>
   * Redis command <a href="https://redis.io/commands/getex/">GETEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getex(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getrange/">GETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getrange/">GETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getrange(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the string value of a key and return its old value.
   * <p>
   * Redis command <a href="https://redis.io/commands/getset/">GETSET</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getset(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetset(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the string value of a key and return its old value.
   * <p>
   * Redis command <a href="https://redis.io/commands/getset/">GETSET</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetset(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getset(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.bulk/">GRAPH.BULK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphBulk(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphBulk(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.bulk/">GRAPH.BULK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphBulk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphBulk(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.config/">GRAPH.CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphConfig(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphConfig(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.config/">GRAPH.CONFIG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphConfig(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.debug/">GRAPH.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.debug/">GRAPH.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphDebug(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.delete/">GRAPH.DELETE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphDelete(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphDelete(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.delete/">GRAPH.DELETE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphDelete(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphDelete(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.explain/">GRAPH.EXPLAIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphExplain(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphExplain(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.explain/">GRAPH.EXPLAIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphExplain(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphExplain(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.list/">GRAPH.LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphList(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphList(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.list/">GRAPH.LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphList(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.profile/">GRAPH.PROFILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphProfile(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphProfile(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.profile/">GRAPH.PROFILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphProfile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphProfile(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.query/">GRAPH.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphQuery(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphQuery(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.query/">GRAPH.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphQuery(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.ro_query/">GRAPH.RO_QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphRoQuery(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphRoQuery(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.ro_query/">GRAPH.RO_QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphRoQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphRoQuery(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.slowlog/">GRAPH.SLOWLOG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphSlowlog(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphSlowlog(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.slowlog/">GRAPH.SLOWLOG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphSlowlog(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Delete one or more hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hdel/">HDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Delete one or more hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hdel/">HDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hdel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Handshake with Redis.
   * <p>
   * Redis command <a href="https://redis.io/commands/hello/">HELLO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hello(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHello(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Handshake with Redis.
   * <p>
   * Redis command <a href="https://redis.io/commands/hello/">HELLO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hello(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Determine if a hash field exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/hexists/">HEXISTS</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hexists(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHexists(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Determine if a hash field exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/hexists/">HEXISTS</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHexists(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hexists(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hget/">HGET</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hget(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHget(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hget/">HGET</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHget(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hget(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get all the fields and values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hgetall/">HGETALL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hgetall(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHgetall(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get all the fields and values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hgetall/">HGETALL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHgetall(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hgetall(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Increment the integer value of a hash field by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrby/">HINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHincrby(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Increment the integer value of a hash field by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrby/">HINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hincrby(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Increment the float value of a hash field by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrbyfloat/">HINCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHincrbyfloat(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Increment the float value of a hash field by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrbyfloat/">HINCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hincrbyfloat(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get all the fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hkeys/">HKEYS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hkeys(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHkeys(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get all the fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hkeys/">HKEYS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHkeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hkeys(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the number of fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hlen/">HLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the number of fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hlen/">HLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hlen(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the values of all the given hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmget/">HMGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hmget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHmget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the values of all the given hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmget/">HMGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHmget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hmget(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set multiple hash fields to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmset/">HMSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hmset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHmset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set multiple hash fields to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmset/">HMSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHmset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hmset(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get one or multiple random fields from a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hrandfield/">HRANDFIELD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hrandfield(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHrandfield(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get one or multiple random fields from a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hrandfield/">HRANDFIELD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHrandfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hrandfield(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Incrementally iterate hash fields and associated values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hscan/">HSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Incrementally iterate hash fields and associated values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hscan/">HSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hscan(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the string value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hset/">HSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the string value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hset/">HSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hset(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the value of a hash field, only if the field does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/hsetnx/">HSETNX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHsetnx(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the value of a hash field, only if the field does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/hsetnx/">HSETNX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hsetnx(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the length of the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hstrlen/">HSTRLEN</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hstrlen(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHstrlen(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the length of the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hstrlen/">HSTRLEN</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHstrlen(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hstrlen(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get all the values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hvals/">HVALS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hvals(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHvals(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get all the values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hvals/">HVALS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHvals(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hvals(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Increment the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/incr/">INCR</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incr(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncr(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Increment the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/incr/">INCR</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incr(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Increment the integer value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrby/">INCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incrby(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncrby(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Increment the integer value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrby/">INCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incrby(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Increment the float value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrbyfloat/">INCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncrbyfloat(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Increment the float value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrbyfloat/">INCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incrbyfloat(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get information and statistics about the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/info/">INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> info(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get information and statistics about the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/info/">INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.info(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend/">JSON.ARRAPPEND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrappend(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrappend(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend/">JSON.ARRAPPEND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrappend(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrappend(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex/">JSON.ARRINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrindex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrindex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex/">JSON.ARRINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrindex(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert/">JSON.ARRINSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrinsert(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrinsert(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert/">JSON.ARRINSERT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrinsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrinsert(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen/">JSON.ARRLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrlen(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrlen(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen/">JSON.ARRLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrlen(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop/">JSON.ARRPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop/">JSON.ARRPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim/">JSON.ARRTRIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrtrim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrtrim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim/">JSON.ARRTRIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrtrim(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear/">JSON.CLEAR</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonClear(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonClear(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear/">JSON.CLEAR</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonClear(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonClear(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug/">JSON.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug/">JSON.DEBUG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonDebug(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del/">JSON.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonDel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del/">JSON.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonDel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget/">JSON.FORGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonForget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonForget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget/">JSON.FORGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonForget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonForget(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get/">JSON.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonGet(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonGet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get/">JSON.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonGet(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget/">JSON.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonMget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget/">JSON.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonMget(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby/">JSON.NUMINCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonNumincrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonNumincrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby/">JSON.NUMINCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonNumincrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonNumincrby(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby/">JSON.NUMMULTBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonNummultby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonNummultby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby/">JSON.NUMMULTBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonNummultby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonNummultby(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby/">JSON.NUMPOWBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonNumpowby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonNumpowby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby/">JSON.NUMPOWBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonNumpowby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonNumpowby(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys/">JSON.OBJKEYS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonObjkeys(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonObjkeys(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys/">JSON.OBJKEYS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonObjkeys(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonObjkeys(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen/">JSON.OBJLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonObjlen(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonObjlen(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen/">JSON.OBJLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonObjlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonObjlen(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp/">JSON.RESP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonResp(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonResp(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp/">JSON.RESP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonResp(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonResp(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set/">JSON.SET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonSet(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonSet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set/">JSON.SET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonSet(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend/">JSON.STRAPPEND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonStrappend(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonStrappend(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend/">JSON.STRAPPEND</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonStrappend(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonStrappend(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen/">JSON.STRLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonStrlen(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonStrlen(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen/">JSON.STRLEN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonStrlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonStrlen(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle/">JSON.TOGGLE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonToggle(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonToggle(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle/">JSON.TOGGLE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonToggle(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonToggle(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type/">JSON.TYPE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonType(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonType(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type/">JSON.TYPE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonType(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonType(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Find all keys matching the given pattern.
   * <p>
   * Redis command <a href="https://redis.io/commands/keys/">KEYS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> keys(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxKeys(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Find all keys matching the given pattern.
   * <p>
   * Redis command <a href="https://redis.io/commands/keys/">KEYS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxKeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.keys(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/lastsave/">LASTSAVE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lastsave() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLastsave();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/lastsave/">LASTSAVE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLastsave() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lastsave(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for latency diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/latency/">LATENCY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> latency(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLatency(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for latency diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/latency/">LATENCY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLatency(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.latency(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Find longest common substring.
   * <p>
   * Redis command <a href="https://redis.io/commands/lcs/">LCS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lcs(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLcs(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Find longest common substring.
   * <p>
   * Redis command <a href="https://redis.io/commands/lcs/">LCS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLcs(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lcs(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get an element from a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lindex/">LINDEX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lindex(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLindex(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get an element from a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lindex/">LINDEX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLindex(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lindex(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Insert an element before or after another element in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/linsert/">LINSERT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLinsert(arg0, arg1, arg2, arg3);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Insert an element before or after another element in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/linsert/">LINSERT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLinsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.linsert(arg0, arg1, arg2, arg3, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the length of a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/llen/">LLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> llen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the length of a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/llen/">LLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.llen(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmove/">LMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLmove(arg0, arg1, arg2, arg3);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Pop an element from a list, push it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmove/">LMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lmove(arg0, arg1, arg2, arg3, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Pop elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmpop/">LMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lmpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLmpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Pop elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmpop/">LMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lmpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Display some computer art and the Redis version.
   * <p>
   * Redis command <a href="https://redis.io/commands/lolwut/">LOLWUT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lolwut(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLolwut(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Display some computer art and the Redis version.
   * <p>
   * Redis command <a href="https://redis.io/commands/lolwut/">LOLWUT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLolwut(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lolwut(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and get the first elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpop/">LPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and get the first elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpop/">LPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return the index of matching elements on a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpos/">LPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpos(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpos(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return the index of matching elements on a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpos/">LPOS</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpos(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Prepend one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpush/">LPUSH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpush(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpush(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Prepend one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpush/">LPUSH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpush(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Prepend an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpushx/">LPUSHX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpushx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpushx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Prepend an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpushx/">LPUSHX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpushx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get a range of elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrange/">LRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get a range of elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrange/">LRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lrange(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrem/">LREM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLrem(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrem/">LREM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lrem(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the value of an element in a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lset/">LSET</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLset(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the value of an element in a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lset/">LSET</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lset(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Trim a list to the specified range.
   * <p>
   * Redis command <a href="https://redis.io/commands/ltrim/">LTRIM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLtrim(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Trim a list to the specified range.
   * <p>
   * Redis command <a href="https://redis.io/commands/ltrim/">LTRIM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLtrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ltrim(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for memory diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/memory/">MEMORY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> memory(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMemory(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for memory diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/memory/">MEMORY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMemory(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.memory(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the values of all the given keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/mget/">MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> mget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the values of all the given keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/mget/">MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.mget(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * <p>
   * Redis command <a href="https://redis.io/commands/migrate/">MIGRATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> migrate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMigrate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * <p>
   * Redis command <a href="https://redis.io/commands/migrate/">MIGRATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMigrate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.migrate(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for module commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/module/">MODULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> module(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxModule(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for module commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/module/">MODULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxModule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.module(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Listen for all requests received by the server in real time.
   * <p>
   * Redis command <a href="https://redis.io/commands/monitor/">MONITOR</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> monitor() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMonitor();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Listen for all requests received by the server in real time.
   * <p>
   * Redis command <a href="https://redis.io/commands/monitor/">MONITOR</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMonitor() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.monitor(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Move a key to another database.
   * <p>
   * Redis command <a href="https://redis.io/commands/move/">MOVE</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> move(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMove(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Move a key to another database.
   * <p>
   * Redis command <a href="https://redis.io/commands/move/">MOVE</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMove(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.move(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set multiple keys to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/mset/">MSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> mset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set multiple keys to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/mset/">MSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.mset(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/msetnx/">MSETNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> msetnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMsetnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/msetnx/">MSETNX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMsetnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.msetnx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Mark the start of a transaction block.
   * <p>
   * Redis command <a href="https://redis.io/commands/multi/">MULTI</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> multi() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMulti();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Mark the start of a transaction block.
   * <p>
   * Redis command <a href="https://redis.io/commands/multi/">MULTI</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMulti() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.multi(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for object introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/object/">OBJECT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> object(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxObject(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for object introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/object/">OBJECT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxObject(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.object(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove the expiration from a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/persist/">PERSIST</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> persist(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPersist(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove the expiration from a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/persist/">PERSIST</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPersist(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.persist(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set a key&#x27;s time to live in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpire/">PEXPIRE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pexpire(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPexpire(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set a key&#x27;s time to live in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpire/">PEXPIRE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPexpire(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pexpire(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpireat/">PEXPIREAT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pexpireat(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPexpireat(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpireat/">PEXPIREAT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPexpireat(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pexpireat(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpiretime/">PEXPIRETIME</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pexpiretime(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPexpiretime(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpiretime/">PEXPIRETIME</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPexpiretime(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pexpiretime(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfadd/">PFADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfadd/">PFADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * <p>
   * Redis command <a href="https://redis.io/commands/pfcount/">PFCOUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfcount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfcount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * <p>
   * Redis command <a href="https://redis.io/commands/pfcount/">PFCOUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfcount(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Internal commands for debugging HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfdebug/">PFDEBUG</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfdebug(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfdebug(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Internal commands for debugging HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfdebug/">PFDEBUG</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfdebug(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfdebug(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfmerge/">PFMERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfmerge(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfmerge(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfmerge/">PFMERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfmerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfmerge(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * An internal command for testing HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfselftest/">PFSELFTEST</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfselftest() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfselftest();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * An internal command for testing HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfselftest/">PFSELFTEST</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfselftest() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfselftest(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Ping the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/ping/">PING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ping(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPing(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Ping the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/ping/">PING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPing(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ping(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the value and expiration in milliseconds of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/psetex/">PSETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsetex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the value and expiration in milliseconds of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/psetex/">PSETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psetex(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Listen for messages published to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/psubscribe/">PSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Listen for messages published to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/psubscribe/">PSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psubscribe(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/psync/">PSYNC</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psync(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsync(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/psync/">PSYNC</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsync(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psync(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the time to live for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pttl/">PTTL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pttl(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPttl(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the time to live for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pttl/">PTTL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPttl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pttl(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Post a message to a channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/publish/">PUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> publish(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPublish(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Post a message to a channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/publish/">PUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.publish(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for Pub/Sub commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/pubsub/">PUBSUB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pubsub(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPubsub(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for Pub/Sub commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/pubsub/">PUBSUB</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPubsub(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pubsub(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/punsubscribe/">PUNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> punsubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPunsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/punsubscribe/">PUNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.punsubscribe(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Close the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/quit/">QUIT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> quit(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxQuit(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Close the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/quit/">QUIT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxQuit(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.quit(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a random key from the keyspace.
   * <p>
   * Redis command <a href="https://redis.io/commands/randomkey/">RANDOMKEY</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> randomkey() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRandomkey();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a random key from the keyspace.
   * <p>
   * Redis command <a href="https://redis.io/commands/randomkey/">RANDOMKEY</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRandomkey() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.randomkey(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Enables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readonly/">READONLY</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> readonly() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReadonly();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Enables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readonly/">READONLY</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReadonly() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.readonly(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Disables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readwrite/">READWRITE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> readwrite() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReadwrite();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Disables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readwrite/">READWRITE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReadwrite() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.readwrite(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Rename a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/rename/">RENAME</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rename(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRename(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Rename a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/rename/">RENAME</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRename(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rename(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Rename a key, only if the new key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/renamenx/">RENAMENX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> renamenx(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRenamenx(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Rename a key, only if the new key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/renamenx/">RENAMENX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRenamenx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.renamenx(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * An internal command for configuring the replication stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/replconf/">REPLCONF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> replconf(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReplconf(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * An internal command for configuring the replication stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/replconf/">REPLCONF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReplconf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.replconf(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/replicaof/">REPLICAOF</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> replicaof(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReplicaof(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/replicaof/">REPLICAOF</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReplicaof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.replicaof(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Reset the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/reset/">RESET</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> reset() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReset();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Reset the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/reset/">RESET</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReset() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.reset(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore/">RESTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> restore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRestore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore/">RESTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.restore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * An internal command for migrating keys in a cluster.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore asking/">RESTORE-ASKING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> restoreAsking(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRestoreAsking(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * An internal command for migrating keys in a cluster.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore asking/">RESTORE-ASKING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRestoreAsking(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.restoreAsking(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return the role of the instance in the context of replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/role/">ROLE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> role() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRole();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return the role of the instance in the context of replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/role/">ROLE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRole() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.role(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and get the last elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpop/">RPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and get the last elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpop/">RPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove the last element in a list, prepend it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpoplpush/">RPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpoplpush(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove the last element in a list, prepend it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpoplpush/">RPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpoplpush(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Append one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpush/">RPUSH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpush(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpush(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Append one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpush/">RPUSH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpush(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Append an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpushx/">RPUSHX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpushx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpushx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Append an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpushx/">RPUSHX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpushx(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Add one or more members to a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sadd/">SADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Add one or more members to a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sadd/">SADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Synchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/save/">SAVE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> save() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSave();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Synchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/save/">SAVE</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSave() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.save(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Incrementally iterate the keys space.
   * <p>
   * Redis command <a href="https://redis.io/commands/scan/">SCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> scan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Incrementally iterate the keys space.
   * <p>
   * Redis command <a href="https://redis.io/commands/scan/">SCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.scan(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the number of members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/scard/">SCARD</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> scard(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScard(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the number of members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/scard/">SCARD</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.scard(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for Lua scripts management commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/script/">SCRIPT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> script(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScript(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for Lua scripts management commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/script/">SCRIPT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScript(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.script(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Subtract multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiff/">SDIFF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sdiff(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSdiff(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Subtract multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiff/">SDIFF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sdiff(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Subtract multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiffstore/">SDIFFSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sdiffstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSdiffstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Subtract multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiffstore/">SDIFFSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sdiffstore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Change the selected database for the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/select/">SELECT</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> select(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSelect(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Change the selected database for the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/select/">SELECT</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSelect(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.select(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the string value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/set/">SET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> set(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the string value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/set/">SET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.set(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setbit/">SETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetbit(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setbit/">SETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setbit(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the value and expiration of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setex/">SETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the value and expiration of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setex/">SETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setex(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Set the value of a key, only if the key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/setnx/">SETNX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setnx(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetnx(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Set the value of a key, only if the key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/setnx/">SETNX</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetnx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setnx(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Overwrite part of a string at key starting at the specified offset.
   * <p>
   * Redis command <a href="https://redis.io/commands/setrange/">SETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Overwrite part of a string at key starting at the specified offset.
   * <p>
   * Redis command <a href="https://redis.io/commands/setrange/">SETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setrange(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Synchronously save the dataset to disk and then shut down the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/shutdown/">SHUTDOWN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> shutdown(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxShutdown(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Synchronously save the dataset to disk and then shut down the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/shutdown/">SHUTDOWN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxShutdown(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.shutdown(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Intersect multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinter/">SINTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sinter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSinter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Intersect multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinter/">SINTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sinter(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Intersect multiple sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/sintercard/">SINTERCARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sintercard(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSintercard(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Intersect multiple sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/sintercard/">SINTERCARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSintercard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sintercard(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Intersect multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinterstore/">SINTERSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sinterstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSinterstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Intersect multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinterstore/">SINTERSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sinterstore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Determine if a given value is a member of a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sismember/">SISMEMBER</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sismember(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSismember(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Determine if a given value is a member of a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sismember/">SISMEMBER</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSismember(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sismember(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/slaveof/">SLAVEOF</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> slaveof(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSlaveof(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/slaveof/">SLAVEOF</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSlaveof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.slaveof(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for slow log commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/slowlog/">SLOWLOG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> slowlog(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSlowlog(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for slow log commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/slowlog/">SLOWLOG</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.slowlog(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get all the members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smembers/">SMEMBERS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> smembers(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSmembers(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get all the members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smembers/">SMEMBERS</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSmembers(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.smembers(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Returns the membership associated with the given elements for a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smismember/">SMISMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> smismember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSmismember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Returns the membership associated with the given elements for a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smismember/">SMISMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSmismember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.smismember(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Move a member from one set to another.
   * <p>
   * Redis command <a href="https://redis.io/commands/smove/">SMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSmove(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Move a member from one set to another.
   * <p>
   * Redis command <a href="https://redis.io/commands/smove/">SMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.smove(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Sort the elements in a list, set or sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort/">SORT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sort(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSort(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Sort the elements in a list, set or sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort/">SORT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSort(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sort(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort_ro/">SORT_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sortRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSortRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort_ro/">SORT_RO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSortRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sortRo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and return one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/spop/">SPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> spop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and return one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/spop/">SPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.spop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Post a message to a shard channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/spublish/">SPUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> spublish(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSpublish(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Post a message to a shard channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/spublish/">SPUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSpublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.spublish(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srandmember/">SRANDMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> srandmember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSrandmember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srandmember/">SRANDMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.srandmember(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove one or more members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srem/">SREM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> srem(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSrem(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove one or more members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srem/">SREM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.srem(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Incrementally iterate Set elements.
   * <p>
   * Redis command <a href="https://redis.io/commands/sscan/">SSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Incrementally iterate Set elements.
   * <p>
   * Redis command <a href="https://redis.io/commands/sscan/">SSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sscan(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Listen for messages published to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/ssubscribe/">SSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ssubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Listen for messages published to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/ssubscribe/">SSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ssubscribe(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the length of the value stored in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/strlen/">STRLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> strlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxStrlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the length of the value stored in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/strlen/">STRLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxStrlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.strlen(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Listen for messages published to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/subscribe/">SUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> subscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Listen for messages published to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/subscribe/">SUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.subscribe(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/substr/">SUBSTR</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSubstr(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/substr/">SUBSTR</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSubstr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.substr(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Add multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunion/">SUNION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sunion(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSunion(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Add multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunion/">SUNION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sunion(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Add multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunionstore/">SUNIONSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sunionstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSunionstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Add multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunionstore/">SUNIONSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sunionstore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Stop listening for messages posted to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunsubscribe/">SUNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sunsubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSunsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Stop listening for messages posted to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunsubscribe/">SUNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sunsubscribe(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Swaps two Redis databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/swapdb/">SWAPDB</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> swapdb(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSwapdb(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Swaps two Redis databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/swapdb/">SWAPDB</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSwapdb(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.swapdb(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/sync/">SYNC</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sync() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSync();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/sync/">SYNC</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSync() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sync(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.add/">TDIGEST.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.add/">TDIGEST.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestAdd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrank/">TDIGEST.BYRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestByrank(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestByrank(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrank/">TDIGEST.BYRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestByrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestByrank(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrevrank/">TDIGEST.BYREVRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestByrevrank(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestByrevrank(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrevrank/">TDIGEST.BYREVRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestByrevrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestByrevrank(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.cdf/">TDIGEST.CDF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestCdf(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestCdf(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.cdf/">TDIGEST.CDF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestCdf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestCdf(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.create/">TDIGEST.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestCreate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestCreate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.create/">TDIGEST.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestCreate(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.info/">TDIGEST.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.info/">TDIGEST.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestInfo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.max/">TDIGEST.MAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestMax(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestMax(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.max/">TDIGEST.MAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestMax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestMax(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.merge/">TDIGEST.MERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestMerge(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestMerge(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.merge/">TDIGEST.MERGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestMerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestMerge(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.min/">TDIGEST.MIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestMin(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestMin(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.min/">TDIGEST.MIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestMin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestMin(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.quantile/">TDIGEST.QUANTILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestQuantile(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestQuantile(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.quantile/">TDIGEST.QUANTILE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestQuantile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestQuantile(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.rank/">TDIGEST.RANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestRank(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestRank(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.rank/">TDIGEST.RANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestRank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestRank(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.reset/">TDIGEST.RESET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestReset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestReset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.reset/">TDIGEST.RESET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestReset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestReset(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.revrank/">TDIGEST.REVRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestRevrank(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestRevrank(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.revrank/">TDIGEST.REVRANK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestRevrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestRevrank(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.trimmed_mean/">TDIGEST.TRIMMED_MEAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tdigestTrimmedMean(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTdigestTrimmedMean(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.trimmed_mean/">TDIGEST.TRIMMED_MEAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTdigestTrimmedMean(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tdigestTrimmedMean(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return the current server time.
   * <p>
   * Redis command <a href="https://redis.io/commands/time/">TIME</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> time() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTime();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return the current server time.
   * <p>
   * Redis command <a href="https://redis.io/commands/time/">TIME</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTime() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.time(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clusterset/">TIMESERIES.CLUSTERSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesClusterset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesClusterset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clusterset/">TIMESERIES.CLUSTERSET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesClusterset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesClusterset(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clustersetfromshard/">TIMESERIES.CLUSTERSETFROMSHARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesClustersetfromshard(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesClustersetfromshard(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clustersetfromshard/">TIMESERIES.CLUSTERSETFROMSHARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesClustersetfromshard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesClustersetfromshard(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.hello/">TIMESERIES.HELLO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesHello(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesHello(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.hello/">TIMESERIES.HELLO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesHello(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.infocluster/">TIMESERIES.INFOCLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesInfocluster(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesInfocluster(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.infocluster/">TIMESERIES.INFOCLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesInfocluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesInfocluster(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.innercommunication/">TIMESERIES.INNERCOMMUNICATION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesInnercommunication(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesInnercommunication(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.innercommunication/">TIMESERIES.INNERCOMMUNICATION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesInnercommunication(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesInnercommunication(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.networktest/">TIMESERIES.NETWORKTEST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesNetworktest(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesNetworktest(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.networktest/">TIMESERIES.NETWORKTEST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesNetworktest(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesNetworktest(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.refreshcluster/">TIMESERIES.REFRESHCLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesRefreshcluster(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesRefreshcluster(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.refreshcluster/">TIMESERIES.REFRESHCLUSTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesRefreshcluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesRefreshcluster(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add/">TOPK.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add/">TOPK.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkAdd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count/">TOPK.COUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkCount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkCount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count/">TOPK.COUNT</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkCount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkCount(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby/">TOPK.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkIncrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkIncrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby/">TOPK.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkIncrby(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info/">TOPK.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info/">TOPK.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkInfo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list/">TOPK.LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkList(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkList(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list/">TOPK.LIST</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkList(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query/">TOPK.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkQuery(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkQuery(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query/">TOPK.QUERY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkQuery(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve/">TOPK.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkReserve(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkReserve(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve/">TOPK.RESERVE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkReserve(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * <p>
   * Redis command <a href="https://redis.io/commands/touch/">TOUCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> touch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTouch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * <p>
   * Redis command <a href="https://redis.io/commands/touch/">TOUCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTouch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.touch(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add/">TS.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add/">TS.ADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsAdd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter/">TS.ALTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsAlter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsAlter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter/">TS.ALTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsAlter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsAlter(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create/">TS.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsCreate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsCreate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create/">TS.CREATE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsCreate(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule/">TS.CREATERULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsCreaterule(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsCreaterule(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule/">TS.CREATERULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsCreaterule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsCreaterule(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby/">TS.DECRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsDecrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsDecrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby/">TS.DECRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsDecrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsDecrby(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del/">TS.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsDel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del/">TS.DEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsDel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule/">TS.DELETERULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsDeleterule(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsDeleterule(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule/">TS.DELETERULE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsDeleterule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsDeleterule(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get/">TS.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsGet(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsGet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get/">TS.GET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsGet(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby/">TS.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsIncrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsIncrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby/">TS.INCRBY</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsIncrby(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info/">TS.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info/">TS.INFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsInfo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd/">TS.MADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsMadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsMadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd/">TS.MADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsMadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsMadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget/">TS.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsMget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget/">TS.MGET</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsMget(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange/">TS.MRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsMrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsMrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange/">TS.MRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsMrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsMrange(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange/">TS.MREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsMrevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsMrevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange/">TS.MREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsMrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsMrevrange(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex/">TS.QUERYINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsQueryindex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsQueryindex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex/">TS.QUERYINDEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsQueryindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsQueryindex(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range/">TS.RANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsRange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsRange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range/">TS.RANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsRange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsRange(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange/">TS.REVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsRevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsRevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange/">TS.REVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsRevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsRevrange(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the time to live for a key in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/ttl/">TTL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ttl(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTtl(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the time to live for a key in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/ttl/">TTL</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTtl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ttl(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Determine the type stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/type/">TYPE</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> type(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxType(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Determine the type stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/type/">TYPE</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxType(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.type(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * <p>
   * Redis command <a href="https://redis.io/commands/unlink/">UNLINK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unlink(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnlink(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * <p>
   * Redis command <a href="https://redis.io/commands/unlink/">UNLINK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnlink(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unlink(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Stop listening for messages posted to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/unsubscribe/">UNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unsubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Stop listening for messages posted to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/unsubscribe/">UNSUBSCRIBE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unsubscribe(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Forget about all watched keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/unwatch/">UNWATCH</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unwatch() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnwatch();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Forget about all watched keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/unwatch/">UNWATCH</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnwatch() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unwatch(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/wait/">WAIT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> wait(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxWait(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/wait/">WAIT</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxWait(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.wait(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   * <p>
   * Redis command <a href="https://redis.io/commands/watch/">WATCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> watch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxWatch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   * <p>
   * Redis command <a href="https://redis.io/commands/watch/">WATCH</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxWatch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.watch(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   * <p>
   * Redis command <a href="https://redis.io/commands/xack/">XACK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xack(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXack(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   * <p>
   * Redis command <a href="https://redis.io/commands/xack/">XACK</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXack(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xack(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Appends a new entry to a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xadd/">XADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Appends a new entry to a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xadd/">XADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xautoclaim/">XAUTOCLAIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xautoclaim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXautoclaim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xautoclaim/">XAUTOCLAIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXautoclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xautoclaim(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xclaim/">XCLAIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xclaim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXclaim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xclaim/">XCLAIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xclaim(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/xdel/">XDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/xdel/">XDEL</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xdel(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for consumer groups commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xgroup/">XGROUP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xgroup(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXgroup(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for consumer groups commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xgroup/">XGROUP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xgroup(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * A container for stream introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xinfo/">XINFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xinfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXinfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * A container for stream introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xinfo/">XINFO</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXinfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xinfo(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return the number of entries in a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xlen/">XLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return the number of entries in a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xlen/">XLEN</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xlen(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   * <p>
   * Redis command <a href="https://redis.io/commands/xpending/">XPENDING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xpending(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXpending(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   * <p>
   * Redis command <a href="https://redis.io/commands/xpending/">XPENDING</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXpending(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xpending(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrange/">XRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrange/">XRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xrange(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xread/">XREAD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xread(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXread(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xread/">XREAD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXread(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xread(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xreadgroup/">XREADGROUP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xreadgroup(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXreadgroup(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xreadgroup/">XREADGROUP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXreadgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xreadgroup(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrevrange/">XREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xrevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXrevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrevrange/">XREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xrevrange(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * An internal command for replicating stream values.
   * <p>
   * Redis command <a href="https://redis.io/commands/xsetid/">XSETID</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xsetid(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXsetid(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * An internal command for replicating stream values.
   * <p>
   * Redis command <a href="https://redis.io/commands/xsetid/">XSETID</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXsetid(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xsetid(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Trims the stream to (approximately if &#x27;~&#x27; is passed) a certain size.
   * <p>
   * Redis command <a href="https://redis.io/commands/xtrim/">XTRIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xtrim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXtrim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Trims the stream to (approximately if &#x27;~&#x27; is passed) a certain size.
   * <p>
   * Redis command <a href="https://redis.io/commands/xtrim/">XTRIM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xtrim(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/zadd/">ZADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/zadd/">ZADD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zadd(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the number of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcard/">ZCARD</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zcard(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZcard(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the number of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcard/">ZCARD</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZcard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zcard(arg0, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Count the members in a sorted set with scores within the given values.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcount/">ZCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZcount(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Count the members in a sorted set with scores within the given values.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcount/">ZCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zcount(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Subtract multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiff/">ZDIFF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zdiff(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZdiff(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Subtract multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiff/">ZDIFF</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zdiff(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiffstore/">ZDIFFSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zdiffstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZdiffstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiffstore/">ZDIFFSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zdiffstore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Increment the score of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zincrby/">ZINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZincrby(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Increment the score of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zincrby/">ZINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zincrby(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Intersect multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinter/">ZINTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zinter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZinter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Intersect multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinter/">ZINTER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zinter(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/zintercard/">ZINTERCARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zintercard(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZintercard(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/zintercard/">ZINTERCARD</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZintercard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zintercard(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinterstore/">ZINTERSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zinterstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZinterstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinterstore/">ZINTERSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zinterstore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zlexcount/">ZLEXCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZlexcount(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zlexcount/">ZLEXCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zlexcount(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and return members with scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmpop/">ZMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zmpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZmpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and return members with scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmpop/">ZMPOP</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zmpop(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the score associated with the given members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmscore/">ZMSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zmscore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZmscore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the score associated with the given members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmscore/">ZMSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZmscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zmscore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and return members with the highest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmax/">ZPOPMAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zpopmax(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZpopmax(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and return members with the highest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmax/">ZPOPMAX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zpopmax(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove and return members with the lowest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmin/">ZPOPMIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zpopmin(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZpopmin(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove and return members with the lowest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmin/">ZPOPMIN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zpopmin(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get one or multiple random elements from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrandmember/">ZRANDMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrandmember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrandmember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get one or multiple random elements from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrandmember/">ZRANDMEMBER</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrandmember(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a range of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrange/">ZRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a range of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrange/">ZRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrange(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebylex/">ZRANGEBYLEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrangebylex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrangebylex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebylex/">ZRANGEBYLEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrangebylex(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a range of members in a sorted set, by score.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebyscore/">ZRANGEBYSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrangebyscore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrangebyscore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by score.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebyscore/">ZRANGEBYSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrangebyscore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Store a range of members from sorted set into another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangestore/">ZRANGESTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrangestore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrangestore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Store a range of members from sorted set into another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangestore/">ZRANGESTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrangestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrangestore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Determine the index of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrank/">ZRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrank(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrank(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Determine the index of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrank/">ZRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrank(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove one or more members from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrem/">ZREM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrem(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrem(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove one or more members from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrem/">ZREM</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrem(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebylex/">ZREMRANGEBYLEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebylex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebylex/">ZREMRANGEBYLEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebylex(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove all members in a sorted set within the given indexes.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyrank/">ZREMRANGEBYRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebyrank(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove all members in a sorted set within the given indexes.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyrank/">ZREMRANGEBYRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebyrank(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Remove all members in a sorted set within the given scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyscore/">ZREMRANGEBYSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebyscore(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Remove all members in a sorted set within the given scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyscore/">ZREMRANGEBYSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebyscore(arg0, arg1, arg2, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrange/">ZREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrange/">ZREVRANGE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrange(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebylex/">ZREVRANGEBYLEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrangebylex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrangebylex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebylex/">ZREVRANGEBYLEX</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrangebylex(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore/">ZREVRANGEBYSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrangebyscore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrangebyscore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore/">ZREVRANGEBYSCORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrangebyscore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrank/">ZREVRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrank(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrank(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrank/">ZREVRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrank(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscan/">ZSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscan/">ZSCAN</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zscan(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Get the score associated with the given member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscore/">ZSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zscore(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZscore(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the score associated with the given member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscore/">ZSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZscore(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zscore(arg0, arg1, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Add multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunion/">ZUNION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zunion(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZunion(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Add multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunion/">ZUNION</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zunion(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunionstore/">ZUNIONSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zunionstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZunionstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunionstore/">ZUNIONSTORE</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zunionstore(args, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  public static io.vertx.rxjava3.redis.client.RedisAPI api(io.vertx.rxjava3.redis.client.Redis client) { 
    io.vertx.rxjava3.redis.client.RedisAPI ret = io.vertx.rxjava3.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.rxjava3.redis.client.RedisAPI api(io.vertx.rxjava3.redis.client.RedisConnection connection) { 
    io.vertx.rxjava3.redis.client.RedisAPI ret = io.vertx.rxjava3.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
