/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An auth handler that provides OAuth2 Authentication support. This handler is suitable for AuthCode flows.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.OAuth2AuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.OAuth2AuthHandler.class)
public class OAuth2AuthHandler implements RxDelegate, io.vertx.rxjava3.ext.web.handler.AuthenticationHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2AuthHandler that = (OAuth2AuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OAuth2AuthHandler> __TYPE_ARG = new TypeArg<>(    obj -> new OAuth2AuthHandler((io.vertx.ext.web.handler.OAuth2AuthHandler) obj),
    OAuth2AuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.OAuth2AuthHandler delegate;
  
  public OAuth2AuthHandler(io.vertx.ext.web.handler.OAuth2AuthHandler delegate) {
    this.delegate = delegate;
  }

  public OAuth2AuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.OAuth2AuthHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.OAuth2AuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a OAuth2 auth handler with host pinning
   * @param vertx the vertx instance
   * @param authProvider the auth provider to use
   * @param callbackURL the callback URL you entered in your provider admin console, usually it should be something like: `https://myserver:8888/callback`
   * @return the auth handler
   */
  public static io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth authProvider, java.lang.String callbackURL) { 
    io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler ret = io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler.newInstance((io.vertx.ext.web.handler.OAuth2AuthHandler)io.vertx.ext.web.handler.OAuth2AuthHandler.create(vertx.getDelegate(), authProvider.getDelegate(), callbackURL));
    return ret;
  }

  /**
   * Create a OAuth2 auth handler without host pinning.
   * Most providers will not look to the redirect url but always redirect to
   * the preconfigured callback. So this factory does not provide a callback url.
   * @param vertx the vertx instance
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth authProvider) { 
    io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler ret = io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler.newInstance((io.vertx.ext.web.handler.OAuth2AuthHandler)io.vertx.ext.web.handler.OAuth2AuthHandler.create(vertx.getDelegate(), authProvider.getDelegate()));
    return ret;
  }

  /**
   * Extra parameters needed to be passed while requesting a token.
   * @param extraParams extra optional parameters.
   * @return self
   */
  public io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler extraParams(io.vertx.core.json.JsonObject extraParams) { 
    delegate.extraParams(extraParams);
    return this;
  }

  /**
   * Return a new instance with the internal state copied from the caller but the scopes to be requested during a token
   * request are unique to the instance.
   * @param scope scope.
   * @return new instance of this interface.
   */
  public io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler withScope(java.lang.String scope) { 
    delegate.withScope(scope);
    return this;
  }

  /**
   * Return a new instance with the internal state copied from the caller but the scopes to be requested during a token
   * request are unique to the instance.
   * @param scopes scopes.
   * @return new instance of this interface.
   */
  public io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler withScopes(java.util.List<java.lang.String> scopes) { 
    delegate.withScopes(scopes);
    return this;
  }

  /**
   * Indicates the type of user interaction that is required. Not all providers support this or the full list.
   *
   * Well known values are:
   *
   * <ul>
   *   <li><b>login</b> will force the user to enter their credentials on that request, negating single-sign on.</li>
   *   <li><b>none</b> is the opposite - it will ensure that the user isn't presented with any interactive prompt whatsoever. If the request can't be completed silently via single-sign on, the Microsoft identity platform endpoint will return an interaction_required error.</li>
   *   <li><b>consent</b> will trigger the OAuth consent dialog after the user signs in, asking the user to grant permissions to the app.</li>
   *   <li><b>select_account</b> will interrupt single sign-on providing account selection experience listing all the accounts either in session or any remembered account or an option to choose to use a different account altogether.</li>
   *   <li><b></b></li>
   * </ul>
   * @param prompt the prompt choice.
   * @return self
   */
  public io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler prompt(java.lang.String prompt) { 
    delegate.prompt(prompt);
    return this;
  }

  /**
   * PKCE (RFC 7636) is an extension to the Authorization Code flow to prevent several attacks and to be able to
   * securely perform the OAuth exchange from public clients.
   *
   * It was originally designed to protect mobile apps, but its ability to prevent authorization code injection
   * makes it useful for every OAuth client, even web apps that use a client secret.
   * @param length A number between 43 and 128. Or -1 to disable.
   * @return self
   */
  public io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler pkceVerifierLength(int length) { 
    delegate.pkceVerifierLength(length);
    return this;
  }

  /**
   * add the callback handler to a given route.
   * @param route a given route e.g.: `/callback`
   * @return self
   */
  public io.vertx.rxjava3.ext.web.handler.OAuth2AuthHandler setupCallback(io.vertx.rxjava3.ext.web.Route route) { 
    delegate.setupCallback(route.getDelegate());
    return this;
  }

  public static OAuth2AuthHandler newInstance(io.vertx.ext.web.handler.OAuth2AuthHandler arg) {
    return arg != null ? new OAuth2AuthHandler(arg) : null;
  }

}
