/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.web.RequestBody.class)
public class RequestBody implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestBody that = (RequestBody) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RequestBody> __TYPE_ARG = new TypeArg<>(    obj -> new RequestBody((io.vertx.ext.web.RequestBody) obj),
    RequestBody::getDelegate
  );

  private final io.vertx.ext.web.RequestBody delegate;
  
  public RequestBody(io.vertx.ext.web.RequestBody delegate) {
    this.delegate = delegate;
  }

  public RequestBody(Object delegate) {
    this.delegate = (io.vertx.ext.web.RequestBody)delegate;
  }

  @Override 
  public io.vertx.ext.web.RequestBody getDelegate() {
    return delegate;
  }

  /**
   * @return the entire HTTP request body as a string, assuming UTF-8 encoding if the request does not provide the content type charset attribute. If a charset is provided in the request that it shall be respected. The context must have first been routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated.
   */
  public java.lang.String asString() { 
    java.lang.String ret = delegate.asString();
    return ret;
  }

  /**
   * Get the entire HTTP request body as a string, assuming the specified encoding. The context must have first been
   * routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated.
   * @param encoding the encoding, e.g. "UTF-16"
   * @return the body
   */
  public java.lang.String asString(java.lang.String encoding) { 
    java.lang.String ret = delegate.asString(encoding);
    return ret;
  }

  /**
   * Gets the current body buffer as a . If a positive limit is provided the parsing will only happen
   * if the buffer length is smaller or equal to the limit. Otherwise an {@link java.lang.IllegalStateException} is thrown.
   *
   * When the application is only handling uploads in JSON format, it is recommended to set a limit on
   * {@link io.vertx.rxjava3.ext.web.handler.BodyHandler#setBodyLimit} as this will avoid the upload to be parsed and
   * loaded into the application memory.
   * @param maxAllowedLength if the current buffer length is greater than the limit an {@link java.lang.IllegalStateException} is thrown. This can be used to avoid DDoS attacks on very long JSON payloads that could take over the CPU while attempting to parse the data.
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned.
   */
  public io.vertx.core.json.JsonObject asJsonObject(int maxAllowedLength) { 
    io.vertx.core.json.JsonObject ret = delegate.asJsonObject(maxAllowedLength);
    return ret;
  }

  /**
   * Gets the current body buffer as a . If a positive limit is provided the parsing will only happen
   * if the buffer length is smaller or equal to the limit. Otherwise an {@link java.lang.IllegalStateException} is thrown.
   *
   * When the application is only handling uploads in JSON format, it is recommended to set a limit on
   * {@link io.vertx.rxjava3.ext.web.handler.BodyHandler#setBodyLimit} as this will avoid the upload to be parsed and
   * loaded into the application memory.
   * @param maxAllowedLength if the current buffer length is greater than the limit an {@link java.lang.IllegalStateException} is thrown. This can be used to avoid DDoS attacks on very long JSON payloads that could take over the CPU while attempting to parse the data.
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned.
   */
  public io.vertx.core.json.JsonArray asJsonArray(int maxAllowedLength) { 
    io.vertx.core.json.JsonArray ret = delegate.asJsonArray(maxAllowedLength);
    return ret;
  }

  /**
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned.
   */
  public io.vertx.core.json.JsonObject asJsonObject() { 
    io.vertx.core.json.JsonObject ret = delegate.asJsonObject();
    return ret;
  }

  /**
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned.
   */
  public io.vertx.core.json.JsonArray asJsonArray() { 
    io.vertx.core.json.JsonArray ret = delegate.asJsonArray();
    return ret;
  }

  /**
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated.
   */
  public io.vertx.rxjava3.core.buffer.Buffer buffer() { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.buffer());
    return ret;
  }

  /**
   * @param clazz 
   * @param maxAllowedLength if the current buffer length is greater than the limit an {@link java.lang.IllegalStateException} is thrown. This can be used to avoid DDoS attacks on very long JSON payloads that could take over the CPU while attempting to parse the data.
   * @return Get the entire HTTP request body as a POJO. The context must have first been routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned. <b>WARNING:</b> This feature requires jackson-databind. Or another JSON codec that implements POJO parsing
   */
  public <R> R asPojo(java.lang.Class<R> clazz, int maxAllowedLength) { 
    R ret = (R)TypeArg.of(clazz).wrap(delegate.asPojo(io.vertx.lang.rxjava3.Helper.unwrap(clazz), maxAllowedLength));
    return ret;
  }

  /**
   * @param clazz 
   * @return Get the entire HTTP request body as a POJO. The context must have first been routed to a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned. <b>WARNING:</b> This feature requires jackson-databind. Or another JSON codec that implements POJO parsing
   */
  public <R> R asPojo(java.lang.Class<R> clazz) { 
    R ret = (R)TypeArg.of(clazz).wrap(delegate.asPojo(io.vertx.lang.rxjava3.Helper.unwrap(clazz)));
    return ret;
  }

  /**
   * Returns the total length of the body buffer. This is the length in bytes. When there is no buffer the length is
   * <code>-1</code>.
   * @return length in bytes.
   */
  public int length() { 
    int ret = delegate.length();
    return ret;
  }

  /**
   * A body can be empty if it is not available, or its length is <code>0</code>.
   * @return <code>true</code> if empty.
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * Return <code>true</code> if a {@link io.vertx.rxjava3.ext.web.handler.BodyHandler} was executed before this call in the lifetime
   * of the request.
   * @return <code>true</code> if body was parsed during the duration of the request.
   */
  public boolean available() { 
    boolean ret = delegate.available();
    return ret;
  }

  public static RequestBody newInstance(io.vertx.ext.web.RequestBody arg) {
    return arg != null ? new RequestBody(arg) : null;
  }

}
