/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.authorization;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a role. Note that this role can optionally be assigned to a
 * specific resource
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.RoleBasedAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.RoleBasedAuthorization.class)
public class RoleBasedAuthorization extends io.vertx.rxjava3.ext.auth.authorization.Authorization implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RoleBasedAuthorization that = (RoleBasedAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RoleBasedAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new RoleBasedAuthorization((io.vertx.ext.auth.authorization.RoleBasedAuthorization) obj),
    RoleBasedAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.RoleBasedAuthorization delegate;
  
  public RoleBasedAuthorization(io.vertx.ext.auth.authorization.RoleBasedAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public RoleBasedAuthorization(Object delegate) {
    super((io.vertx.ext.auth.authorization.RoleBasedAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.authorization.RoleBasedAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.RoleBasedAuthorization getDelegate() {
    return delegate;
  }

  public static io.vertx.rxjava3.ext.auth.authorization.RoleBasedAuthorization create(java.lang.String role) { 
    io.vertx.rxjava3.ext.auth.authorization.RoleBasedAuthorization ret = io.vertx.rxjava3.ext.auth.authorization.RoleBasedAuthorization.newInstance((io.vertx.ext.auth.authorization.RoleBasedAuthorization)io.vertx.ext.auth.authorization.RoleBasedAuthorization.create(role));
    return ret;
  }

  /**
   * returns the role
   * @return 
   */
  public java.lang.String getRole() { 
    java.lang.String ret = delegate.getRole();
    return ret;
  }

  /**
   * returns an optional resource that the role is assigned-on
   * @return 
   */
  public java.lang.String getResource() { 
    java.lang.String ret = delegate.getResource();
    return ret;
  }

  /**
   * sets an optional resource that the role is assigned-on
   * @param resource 
   * @return 
   */
  public io.vertx.rxjava3.ext.auth.authorization.RoleBasedAuthorization setResource(java.lang.String resource) { 
    delegate.setResource(resource);
    return this;
  }

  public static RoleBasedAuthorization newInstance(io.vertx.ext.auth.authorization.RoleBasedAuthorization arg) {
    return arg != null ? new RoleBasedAuthorization(arg) : null;
  }

}
