/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.http;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The state of the HTTP response head:
 *
 * <ul>
 *   <li>Status code / Message</li>
 *   <li>Headers</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpResponseHead original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpResponseHead.class)
public interface HttpResponseHead extends RxDelegate {

  @Override 
  io.vertx.core.http.HttpResponseHead getDelegate();

  /**
   * @return the version of the response
   */
  public io.vertx.core.http.HttpVersion version();

  /**
   * @return the status code of the response
   */
  public int statusCode();

  /**
   * @return the status message of the response
   */
  public java.lang.String statusMessage();

  /**
   * @return the headers
   */
  public io.vertx.rxjava3.core.MultiMap headers();

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public java.lang.String getHeader(java.lang.String headerName);

  /**
   * @return the Set-Cookie headers (including trailers)
   */
  public java.util.List<java.lang.String> cookies();

  public static HttpResponseHead newInstance(io.vertx.core.http.HttpResponseHead arg) {
    return arg != null ? new HttpResponseHeadImpl(arg) : null;
  }

}

class HttpResponseHeadImpl implements HttpResponseHead {
  private final io.vertx.core.http.HttpResponseHead delegate;
  
  public HttpResponseHeadImpl(io.vertx.core.http.HttpResponseHead delegate) {
    this.delegate = delegate;
  }

  public HttpResponseHeadImpl(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpResponseHead)delegate;
  }

  @Override 
  public io.vertx.core.http.HttpResponseHead getDelegate() {
    return delegate;
  }


  /**
   * @return the version of the response
   */
  public io.vertx.core.http.HttpVersion version() { 
    io.vertx.core.http.HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the status code of the response
   */
  public int statusCode() { 
    int ret = delegate.statusCode();
    return ret;
  }

  /**
   * @return the status message of the response
   */
  public java.lang.String statusMessage() { 
    java.lang.String ret = delegate.statusMessage();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.rxjava3.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava3.core.MultiMap ret = io.vertx.rxjava3.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public java.lang.String getHeader(java.lang.String headerName) { 
    java.lang.String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * @return the Set-Cookie headers (including trailers)
   */
  public java.util.List<java.lang.String> cookies() { 
    if (cached_1 != null) {
      return cached_1;
    }
    java.util.List<java.lang.String> ret = delegate.cookies();
    cached_1 = ret;
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public java.lang.String getHeader(java.lang.CharSequence headerName) { 
    java.lang.String ret = delegate.getHeader(headerName);
    return ret;
  }

  private io.vertx.rxjava3.core.MultiMap cached_0;
  private java.util.List<java.lang.String> cached_1;
}
