/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.dns;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Provides a way to asynchronously lookup information from DNS servers.
 * <p>
 * Please consult the documentation for more information on DNS clients.
 * <p>
 * The client is thread safe and can be used from any thread.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.DnsClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.dns.DnsClient.class)
public class DnsClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DnsClient that = (DnsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg<>(    obj -> new DnsClient((io.vertx.core.dns.DnsClient) obj),
    DnsClient::getDelegate
  );

  private final io.vertx.core.dns.DnsClient delegate;
  
  public DnsClient(io.vertx.core.dns.DnsClient delegate) {
    this.delegate = delegate;
  }

  public DnsClient(Object delegate) {
    this.delegate = (io.vertx.core.dns.DnsClient)delegate;
  }

  @Override 
  public io.vertx.core.dns.DnsClient getDelegate() {
    return delegate;
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> lookup(java.lang.String name) { 
    io.reactivex.rxjava3.core.Maybe<java.lang.String> ret = rxLookup(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> rxLookup(java.lang.String name) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lookup(name, handler);
    });
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> lookup4(java.lang.String name) { 
    io.reactivex.rxjava3.core.Maybe<java.lang.String> ret = rxLookup4(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> rxLookup4(java.lang.String name) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lookup4(name, handler);
    });
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> lookup6(java.lang.String name) { 
    io.reactivex.rxjava3.core.Maybe<java.lang.String> ret = rxLookup6(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> rxLookup6(java.lang.String name) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lookup6(name, handler);
    });
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> resolveA(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> ret = rxResolveA(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> rxResolveA(java.lang.String name) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.resolveA(name, handler);
    });
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> resolveAAAA(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> ret = rxResolveAAAA(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> rxResolveAAAA(java.lang.String name) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.resolveAAAA(name, handler);
    });
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> resolveCNAME(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> ret = rxResolveCNAME(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> rxResolveCNAME(java.lang.String name) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.resolveCNAME(name, handler);
    });
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.core.dns.MxRecord>> resolveMX(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.core.dns.MxRecord>> ret = rxResolveMX(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.core.dns.MxRecord>> rxResolveMX(java.lang.String name) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.resolveMX(name, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.rxjava3.core.dns.MxRecord.newInstance((io.vertx.core.dns.MxRecord)elt)).collect(Collectors.toList()))));
    });
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> resolveTXT(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> ret = rxResolveTXT(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> rxResolveTXT(java.lang.String name) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.resolveTXT(name, handler);
    });
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> resolvePTR(java.lang.String name) { 
    io.reactivex.rxjava3.core.Maybe<java.lang.String> ret = rxResolvePTR(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> rxResolvePTR(java.lang.String name) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.resolvePTR(name, handler);
    });
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> resolveNS(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> ret = rxResolveNS(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<java.lang.String>> rxResolveNS(java.lang.String name) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.resolveNS(name, handler);
    });
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.core.dns.SrvRecord>> resolveSRV(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.core.dns.SrvRecord>> ret = rxResolveSRV(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.core.dns.SrvRecord>> rxResolveSRV(java.lang.String name) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.resolveSRV(name, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.rxjava3.core.dns.SrvRecord.newInstance((io.vertx.core.dns.SrvRecord)elt)).collect(Collectors.toList()))));
    });
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> reverseLookup(java.lang.String ipaddress) { 
    io.reactivex.rxjava3.core.Maybe<java.lang.String> ret = rxReverseLookup(ipaddress);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.String> rxReverseLookup(java.lang.String ipaddress) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.reverseLookup(ipaddress, handler);
    });
  }

  /**
   * Close the client.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the client.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
    return arg != null ? new DnsClient(arg) : null;
  }

}
