/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.servicediscovery.types;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Service type for data producer. Providers are publishing data to a specific event bus address.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.MessageSource original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.MessageSource.class)
public class MessageSource implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageSource that = (MessageSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MessageSource> __TYPE_ARG = new TypeArg<>(    obj -> new MessageSource((io.vertx.servicediscovery.types.MessageSource) obj),
    MessageSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.MessageSource delegate;
  
  public MessageSource(io.vertx.servicediscovery.types.MessageSource delegate) {
    this.delegate = delegate;
  }

  public MessageSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.MessageSource)delegate;
  }

  @Override 
  public io.vertx.servicediscovery.types.MessageSource getDelegate() {
    return delegate;
  }

  /**
   * Create a record representing a data producer.
   * @param name the name of the service
   * @param address the address on which the data is sent
   * @param type the type of payload (fully qualified name of the class)
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, java.lang.String address, java.lang.String type, io.vertx.core.json.JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MessageSource.createRecord(name, address, type, metadata);
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.servicediscovery.types.MessageSource#createRecord} without additional metadata.
   * @param name the name of the service
   * @param address the address on which the data is sent
   * @param type the type of payload
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, java.lang.String address, java.lang.String type) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MessageSource.createRecord(name, address, type);
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.servicediscovery.types.MessageSource#createRecord} without additional metadata, and no type for
   * the payload.
   * @param name the name of the service
   * @param address the address on which the data is sent.
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, java.lang.String address) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MessageSource.createRecord(name, address);
    return ret;
  }

  /**
   * Convenient method that looks for a message source and provides the configured . The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static <T> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.eventbus.MessageConsumer<T>> getConsumer(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.eventbus.MessageConsumer<T>> ret = rxGetConsumer(discovery, filter);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Convenient method that looks for a message source and provides the configured . The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static <T> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.eventbus.MessageConsumer<T>> rxGetConsumer(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      io.vertx.servicediscovery.types.MessageSource.getConsumer(discovery.getDelegate(), filter, io.vertx.lang.rxjava3.Helper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)event, TypeArg.unknown()))));
    });
  }

  /**
   * Convenient method that looks for a message source and provides the configured . The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @return 
   */
  public static <T> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.eventbus.MessageConsumer<T>> getConsumer(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.eventbus.MessageConsumer<T>> ret = rxGetConsumer(discovery, filter);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Convenient method that looks for a message source and provides the configured . The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @return 
   */
  public static <T> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.eventbus.MessageConsumer<T>> rxGetConsumer(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      io.vertx.servicediscovery.types.MessageSource.getConsumer(discovery.getDelegate(), filter, io.vertx.lang.rxjava3.Helper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)event, TypeArg.unknown()))));
    });
  }

  /**
   * Unknown type.
   */
  public static final java.lang.String UNKNOWN = io.vertx.servicediscovery.types.MessageSource.UNKNOWN;
  public static final java.lang.String TYPE = io.vertx.servicediscovery.types.MessageSource.TYPE;
  public static MessageSource newInstance(io.vertx.servicediscovery.types.MessageSource arg) {
    return arg != null ? new MessageSource(arg) : null;
  }

}
