/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.grpcio.client;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <p>Extends the  so it can be utilized with .</p>
 *
 * <p>In Vert.x 5, the core  is decoupled from `io.grpc.*` packages to support JPMS.</p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpcio.client.GrpcIoClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpcio.client.GrpcIoClient.class)
public class GrpcIoClient extends io.vertx.rxjava3.grpc.client.GrpcClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcIoClient that = (GrpcIoClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcIoClient> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcIoClient((io.vertx.grpcio.client.GrpcIoClient) obj),
    GrpcIoClient::getDelegate
  );

  private final io.vertx.grpcio.client.GrpcIoClient delegate;
  
  public GrpcIoClient(io.vertx.grpcio.client.GrpcIoClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public GrpcIoClient(Object delegate) {
    super((io.vertx.grpcio.client.GrpcIoClient)delegate);
    this.delegate = (io.vertx.grpcio.client.GrpcIoClient)delegate;
  }

  @Override 
  public io.vertx.grpcio.client.GrpcIoClient getDelegate() {
    return delegate;
  }


  /**
   * Create a new client
   * @param vertx the vertx instance
   * @return the created client
   */
  public static io.vertx.rxjava3.grpcio.client.GrpcIoClient client(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.grpcio.client.GrpcIoClient ret = io.vertx.rxjava3.grpcio.client.GrpcIoClient.newInstance((io.vertx.grpcio.client.GrpcIoClient)io.vertx.grpcio.client.GrpcIoClient.client(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new client
   * @param vertx the vertx instance
   * @param options 
   * @return the created client
   */
  public static io.vertx.rxjava3.grpcio.client.GrpcIoClient client(io.vertx.rxjava3.core.Vertx vertx, io.vertx.grpc.client.GrpcClientOptions options) { 
    io.vertx.rxjava3.grpcio.client.GrpcIoClient ret = io.vertx.rxjava3.grpcio.client.GrpcIoClient.newInstance((io.vertx.grpcio.client.GrpcIoClient)io.vertx.grpcio.client.GrpcIoClient.client(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a new client
   * @param vertx the vertx instance
   * @param options the client options
   * @return the created client
   */
  public static io.vertx.rxjava3.grpcio.client.GrpcIoClient client(io.vertx.rxjava3.core.Vertx vertx, io.vertx.core.http.HttpClientOptions options) { 
    io.vertx.rxjava3.grpcio.client.GrpcIoClient ret = io.vertx.rxjava3.grpcio.client.GrpcIoClient.newInstance((io.vertx.grpcio.client.GrpcIoClient)io.vertx.grpcio.client.GrpcIoClient.client(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Call the <code>service</code> gRPC service hosted by <code>server</code>.
   * <p>
   *   The <code>requestHandler</code> is called to send the request, e.g. <code>req -> req.send(item)</code>
   * <p>
   *   The <code>responseFunction</code> extracts the result, e.g. <code>resp -> resp.last()</code>
   * <p>
   *   It can be used in various ways:
   * <ul>
   *   <li><code>Future<Resp> fut = client.call(..., req -> req.send(item), resp -> resp.last());</code></li>
   *   <li><code>Future<Void> fut = client.call(..., req -> req.send(stream), resp -> resp.pipeTo(anotherService));</code></li>
   *   <li><code>Future<List<Resp>> fut = client.call(..., req -> req.send(stream), resp -> resp.collecting(Collectors.toList()));</code></li>
   * </ul>
   * <pre>
   * @param server the server hosting the service
   * @param service the service to call
   * @param requestHandler the handler called to send the request
   * @param resultFn the function applied to extract the result.
   * @return a future of the result
   */
  public <Req, Resp, T> io.reactivex.rxjava3.core.Single<T> call(io.vertx.rxjava3.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service, io.vertx.core.Handler<io.vertx.rxjava3.grpc.client.GrpcClientRequest<Req,Resp>> requestHandler, java.util.function.Function<io.vertx.rxjava3.grpc.client.GrpcClientResponse<Req,Resp>,io.reactivex.rxjava3.core.Single<T>> resultFn) { 
    io.reactivex.rxjava3.core.Single<T> ret = rxCall(server, service, requestHandler, resultFn);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Call the <code>service</code> gRPC service hosted by <code>server</code>.
   * <p>
   *   The <code>requestHandler</code> is called to send the request, e.g. <code>req -> req.send(item)</code>
   * <p>
   *   The <code>responseFunction</code> extracts the result, e.g. <code>resp -> resp.last()</code>
   * <p>
   *   It can be used in various ways:
   * <ul>
   *   <li><code>Future<Resp> fut = client.call(..., req -> req.send(item), resp -> resp.last());</code></li>
   *   <li><code>Future<Void> fut = client.call(..., req -> req.send(stream), resp -> resp.pipeTo(anotherService));</code></li>
   *   <li><code>Future<List<Resp>> fut = client.call(..., req -> req.send(stream), resp -> resp.collecting(Collectors.toList()));</code></li>
   * </ul>
   * <pre>
   * @param server the server hosting the service
   * @param service the service to call
   * @param requestHandler the handler called to send the request
   * @param resultFn the function applied to extract the result.
   * @return a future of the result
   */
  public <Req, Resp, T> io.reactivex.rxjava3.core.Single<T> rxCall(io.vertx.rxjava3.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service, io.vertx.core.Handler<io.vertx.rxjava3.grpc.client.GrpcClientRequest<Req,Resp>> requestHandler, java.util.function.Function<io.vertx.rxjava3.grpc.client.GrpcClientResponse<Req,Resp>,io.reactivex.rxjava3.core.Single<T>> resultFn) { 
    return AsyncResultSingle.toSingle(delegate.call(server.getDelegate(), service, io.vertx.lang.rxjava3.Helper.convertHandler(requestHandler, event -> io.vertx.rxjava3.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)event, TypeArg.unknown(), TypeArg.unknown())), new Function<io.vertx.grpc.client.GrpcClientResponse<Req,Resp>,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.grpc.client.GrpcClientResponse<Req,Resp> arg) {
        io.reactivex.rxjava3.core.Single<T> ret = resultFn.apply(io.vertx.rxjava3.grpc.client.GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)arg, TypeArg.unknown(), TypeArg.unknown()));
        return io.vertx.rxjava3.SingleHelper.toFuture(ret, obj -> obj);
      }
    }), __value -> (T) __value);
  }

  public static GrpcIoClient newInstance(io.vertx.grpcio.client.GrpcIoClient arg) {
    return arg != null ? new GrpcIoClient(arg) : null;
  }

}
