/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.grpc.server;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.grpc.server.GrpcServerResponse.class)
public class GrpcServerResponse<Req,Resp> extends io.vertx.rxjava3.grpc.common.GrpcWriteStream<Resp> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcServerResponse that = (GrpcServerResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcServerResponse> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcServerResponse((io.vertx.grpc.server.GrpcServerResponse) obj),
    GrpcServerResponse::getDelegate
  );

  private final io.vertx.grpc.server.GrpcServerResponse<Req,Resp> delegate;
  public final TypeArg<Req> __typeArg_0;
  public final TypeArg<Resp> __typeArg_1;
  
  public GrpcServerResponse(io.vertx.grpc.server.GrpcServerResponse delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public GrpcServerResponse(Object delegate, TypeArg<Req> typeArg_0, TypeArg<Resp> typeArg_1) {
    super((io.vertx.grpc.server.GrpcServerResponse)delegate);
    this.delegate = (io.vertx.grpc.server.GrpcServerResponse)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.grpc.server.GrpcServerResponse getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<Resp> observer;
  private WriteStreamSubscriber<Resp> subscriber;

  public synchronized WriteStreamObserver<Resp> toObserver() {
    if (observer == null) {
      Function<Resp, Resp> conv = (Function<Resp, Resp>) __typeArg_0.unwrap;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<Resp> toSubscriber() {
    if (subscriber == null) {
      Function<Resp, Resp> conv = (Function<Resp, Resp>) __typeArg_0.unwrap;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable write(Resp data) { 
    io.reactivex.rxjava3.core.Completable ret = rxWrite(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxWrite(Resp data) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.write(__typeArg_1.<Resp>unwrap(data), handler);
    });
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end() { 
    io.reactivex.rxjava3.core.Completable ret = rxEnd();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.end(handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end(Resp data) { 
    io.reactivex.rxjava3.core.Completable ret = rxEnd(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd(Resp data) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.end(__typeArg_1.<Resp>unwrap(data), handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava3.grpc.server.GrpcServerResponse#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set the grpc status response
   * @param status the status
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> status(io.vertx.grpc.common.GrpcStatus status) { 
    delegate.status(status);
    return this;
  }

  /**
   * Set the grpc status response message
   * @param msg the message
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> statusMessage(java.lang.String msg) { 
    delegate.statusMessage(msg);
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> encoding(java.lang.String encoding) { 
    delegate.encoding(encoding);
    return this;
  }

  /**
   * @return the  to write metadata trailers
   */
  public io.vertx.rxjava3.core.MultiMap trailers() { 
    io.vertx.rxjava3.core.MultiMap ret = io.vertx.rxjava3.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.trailers());
    return ret;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Send the response headers.
   * @return a future notified by the success or failure of the write
   */
  public io.reactivex.rxjava3.core.Completable writeHead() { 
    io.reactivex.rxjava3.core.Completable ret = rxWriteHead();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send the response headers.
   * @return a future notified by the success or failure of the write
   */
  public io.reactivex.rxjava3.core.Completable rxWriteHead() { 
    return AsyncResultCompletable.toCompletable(delegate.writeHead());
  }

  public io.reactivex.rxjava3.core.Completable send(Resp item) { 
    io.reactivex.rxjava3.core.Completable ret = rxSend(item);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Completable rxSend(Resp item) { 
    return AsyncResultCompletable.toCompletable(delegate.send(__typeArg_1.<Resp>unwrap(item)));
  }

  public io.reactivex.rxjava3.core.Completable send(io.reactivex.rxjava3.core.Flowable<Resp> body) { 
    io.reactivex.rxjava3.core.Completable ret = rxSend(body);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Completable rxSend(io.reactivex.rxjava3.core.Flowable<Resp> body) { 
    return AsyncResultCompletable.toCompletable(delegate.send(io.vertx.rxjava3.impl.ReadStreamSubscriber.asReadStream(body, obj -> __typeArg_1.<Resp>unwrap(obj)).resume()));
  }

  public static <Req,Resp> GrpcServerResponse<Req,Resp> newInstance(io.vertx.grpc.server.GrpcServerResponse arg) {
    return arg != null ? new GrpcServerResponse<Req,Resp>(arg) : null;
  }

  public static <Req,Resp> GrpcServerResponse<Req,Resp> newInstance(io.vertx.grpc.server.GrpcServerResponse arg, TypeArg<Req> __typeArg_Req, TypeArg<Resp> __typeArg_Resp) {
    return arg != null ? new GrpcServerResponse<Req,Resp>(arg, __typeArg_Req, __typeArg_Resp) : null;
  }

}
