/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.otp.totp;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An extension of AuthProvider which uses the one time passwords based on time to perform authentication.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.otp.totp.TotpAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.otp.totp.TotpAuth.class)
public class TotpAuth extends io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TotpAuth that = (TotpAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TotpAuth> __TYPE_ARG = new TypeArg<>(    obj -> new TotpAuth((io.vertx.ext.auth.otp.totp.TotpAuth) obj),
    TotpAuth::getDelegate
  );

  private final io.vertx.ext.auth.otp.totp.TotpAuth delegate;
  
  public TotpAuth(io.vertx.ext.auth.otp.totp.TotpAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public TotpAuth(Object delegate) {
    super((io.vertx.ext.auth.otp.totp.TotpAuth)delegate);
    this.delegate = (io.vertx.ext.auth.otp.totp.TotpAuth)delegate;
  }

  @Override 
  public io.vertx.ext.auth.otp.totp.TotpAuth getDelegate() {
    return delegate;
  }


  /**
   * Provide a  that can fetch s from a backend given an <code>identifier</code>
   * argument.
   *
   * The function signature is as follows:
   *
   * <code>(id) -> Future<Authenticator></code>
   *
   * <ul>
   *   <li><code>id</code> the identifier to lookup.</li>
   *   <li> async result with a authenticator.</li>
   * </ul>
   * @param fetcher fetcher function.
   * @return fluent self.
   */
  public io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth authenticatorFetcher(java.util.function.Function<java.lang.String,io.reactivex.rxjava3.core.Single<io.vertx.ext.auth.otp.Authenticator>> fetcher) { 
    delegate.authenticatorFetcher(new Function<java.lang.String,io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator>>() {
      public io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> apply(java.lang.String arg) {
        io.reactivex.rxjava3.core.Single<io.vertx.ext.auth.otp.Authenticator> ret = fetcher.apply(arg);
        return io.vertx.rxjava3.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return this;
  }

  /**
   * Provide a  that can update or insert a .
   * The function <strong>should</strong> store a given authenticator to a persistence storage.
   *
   * When an authenticator is already present, this method <strong>must</strong> at least update
   * , and is not required to perform any other update.
   *
   * For new authenticators, the whole object data <strong>must</strong> be persisted.
   *
   * The function signature is as follows:
   *
   * <code>(Authenticator) -> Future<Void></code>
   *
   * <ul>
   *   <li> the authenticator data to update.</li>
   *   <li>async result of the operation.</li>
   * </ul>
   * @param updater updater function.
   * @return fluent self.
   */
  public io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth authenticatorUpdater(java.util.function.Function<io.vertx.ext.auth.otp.Authenticator,io.reactivex.rxjava3.core.Completable> updater) { 
    delegate.authenticatorUpdater(new Function<io.vertx.ext.auth.otp.Authenticator,io.vertx.core.Future<java.lang.Void>>() {
      public io.vertx.core.Future<java.lang.Void> apply(io.vertx.ext.auth.otp.Authenticator arg) {
        io.reactivex.rxjava3.core.Completable ret = updater.apply(arg);
        return io.vertx.rxjava3.CompletableHelper.toFuture(ret);
      }
    });
    return this;
  }

  /**
   * Creating authenticator from user id and key.
   * @param id id user.
   * @param otpKey key of user used for auth.
   * @return  an object containing all the necessary information to authenticate a user.
   */
  public io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> createAuthenticator(java.lang.String id, io.vertx.ext.auth.otp.OtpKey otpKey) { 
    io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> ret = delegate.createAuthenticator(id, otpKey).map(val -> val);
    return ret;
  }

  /**
   * Creating URI for register in key in user device.
   * @param otpKey user key.
   * @param issuer issuer of key.
   * @param user display name of user account.
   * @param label the label to identify which account a key is associated with.
   * @return uri containing the key.
   */
  public java.lang.String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, java.lang.String issuer, java.lang.String user, java.lang.String label) { 
    java.lang.String ret = delegate.generateUri(otpKey, issuer, user, label);
    return ret;
  }

  /**
   * Creating URI for register in key in user device.
   * @param otpKey user key.
   * @param issuer issuer of key.
   * @param user display name of user account.
   * @return uri containing the key.
   */
  public java.lang.String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, java.lang.String issuer, java.lang.String user) { 
    java.lang.String ret = delegate.generateUri(otpKey, issuer, user);
    return ret;
  }

  /**
   * Creating URI for register in key in user device.
   * @param otpKey user key.
   * @param label the label to identify which account a key is associated with.
   * @return uri containing the key.
   */
  public java.lang.String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, java.lang.String label) { 
    java.lang.String ret = delegate.generateUri(otpKey, label);
    return ret;
  }

  /**
   * Creates an instance of TotpAuth.
   * @return the created instance of {@link io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth}.
   */
  public static io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth create() { 
    io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth ret = io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth.newInstance((io.vertx.ext.auth.otp.totp.TotpAuth)io.vertx.ext.auth.otp.totp.TotpAuth.create());
    return ret;
  }

  /**
   * Creates an instance of TotpAuth.
   * @param totpAuthOptions the config.
   * @return the created instance of {@link io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth}.
   */
  public static io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth create(io.vertx.ext.auth.otp.totp.TotpAuthOptions totpAuthOptions) { 
    io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth ret = io.vertx.rxjava3.ext.auth.otp.totp.TotpAuth.newInstance((io.vertx.ext.auth.otp.totp.TotpAuth)io.vertx.ext.auth.otp.totp.TotpAuth.create(totpAuthOptions));
    return ret;
  }

  public static TotpAuth newInstance(io.vertx.ext.auth.otp.totp.TotpAuth arg) {
    return arg != null ? new TotpAuth(arg) : null;
  }

}
