/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.net;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a TCP server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetServer.class)
public class NetServer implements RxDelegate, io.vertx.rxjava3.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  public NetServer(Object delegate) {
    this.delegate = (io.vertx.core.net.NetServer)delegate;
  }

  @Override 
  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.core.net.NetSocket> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.core.net.NetSocket>(o1 -> io.vertx.rxjava3.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the connect stream for this server. The server can only have at most one handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.rxjava3.core.net.NetSocket} and passes it to the
   * connect stream .
   * @return the connect stream
   */
  @Deprecated()
  public io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.net.NetSocket> connectStream() { 
    io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.net.NetSocket> ret = io.vertx.rxjava3.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.connectStream(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.rxjava3.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.net.NetServer connectHandler(io.vertx.core.Handler<io.vertx.rxjava3.core.net.NetSocket> handler) { 
    io.vertx.rxjava3.core.net.NetServer ret = io.vertx.rxjava3.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.connectHandler(io.vertx.lang.rxjava3.Helper.convertHandler(handler, event -> io.vertx.rxjava3.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> listen() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> ret = rxListen();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> rxListen() { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(io.vertx.lang.rxjava3.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.rxjava3.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)event))));
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> listen(int port, java.lang.String host) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> ret = rxListen(port, host);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> rxListen(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(port, host, io.vertx.lang.rxjava3.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.rxjava3.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)event))));
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> listen(int port) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> ret = rxListen(port);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> rxListen(int port) { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(port, io.vertx.lang.rxjava3.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.rxjava3.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)event))));
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> listen(io.vertx.rxjava3.core.net.SocketAddress localAddress) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> ret = rxListen(localAddress);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.NetServer> rxListen(io.vertx.rxjava3.core.net.SocketAddress localAddress) { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(localAddress.getDelegate(), io.vertx.lang.rxjava3.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.rxjava3.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)event))));
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    io.reactivex.rxjava3.core.Single<java.lang.Boolean> ret = rxUpdateSSLOptions(options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.updateSSLOptions(options, handler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) { 
    io.reactivex.rxjava3.core.Single<java.lang.Boolean> ret = rxUpdateSSLOptions(options, force);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.net.NetServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.updateSSLOptions(options, force, handler);
    });
  }

  /**
   * Update traffic shaping options <code>options</code>, the update happens if valid values are passed for traffic
   * shaping options. This update happens synchronously and at best effort for rate update to take effect immediately.
   * @param options the new traffic shaping options
   */
  public void updateTrafficShapingOptions(io.vertx.core.net.TrafficShapingOptions options) { 
    delegate.updateTrafficShapingOptions(options);
  }

  public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }

}
