/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A builder for creating Vert.x instances, allowing to configure Vert.x plugins:
 *
 * <ul>
 *   <li>metrics</li>
 *   <li>tracing</li>
 *   <li>cluster manager</li>
 * </ul>
 *
 * Example usage:
 *
 * <pre><code>
 *   Vertx vertx = Vertx.builder().with(options).withMetrics(metricsFactory).build();
 * </code></pre>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.VertxBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.VertxBuilder.class)
public class VertxBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxBuilder that = (VertxBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<VertxBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new VertxBuilder((io.vertx.core.VertxBuilder) obj),
    VertxBuilder::getDelegate
  );

  private final io.vertx.core.VertxBuilder delegate;
  
  public VertxBuilder(io.vertx.core.VertxBuilder delegate) {
    this.delegate = delegate;
  }

  public VertxBuilder(Object delegate) {
    this.delegate = (io.vertx.core.VertxBuilder)delegate;
  }

  @Override 
  public io.vertx.core.VertxBuilder getDelegate() {
    return delegate;
  }

  /**
   * Configure the Vert.x options.
   * @param options the Vert.x options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.VertxBuilder with(io.vertx.core.VertxOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * Creates a non clustered instance.
   * @return the instance
   */
  public io.vertx.rxjava3.core.Vertx build() { 
    io.vertx.rxjava3.core.Vertx ret = io.vertx.rxjava3.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.build());
    return ret;
  }

  /**
   * Creates a clustered instance.
   * <p>
   * The instance is created asynchronously and the returned future is completed with the result when it is ready.
   * @return a future completed with the clustered vertx
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.Vertx> buildClustered() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.Vertx> ret = rxBuildClustered();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Creates a clustered instance.
   * <p>
   * The instance is created asynchronously and the returned future is completed with the result when it is ready.
   * @return a future completed with the clustered vertx
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.Vertx> rxBuildClustered() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.buildClustered(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.Vertx.newInstance((io.vertx.core.Vertx)event))));
    });
  }

  /**
   * Programmatically set the metrics factory to be used when metrics are enabled.
   * <p>
   * Only valid if  = true.
   * <p>
   * Normally Vert.x will look on the classpath for a metrics factory implementation, but if you want to set one
   * programmatically you can use this method.
   * @param factory the metrics factory
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.VertxBuilder withMetrics(io.vertx.core.spi.VertxMetricsFactory factory) { 
    delegate.withMetrics(factory);
    return this;
  }

  /**
   * Programmatically set the tracer factory to be used when tracing are enabled.
   * <p>
   * Normally Vert.x will look on the classpath for a tracer factory implementation, but if you want to set one
   * programmatically you can use this method.
   * @param factory the tracer factory
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.VertxBuilder withTracer(io.vertx.core.spi.VertxTracerFactory factory) { 
    delegate.withTracer(factory);
    return this;
  }

  /**
   * Programmatically set the cluster manager to be used when clustering.
   * <p>
   * Only valid if clustered = true.
   * <p>
   * Normally Vert.x will look on the classpath for a cluster manager, but if you want to set one
   * programmatically you can use this method.
   * @param clusterManager the cluster manager
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.VertxBuilder withClusterManager(io.vertx.core.spi.cluster.ClusterManager clusterManager) { 
    delegate.withClusterManager(clusterManager);
    return this;
  }

  public static VertxBuilder newInstance(io.vertx.core.VertxBuilder arg) {
    return arg != null ? new VertxBuilder(arg) : null;
  }

}
