/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.openapi.validation;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.openapi.validation.ResponseParameter.class)
public class ResponseParameter implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResponseParameter that = (ResponseParameter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ResponseParameter> __TYPE_ARG = new TypeArg<>(    obj -> new ResponseParameter((io.vertx.openapi.validation.ResponseParameter) obj),
    ResponseParameter::getDelegate
  );

  private final io.vertx.openapi.validation.ResponseParameter delegate;
  
  public ResponseParameter(io.vertx.openapi.validation.ResponseParameter delegate) {
    this.delegate = delegate;
  }

  public ResponseParameter(Object delegate) {
    this.delegate = (io.vertx.openapi.validation.ResponseParameter)delegate;
  }

  @Override 
  public io.vertx.openapi.validation.ResponseParameter getDelegate() {
    return delegate;
  }

  public static ResponseParameter newInstance(io.vertx.openapi.validation.ResponseParameter arg) {
    return arg != null ? new ResponseParameter(arg) : null;
  }

}
