/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.openapi;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.web.openapi.OpenAPIHolder.class)
public class OpenAPIHolder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenAPIHolder that = (OpenAPIHolder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OpenAPIHolder> __TYPE_ARG = new TypeArg<>(    obj -> new OpenAPIHolder((io.vertx.ext.web.openapi.OpenAPIHolder) obj),
    OpenAPIHolder::getDelegate
  );

  private final io.vertx.ext.web.openapi.OpenAPIHolder delegate;
  
  public OpenAPIHolder(io.vertx.ext.web.openapi.OpenAPIHolder delegate) {
    this.delegate = delegate;
  }

  public OpenAPIHolder(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.OpenAPIHolder)delegate;
  }

  @Override 
  public io.vertx.ext.web.openapi.OpenAPIHolder getDelegate() {
    return delegate;
  }

  /**
   * Get cached object using <code>pointer</code>
   * @param pointer 
   * @return 
   */
  public io.vertx.core.json.JsonObject getCached(io.vertx.rxjava3.core.json.pointer.JsonPointer pointer) { 
    io.vertx.core.json.JsonObject ret = delegate.getCached(pointer.getDelegate());
    return ret;
  }

  /**
   * if <code>obj</code> contains <code>$ref</code>, it tries to solve it and return the resolved object, otherwise it returns <code>obj</code>
   * @param obj 
   * @return 
   */
  public io.vertx.core.json.JsonObject solveIfNeeded(io.vertx.core.json.JsonObject obj) { 
    io.vertx.core.json.JsonObject ret = delegate.solveIfNeeded(obj);
    return ret;
  }

  /**
   * @return the root of the OpenAPI document
   */
  public io.vertx.core.json.JsonObject getOpenAPI() { 
    io.vertx.core.json.JsonObject ret = delegate.getOpenAPI();
    return ret;
  }

  public static OpenAPIHolder newInstance(io.vertx.ext.web.openapi.OpenAPIHolder arg) {
    return arg != null ? new OpenAPIHolder(arg) : null;
  }

}
