/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.oauth2.providers;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an {@link io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth} for Google.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.GoogleAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.GoogleAuth.class)
public class GoogleAuth extends io.vertx.rxjava3.ext.auth.oauth2.providers.OpenIDConnectAuth implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GoogleAuth that = (GoogleAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GoogleAuth> __TYPE_ARG = new TypeArg<>(    obj -> new GoogleAuth((io.vertx.ext.auth.oauth2.providers.GoogleAuth) obj),
    GoogleAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.GoogleAuth delegate;
  
  public GoogleAuth(io.vertx.ext.auth.oauth2.providers.GoogleAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public GoogleAuth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.providers.GoogleAuth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.providers.GoogleAuth)delegate;
  }

  @Override 
  public io.vertx.ext.auth.oauth2.providers.GoogleAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Google
   * @param vertx 
   * @param clientId the client id given to you by Google
   * @param clientSecret the client secret given to you by Google
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String clientId, java.lang.String clientSecret) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Google
   * @param vertx 
   * @param clientId the client id given to you by Google
   * @param clientSecret the client secret given to you by Google
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String clientId, java.lang.String clientSecret, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth> discover(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth> ret = rxDiscover(vertx, config);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth> rxDiscover(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return AsyncResultSingle.toSingle( handler -> {
      io.vertx.ext.auth.oauth2.providers.GoogleAuth.discover(vertx.getDelegate(), config, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)event))));
    });
  }

  /**
   * Create a OAuth2Auth provider for Google Service Account (Server to Server)
   * @param vertx 
   * @param serviceAccountJson the configuration json file from your Google API page
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.core.json.JsonObject serviceAccountJson) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), serviceAccountJson));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Google Service Account (Server to Server)
   * @param vertx 
   * @param serviceAccountJson the configuration json file from your Google API page
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.core.json.JsonObject serviceAccountJson, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), serviceAccountJson, httpClientOptions));
    return ret;
  }

  public static GoogleAuth newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth arg) {
    return arg != null ? new GoogleAuth(arg) : null;
  }

}
