/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.shareddata;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous counter that can be used to across the cluster to maintain a consistent count.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Counter original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.Counter.class)
public class Counter implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Counter that = (Counter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Counter> __TYPE_ARG = new TypeArg<>(    obj -> new Counter((io.vertx.core.shareddata.Counter) obj),
    Counter::getDelegate
  );

  private final io.vertx.core.shareddata.Counter delegate;
  
  public Counter(io.vertx.core.shareddata.Counter delegate) {
    this.delegate = delegate;
  }

  public Counter(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.Counter)delegate;
  }

  @Override 
  public io.vertx.core.shareddata.Counter getDelegate() {
    return delegate;
  }

  /**
   * Get the current value of the counter
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> get() { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxGet();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the current value of the counter
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxGet() { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.get(resultHandler);
    });
  }

  /**
   * Increment the counter atomically and return the new count
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> incrementAndGet() { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxIncrementAndGet();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Increment the counter atomically and return the new count
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxIncrementAndGet() { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.incrementAndGet(resultHandler);
    });
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> getAndIncrement() { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxGetAndIncrement();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxGetAndIncrement() { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getAndIncrement(resultHandler);
    });
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> decrementAndGet() { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxDecrementAndGet();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxDecrementAndGet() { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.decrementAndGet(resultHandler);
    });
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> addAndGet(long value) { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxAddAndGet(value);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxAddAndGet(long value) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.addAndGet(value, resultHandler);
    });
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> getAndAdd(long value) { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxGetAndAdd(value);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxGetAndAdd(long value) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getAndAdd(value, resultHandler);
    });
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> compareAndSet(long expected, long value) { 
    io.reactivex.rxjava3.core.Single<java.lang.Boolean> ret = rxCompareAndSet(expected, value);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> rxCompareAndSet(long expected, long value) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.compareAndSet(expected, value, resultHandler);
    });
  }

  public static Counter newInstance(io.vertx.core.shareddata.Counter arg) {
    return arg != null ? new Counter(arg) : null;
  }

}
