/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.amqp;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.amqp.AmqpConnection;
import io.vertx.rxjava3.amqp.AmqpReceiver;
import io.vertx.rxjava3.amqp.AmqpSender;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.amqp.AmqpClient.class)
public class AmqpClient
implements RxDelegate {
    public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg(obj -> new AmqpClient((io.vertx.amqp.AmqpClient)obj), AmqpClient::getDelegate);
    private final io.vertx.amqp.AmqpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpClient that = (AmqpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
        this.delegate = delegate;
    }

    public AmqpClient(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpClient)delegate;
    }

    public io.vertx.amqp.AmqpClient getDelegate() {
        return this.delegate;
    }

    public static AmqpClient create(AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((AmqpClientOptions)options));
        return ret;
    }

    public static AmqpClient create(io.vertx.rxjava3.core.Vertx vertx, AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((Vertx)vertx.getDelegate(), (AmqpClientOptions)options));
        return ret;
    }

    public Single<AmqpConnection> connect() {
        Single ret = this.rxConnect();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpConnection> rxConnect() {
        return AsyncResultSingle.toSingle(connectionHandler -> this.delegate.connect(Helper.convertHandler((Handler)connectionHandler, ar -> ar.map(event -> AmqpConnection.newInstance(event)))));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(closeHandler -> this.delegate.close(closeHandler));
    }

    public Single<AmqpReceiver> createReceiver(String address) {
        Single ret = this.rxCreateReceiver(address);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address) {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createReceiver(address, Helper.convertHandler((Handler)completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event)))));
    }

    public Single<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        Single ret = this.rxCreateReceiver(address, receiverOptions);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createReceiver(address, receiverOptions, Helper.convertHandler((Handler)completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event)))));
    }

    public Single<AmqpSender> createSender(String address) {
        Single ret = this.rxCreateSender(address);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpSender> rxCreateSender(String address) {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createSender(address, Helper.convertHandler((Handler)completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event)))));
    }

    public Single<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        Single ret = this.rxCreateSender(address, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpSender> rxCreateSender(String address, AmqpSenderOptions options) {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createSender(address, options, Helper.convertHandler((Handler)completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event)))));
    }

    public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
        return arg != null ? new AmqpClient(arg) : null;
    }
}

