/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.amqp;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.proton.ProtonConnection;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.amqp.AmqpReceiver;
import io.vertx.rxjava3.amqp.AmqpSender;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection {
    public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg(obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection)obj), AmqpConnection::getDelegate);
    private final io.vertx.amqp.AmqpConnection delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpConnection that = (AmqpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
        this.delegate = delegate;
    }

    public AmqpConnection(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpConnection)delegate;
    }

    public io.vertx.amqp.AmqpConnection getDelegate() {
        return this.delegate;
    }

    public AmqpConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(done -> this.delegate.close(done));
    }

    public Single<AmqpReceiver> createReceiver(String address) {
        Single ret = this.rxCreateReceiver(address);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address) {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createReceiver(address, (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event)))));
    }

    public Single<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        Single ret = this.rxCreateReceiver(address, receiverOptions);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createReceiver(address, receiverOptions, (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event)))));
    }

    public Single<AmqpReceiver> createDynamicReceiver() {
        Single ret = this.rxCreateDynamicReceiver();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpReceiver> rxCreateDynamicReceiver() {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createDynamicReceiver((Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event)))));
    }

    public Single<AmqpSender> createSender(String address) {
        Single ret = this.rxCreateSender(address);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpSender> rxCreateSender(String address) {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createSender(address, (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event)))));
    }

    public Single<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        Single ret = this.rxCreateSender(address, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpSender> rxCreateSender(String address, AmqpSenderOptions options) {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createSender(address, options, (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event)))));
    }

    public Single<AmqpSender> createAnonymousSender() {
        Single ret = this.rxCreateAnonymousSender();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AmqpSender> rxCreateAnonymousSender() {
        return AsyncResultSingle.toSingle(completionHandler -> this.delegate.createAnonymousSender((Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event)))));
    }

    public boolean isDisconnected() {
        boolean ret = this.delegate.isDisconnected();
        return ret;
    }

    public Future<Void> closeFuture() {
        Future ret = this.delegate.closeFuture().map(val -> val);
        return ret;
    }

    public ProtonConnection unwrap() {
        ProtonConnection ret = this.delegate.unwrap();
        return ret;
    }

    public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
        return arg != null ? new AmqpConnection(arg) : null;
    }
}

