/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.servicediscovery;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.MaybeHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.servicediscovery.ServiceReference;
import io.vertx.rxjava3.servicediscovery.spi.ServiceExporter;
import io.vertx.rxjava3.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.servicediscovery.ServiceDiscovery.class)
public class ServiceDiscovery {
    public static final TypeArg<ServiceDiscovery> __TYPE_ARG = new TypeArg(obj -> new ServiceDiscovery((io.vertx.servicediscovery.ServiceDiscovery)obj), ServiceDiscovery::getDelegate);
    private final io.vertx.servicediscovery.ServiceDiscovery delegate;
    private static final TypeArg<ServiceReference> TYPE_ARG_0 = new TypeArg(o1 -> ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)o1), o1 -> o1.getDelegate());
    public static final String EVENT_TYPE = "type";
    public static final String EVENT_TYPE_BIND = "bind";
    public static final String EVENT_TYPE_RELEASE = "release";
    public static final String EVENT_RECORD = "record";
    public static final String EVENT_ID = "id";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDiscovery that = (ServiceDiscovery)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ServiceDiscovery(io.vertx.servicediscovery.ServiceDiscovery delegate) {
        this.delegate = delegate;
    }

    public ServiceDiscovery(Object delegate) {
        this.delegate = (io.vertx.servicediscovery.ServiceDiscovery)delegate;
    }

    public io.vertx.servicediscovery.ServiceDiscovery getDelegate() {
        return this.delegate;
    }

    public static ServiceDiscovery create(io.vertx.rxjava3.core.Vertx vertx, ServiceDiscoveryOptions options) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate(), (ServiceDiscoveryOptions)options));
        return ret;
    }

    public static ServiceDiscovery create(io.vertx.rxjava3.core.Vertx vertx) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public ServiceReference getReference(Record record) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReference(record));
        return ret;
    }

    public ServiceReference getReferenceWithConfiguration(Record record, JsonObject configuration) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReferenceWithConfiguration(record, configuration));
        return ret;
    }

    public boolean release(ServiceReference reference) {
        boolean ret = this.delegate.release(reference.getDelegate());
        return ret;
    }

    public Completable registerServiceImporter(ServiceImporter importer, JsonObject configuration) {
        Completable ret = this.rxRegisterServiceImporter(importer, configuration);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxRegisterServiceImporter(ServiceImporter importer, JsonObject configuration) {
        return AsyncResultCompletable.toCompletable(completionHandler -> this.delegate.registerServiceImporter(importer.getDelegate(), configuration, completionHandler));
    }

    public Completable registerServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        Completable ret = this.rxRegisterServiceExporter(exporter, configuration);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxRegisterServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        return AsyncResultCompletable.toCompletable(completionHandler -> this.delegate.registerServiceExporter(exporter.getDelegate(), configuration, completionHandler));
    }

    public void close() {
        this.delegate.close();
    }

    public Single<Record> publish(Record record) {
        Single ret = this.rxPublish(record);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Record> rxPublish(Record record) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.publish(record, resultHandler));
    }

    public Completable unpublish(String id) {
        Completable ret = this.rxUnpublish(id);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUnpublish(String id) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.unpublish(id, resultHandler));
    }

    public Maybe<Record> getRecord(JsonObject filter) {
        Maybe ret = this.rxGetRecord(filter);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<Record> rxGetRecord(JsonObject filter) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.getRecord(filter, resultHandler));
    }

    public Maybe<Record> getRecord(String id) {
        Maybe ret = this.rxGetRecord(id);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<Record> rxGetRecord(String id) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.getRecord(id, resultHandler));
    }

    public Maybe<Record> getRecord(Function<Record, Boolean> filter) {
        Maybe ret = this.rxGetRecord(filter);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<Record> rxGetRecord(Function<Record, Boolean> filter) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.getRecord(filter, resultHandler));
    }

    public Maybe<Record> getRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        Maybe ret = this.rxGetRecord(filter, includeOutOfService);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<Record> rxGetRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.getRecord(filter, includeOutOfService, resultHandler));
    }

    public Single<List<Record>> getRecords(JsonObject filter) {
        Single ret = this.rxGetRecords(filter);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<Record>> rxGetRecords(JsonObject filter) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.getRecords(filter, resultHandler));
    }

    public Single<List<Record>> getRecords(Function<Record, Boolean> filter) {
        Single ret = this.rxGetRecords(filter);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<Record>> rxGetRecords(Function<Record, Boolean> filter) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.getRecords(filter, resultHandler));
    }

    public Single<List<Record>> getRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        Single ret = this.rxGetRecords(filter, includeOutOfService);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<Record>> rxGetRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.getRecords(filter, includeOutOfService, resultHandler));
    }

    public Single<Record> update(Record record) {
        Single ret = this.rxUpdate(record);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Record> rxUpdate(Record record) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.update(record, resultHandler));
    }

    public Set<ServiceReference> bindings() {
        Set<ServiceReference> ret = this.delegate.bindings().stream().map(elt -> ServiceReference.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public ServiceDiscoveryOptions options() {
        ServiceDiscoveryOptions ret = this.delegate.options();
        return ret;
    }

    public static void releaseServiceObject(ServiceDiscovery discovery, Object svcObject) {
        io.vertx.servicediscovery.ServiceDiscovery.releaseServiceObject((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), (Object)svcObject);
    }

    public static ServiceDiscovery newInstance(io.vertx.servicediscovery.ServiceDiscovery arg) {
        return arg != null ? new ServiceDiscovery(arg) : null;
    }
}

