/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.MultiMap;
import io.vertx.rxjava3.core.http.HttpClientRequest;
import io.vertx.rxjava3.core.http.HttpClientResponse;
import io.vertx.rxjava3.core.http.HttpConnection;
import io.vertx.rxjava3.core.http.WebSocket;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClient.class)
public class HttpClient
implements Measured {
    public static final TypeArg<HttpClient> __TYPE_ARG = new TypeArg(obj -> new HttpClient((io.vertx.core.http.HttpClient)obj), HttpClient::getDelegate);
    private final io.vertx.core.http.HttpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClient(io.vertx.core.http.HttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpClient(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClient)delegate;
    }

    public io.vertx.core.http.HttpClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public Single<HttpClientRequest> request(RequestOptions options) {
        Single ret = this.rxRequest(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientRequest> rxRequest(RequestOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.request(options, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event)))));
    }

    public Single<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
        Single ret = this.rxRequest(method, port, host, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.request(method, port, host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event)))));
    }

    public Single<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
        Single ret = this.rxRequest(method, host, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, String host, String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.request(method, host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event)))));
    }

    public Single<HttpClientRequest> request(HttpMethod method, String requestURI) {
        Single ret = this.rxRequest(method, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.request(method, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event)))));
    }

    public Single<WebSocket> webSocket(int port, String host, String requestURI) {
        Single ret = this.rxWebSocket(port, host, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxWebSocket(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.webSocket(port, host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public Single<WebSocket> webSocket(String host, String requestURI) {
        Single ret = this.rxWebSocket(host, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxWebSocket(String host, String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.webSocket(host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public Single<WebSocket> webSocket(String requestURI) {
        Single ret = this.rxWebSocket(requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxWebSocket(String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.webSocket(requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public Single<WebSocket> webSocket(WebSocketConnectOptions options) {
        Single ret = this.rxWebSocket(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxWebSocket(WebSocketConnectOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.webSocket(options, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public Single<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        Single ret = this.rxWebSocketAbs(url, headers, version, subProtocols);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxWebSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.webSocketAbs(url, headers.getDelegate(), version, subProtocols, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new DelegatingHandler(handler, event -> HttpConnection.newInstance(event)));
        return this;
    }

    public HttpClient redirectHandler(final Function<HttpClientResponse, Single<RequestOptions>> handler) {
        this.delegate.redirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, Future<RequestOptions>>(){

            @Override
            public Future<RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
                Single ret = (Single)handler.apply(HttpClientResponse.newInstance(arg));
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        });
        return this;
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public static HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
        return arg != null ? new HttpClient(arg) : null;
    }
}

