/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.MultiMap;
import io.vertx.rxjava3.core.http.WebSocketBase;
import io.vertx.rxjava3.core.http.WebSocketFrame;
import io.vertx.rxjava3.core.net.SocketAddress;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.ServerWebSocket.class)
public class ServerWebSocket
implements WebSocketBase {
    public static final TypeArg<ServerWebSocket> __TYPE_ARG = new TypeArg(obj -> new ServerWebSocket((io.vertx.core.http.ServerWebSocket)obj), ServerWebSocket::getDelegate);
    private final io.vertx.core.http.ServerWebSocket delegate;
    private Observable<io.vertx.rxjava3.core.buffer.Buffer> observable;
    private Flowable<io.vertx.rxjava3.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> subscriber;
    private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerWebSocket that = (ServerWebSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ServerWebSocket(io.vertx.core.http.ServerWebSocket delegate) {
        this.delegate = delegate;
    }

    public ServerWebSocket(Object delegate) {
        this.delegate = (io.vertx.core.http.ServerWebSocket)delegate;
    }

    public io.vertx.core.http.ServerWebSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.rxjava3.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable((ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.rxjava3.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    public synchronized WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Completable write(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public Completable end(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxEnd(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end((Object)data.getDelegate(), handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.rxjava3.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.rxjava3.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Override
    public Completable writePing(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWritePing(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWritePing(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writePing(data.getDelegate(), handler));
    }

    @Override
    public Completable writePong(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWritePong(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWritePong(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writePong(data.getDelegate(), handler));
    }

    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(final Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) {
        this.delegate.binaryMessageHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.rxjava3.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pongHandler(final Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) {
        this.delegate.pongHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.rxjava3.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(handler));
    }

    @Override
    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    @Override
    public Completable close(short statusCode) {
        Completable ret = this.rxClose(statusCode);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose(short statusCode) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(statusCode, handler));
    }

    @Override
    public Completable close(short statusCode, String reason) {
        Completable ret = this.rxClose(statusCode, reason);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(statusCode, reason, handler));
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    @Override
    public ServerWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public ServerWebSocket handler(final Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.rxjava3.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public ServerWebSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public ServerWebSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public ServerWebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public ServerWebSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public ServerWebSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public Completable writeFrame(WebSocketFrame frame) {
        Completable ret = this.rxWriteFrame(frame);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFrame(WebSocketFrame frame) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeFrame(frame.getDelegate(), handler));
    }

    @Override
    public Completable writeFinalTextFrame(String text) {
        Completable ret = this.rxWriteFinalTextFrame(text);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFinalTextFrame(String text) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeFinalTextFrame(text, handler));
    }

    @Override
    public Completable writeFinalBinaryFrame(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWriteFinalBinaryFrame(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFinalBinaryFrame(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeFinalBinaryFrame(data.getDelegate(), handler));
    }

    @Override
    public Completable writeBinaryMessage(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWriteBinaryMessage(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteBinaryMessage(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeBinaryMessage(data.getDelegate(), handler));
    }

    @Override
    public Completable writeTextMessage(String text) {
        Completable ret = this.rxWriteTextMessage(text);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteTextMessage(String text) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeTextMessage(text, handler));
    }

    @Override
    public ServerWebSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public ServerWebSocket frameHandler(final Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler((Handler)new Handler<io.vertx.core.http.WebSocketFrame>(){

            public void handle(io.vertx.core.http.WebSocketFrame event) {
                handler.handle((Object)WebSocketFrame.newInstance(event));
            }
        });
        return this;
    }

    public String scheme() {
        String ret = this.delegate.scheme();
        return ret;
    }

    public String host() {
        String ret = this.delegate.host();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public void accept() {
        this.delegate.accept();
    }

    public void reject() {
        this.delegate.reject();
    }

    public void reject(int status) {
        this.delegate.reject(status);
    }

    public Single<Integer> setHandshake(Single<Integer> future) {
        Single ret = this.rxSetHandshake(future);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxSetHandshake(Single<Integer> future) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.setHandshake(SingleHelper.toFuture((Single)future, obj -> obj), handler));
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static ServerWebSocket newInstance(io.vertx.core.http.ServerWebSocket arg) {
        return arg != null ? new ServerWebSocket(arg) : null;
    }
}

