/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.mysqlclient;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.sqlclient.PreparedStatement;
import io.vertx.rxjava3.sqlclient.SqlConnection;

@RxGen(value=io.vertx.mysqlclient.MySQLConnection.class)
public class MySQLConnection
extends SqlConnection {
    public static final TypeArg<MySQLConnection> __TYPE_ARG = new TypeArg(obj -> new MySQLConnection((io.vertx.mysqlclient.MySQLConnection)obj), MySQLConnection::getDelegate);
    private final io.vertx.mysqlclient.MySQLConnection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MySQLConnection that = (MySQLConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MySQLConnection(io.vertx.mysqlclient.MySQLConnection delegate) {
        super((io.vertx.sqlclient.SqlConnection)delegate);
        this.delegate = delegate;
    }

    public MySQLConnection(Object delegate) {
        super((io.vertx.sqlclient.SqlConnection)((io.vertx.mysqlclient.MySQLConnection)delegate));
        this.delegate = (io.vertx.mysqlclient.MySQLConnection)delegate;
    }

    public io.vertx.mysqlclient.MySQLConnection getDelegate() {
        return this.delegate;
    }

    public static Single<MySQLConnection> connect(io.vertx.rxjava3.core.Vertx vertx, MySQLConnectOptions connectOptions) {
        Single ret = MySQLConnection.rxConnect(vertx, connectOptions);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public static Single<MySQLConnection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, MySQLConnectOptions connectOptions) {
        return AsyncResultSingle.toSingle(handler -> io.vertx.mysqlclient.MySQLConnection.connect((Vertx)vertx.getDelegate(), (MySQLConnectOptions)connectOptions, (Handler)new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>(){

            public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static Single<MySQLConnection> connect(io.vertx.rxjava3.core.Vertx vertx, String connectionUri) {
        Single ret = MySQLConnection.rxConnect(vertx, connectionUri);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public static Single<MySQLConnection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, String connectionUri) {
        return AsyncResultSingle.toSingle(handler -> io.vertx.mysqlclient.MySQLConnection.connect((Vertx)vertx.getDelegate(), (String)connectionUri, (Handler)new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>(){

            public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    @Override
    public Single<PreparedStatement> prepare(String sql) {
        Single ret = this.rxPrepare(sql);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    @Override
    public Single<PreparedStatement> rxPrepare(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    @Override
    public MySQLConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public MySQLConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public Completable ping() {
        Completable ret = this.rxPing();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxPing() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.ping(handler));
    }

    public Completable specifySchema(String schemaName) {
        Completable ret = this.rxSpecifySchema(schemaName);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSpecifySchema(String schemaName) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.specifySchema(schemaName, handler));
    }

    public Single<String> getInternalStatistics() {
        Single ret = this.rxGetInternalStatistics();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxGetInternalStatistics() {
        return AsyncResultSingle.toSingle(handler -> this.delegate.getInternalStatistics(handler));
    }

    public Completable setOption(MySQLSetOption option) {
        Completable ret = this.rxSetOption(option);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSetOption(MySQLSetOption option) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.setOption(option, handler));
    }

    public Completable resetConnection() {
        Completable ret = this.rxResetConnection();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxResetConnection() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.resetConnection(handler));
    }

    public Completable debug() {
        Completable ret = this.rxDebug();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDebug() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.debug(handler));
    }

    public Completable changeUser(MySQLAuthOptions options) {
        Completable ret = this.rxChangeUser(options);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxChangeUser(MySQLAuthOptions options) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.changeUser(options, handler));
    }

    public static MySQLConnection cast(SqlConnection sqlConnection) {
        MySQLConnection ret = MySQLConnection.newInstance(io.vertx.mysqlclient.MySQLConnection.cast((io.vertx.sqlclient.SqlConnection)sqlConnection.getDelegate()));
        return ret;
    }

    public static MySQLConnection newInstance(io.vertx.mysqlclient.MySQLConnection arg) {
        return arg != null ? new MySQLConnection(arg) : null;
    }
}

