/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.file;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.OpenOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.core.file.AsyncFile;
import io.vertx.rxjava3.core.file.FileProps;
import io.vertx.rxjava3.core.file.FileSystemProps;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.core.file.FileSystem.class)
public class FileSystem {
    public static final TypeArg<FileSystem> __TYPE_ARG = new TypeArg(obj -> new FileSystem((io.vertx.core.file.FileSystem)obj), FileSystem::getDelegate);
    private final io.vertx.core.file.FileSystem delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem that = (FileSystem)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    public FileSystem(Object delegate) {
        this.delegate = (io.vertx.core.file.FileSystem)delegate;
    }

    public io.vertx.core.file.FileSystem getDelegate() {
        return this.delegate;
    }

    public Completable copy(String from, String to) {
        Completable ret = this.rxCopy(from, to);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxCopy(String from, String to) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.copy(from, to, handler));
    }

    public Completable copy(String from, String to, CopyOptions options) {
        Completable ret = this.rxCopy(from, to, options);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxCopy(String from, String to, CopyOptions options) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.copy(from, to, options, handler));
    }

    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    public Completable copyRecursive(String from, String to, boolean recursive) {
        Completable ret = this.rxCopyRecursive(from, to, recursive);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxCopyRecursive(String from, String to, boolean recursive) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.copyRecursive(from, to, recursive, handler));
    }

    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.delegate.copyRecursiveBlocking(from, to, recursive);
        return this;
    }

    public Completable move(String from, String to) {
        Completable ret = this.rxMove(from, to);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxMove(String from, String to) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.move(from, to, handler));
    }

    public Completable move(String from, String to, CopyOptions options) {
        Completable ret = this.rxMove(from, to, options);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxMove(String from, String to, CopyOptions options) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.move(from, to, options, handler));
    }

    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    public Completable truncate(String path, long len) {
        Completable ret = this.rxTruncate(path, len);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxTruncate(String path, long len) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.truncate(path, len, handler));
    }

    public FileSystem truncateBlocking(String path, long len) {
        this.delegate.truncateBlocking(path, len);
        return this;
    }

    public Completable chmod(String path, String perms) {
        Completable ret = this.rxChmod(path, perms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxChmod(String path, String perms) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.chmod(path, perms, handler));
    }

    public FileSystem chmodBlocking(String path, String perms) {
        this.delegate.chmodBlocking(path, perms);
        return this;
    }

    public Completable chmodRecursive(String path, String perms, String dirPerms) {
        Completable ret = this.rxChmodRecursive(path, perms, dirPerms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxChmodRecursive(String path, String perms, String dirPerms) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.chmodRecursive(path, perms, dirPerms, handler));
    }

    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path, perms, dirPerms);
        return this;
    }

    public Completable chown(String path, String user, String group) {
        Completable ret = this.rxChown(path, user, group);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxChown(String path, String user, String group) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.chown(path, user, group, handler));
    }

    public FileSystem chownBlocking(String path, String user, String group) {
        this.delegate.chownBlocking(path, user, group);
        return this;
    }

    public Single<FileProps> props(String path) {
        Single ret = this.rxProps(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<FileProps> rxProps(String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.props(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)FileProps.newInstance((io.vertx.core.file.FileProps)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public FileProps propsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.propsBlocking(path));
        return ret;
    }

    public Single<FileProps> lprops(String path) {
        Single ret = this.rxLprops(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<FileProps> rxLprops(String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.lprops(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)FileProps.newInstance((io.vertx.core.file.FileProps)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public FileProps lpropsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.lpropsBlocking(path));
        return ret;
    }

    public Completable link(String link, String existing) {
        Completable ret = this.rxLink(link, existing);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxLink(String link, String existing) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.link(link, existing, handler));
    }

    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    public Completable symlink(String link, String existing) {
        Completable ret = this.rxSymlink(link, existing);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxSymlink(String link, String existing) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.symlink(link, existing, handler));
    }

    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    public Completable unlink(String link) {
        Completable ret = this.rxUnlink(link);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxUnlink(String link) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.unlink(link, handler));
    }

    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    public Single<String> readSymlink(String link) {
        Single ret = this.rxReadSymlink(link);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<String> rxReadSymlink(String link) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.readSymlink(link, handler));
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    public Completable delete(String path) {
        Completable ret = this.rxDelete(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxDelete(String path) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.delete(path, handler));
    }

    public FileSystem deleteBlocking(String path) {
        this.delegate.deleteBlocking(path);
        return this;
    }

    public Completable deleteRecursive(String path, boolean recursive) {
        Completable ret = this.rxDeleteRecursive(path, recursive);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxDeleteRecursive(String path, boolean recursive) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.deleteRecursive(path, recursive, handler));
    }

    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.delegate.deleteRecursiveBlocking(path, recursive);
        return this;
    }

    public Completable mkdir(String path) {
        Completable ret = this.rxMkdir(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxMkdir(String path) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.mkdir(path, handler));
    }

    public FileSystem mkdirBlocking(String path) {
        this.delegate.mkdirBlocking(path);
        return this;
    }

    public Completable mkdir(String path, String perms) {
        Completable ret = this.rxMkdir(path, perms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxMkdir(String path, String perms) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.mkdir(path, perms, handler));
    }

    public FileSystem mkdirBlocking(String path, String perms) {
        this.delegate.mkdirBlocking(path, perms);
        return this;
    }

    public Completable mkdirs(String path) {
        Completable ret = this.rxMkdirs(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxMkdirs(String path) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.mkdirs(path, handler));
    }

    public FileSystem mkdirsBlocking(String path) {
        this.delegate.mkdirsBlocking(path);
        return this;
    }

    public Completable mkdirs(String path, String perms) {
        Completable ret = this.rxMkdirs(path, perms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxMkdirs(String path, String perms) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.mkdirs(path, perms, handler));
    }

    public FileSystem mkdirsBlocking(String path, String perms) {
        this.delegate.mkdirsBlocking(path, perms);
        return this;
    }

    public Single<List<String>> readDir(String path) {
        Single ret = this.rxReadDir(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<List<String>> rxReadDir(String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.readDir(path, handler));
    }

    public List<String> readDirBlocking(String path) {
        List ret = this.delegate.readDirBlocking(path);
        return ret;
    }

    public Single<List<String>> readDir(String path, String filter) {
        Single ret = this.rxReadDir(path, filter);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<List<String>> rxReadDir(String path, String filter) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.readDir(path, filter, handler));
    }

    public List<String> readDirBlocking(String path, String filter) {
        List ret = this.delegate.readDirBlocking(path, filter);
        return ret;
    }

    public Single<io.vertx.rxjava3.core.buffer.Buffer> readFile(String path) {
        Single ret = this.rxReadFile(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<io.vertx.rxjava3.core.buffer.Buffer> rxReadFile(String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.readFile(path, (Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public io.vertx.rxjava3.core.buffer.Buffer readFileBlocking(String path) {
        io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance(this.delegate.readFileBlocking(path));
        return ret;
    }

    public Completable writeFile(String path, io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWriteFile(path, data);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxWriteFile(String path, io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeFile(path, data.getDelegate(), handler));
    }

    public FileSystem writeFileBlocking(String path, io.vertx.rxjava3.core.buffer.Buffer data) {
        this.delegate.writeFileBlocking(path, data.getDelegate());
        return this;
    }

    public Single<AsyncFile> open(String path, OpenOptions options) {
        Single ret = this.rxOpen(path, options);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<AsyncFile> rxOpen(String path, OpenOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.open(path, options, (Handler)new Handler<AsyncResult<io.vertx.core.file.AsyncFile>>(){

            public void handle(AsyncResult<io.vertx.core.file.AsyncFile> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)AsyncFile.newInstance((io.vertx.core.file.AsyncFile)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public AsyncFile openBlocking(String path, OpenOptions options) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path, options));
        return ret;
    }

    public Completable createFile(String path) {
        Completable ret = this.rxCreateFile(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxCreateFile(String path) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.createFile(path, handler));
    }

    public FileSystem createFileBlocking(String path) {
        this.delegate.createFileBlocking(path);
        return this;
    }

    public Completable createFile(String path, String perms) {
        Completable ret = this.rxCreateFile(path, perms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxCreateFile(String path, String perms) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.createFile(path, perms, handler));
    }

    public FileSystem createFileBlocking(String path, String perms) {
        this.delegate.createFileBlocking(path, perms);
        return this;
    }

    public Single<Boolean> exists(String path) {
        Single ret = this.rxExists(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<Boolean> rxExists(String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.exists(path, handler));
    }

    public boolean existsBlocking(String path) {
        boolean ret = this.delegate.existsBlocking(path);
        return ret;
    }

    public Single<FileSystemProps> fsProps(String path) {
        Single ret = this.rxFsProps(path);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<FileSystemProps> rxFsProps(String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.fsProps(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileSystemProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileSystemProps> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)FileSystemProps.newInstance((io.vertx.core.file.FileSystemProps)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public FileSystemProps fsPropsBlocking(String path) {
        FileSystemProps ret = FileSystemProps.newInstance(this.delegate.fsPropsBlocking(path));
        return ret;
    }

    public Single<String> createTempDirectory(String prefix) {
        Single ret = this.rxCreateTempDirectory(prefix);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String prefix) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.createTempDirectory(prefix, handler));
    }

    public String createTempDirectoryBlocking(String prefix) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix);
        return ret;
    }

    public Single<String> createTempDirectory(String prefix, String perms) {
        Single ret = this.rxCreateTempDirectory(prefix, perms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String prefix, String perms) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.createTempDirectory(prefix, perms, handler));
    }

    public String createTempDirectoryBlocking(String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix, perms);
        return ret;
    }

    public Single<String> createTempDirectory(String dir, String prefix, String perms) {
        Single ret = this.rxCreateTempDirectory(dir, prefix, perms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String dir, String prefix, String perms) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.createTempDirectory(dir, prefix, perms, handler));
    }

    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(dir, prefix, perms);
        return ret;
    }

    public Single<String> createTempFile(String prefix, String suffix) {
        Single ret = this.rxCreateTempFile(prefix, suffix);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.createTempFile(prefix, suffix, handler));
    }

    public String createTempFileBlocking(String prefix, String suffix) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix);
        return ret;
    }

    public Single<String> createTempFile(String prefix, String suffix, String perms) {
        Single ret = this.rxCreateTempFile(prefix, suffix, perms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix, String perms) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.createTempFile(prefix, suffix, perms, handler));
    }

    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix, perms);
        return ret;
    }

    public Single<String> createTempFile(String dir, String prefix, String suffix, String perms) {
        Single ret = this.rxCreateTempFile(dir, prefix, suffix, perms);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<String> rxCreateTempFile(String dir, String prefix, String suffix, String perms) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.createTempFile(dir, prefix, suffix, perms, handler));
    }

    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(dir, prefix, suffix, perms);
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

