/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.redis.client;

import io.reactivex.rxjava3.core.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.redis.client.Redis;
import io.vertx.rxjava3.redis.client.RedisConnection;
import io.vertx.rxjava3.redis.client.Response;
import java.util.List;

@RxGen(value=io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {
    public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg(obj -> new RedisAPI((io.vertx.redis.client.RedisAPI)obj), RedisAPI::getDelegate);
    private final io.vertx.redis.client.RedisAPI delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisAPI that = (RedisAPI)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
        this.delegate = delegate;
    }

    public RedisAPI(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
    }

    public io.vertx.redis.client.RedisAPI getDelegate() {
        return this.delegate;
    }

    public void close() {
        this.delegate.close();
    }

    public Maybe<Response> acl(List<String> args) {
        Maybe ret = this.rxAcl(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxAcl(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.acl(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> append(String arg0, String arg1) {
        Maybe ret = this.rxAppend(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxAppend(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.append(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> asking() {
        Maybe ret = this.rxAsking();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxAsking() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.asking((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> auth(List<String> args) {
        Maybe ret = this.rxAuth(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxAuth(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.auth(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bgrewriteaof() {
        Maybe ret = this.rxBgrewriteaof();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBgrewriteaof() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bgrewriteaof((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bgsave(List<String> args) {
        Maybe ret = this.rxBgsave(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBgsave(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bgsave(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bitcount(List<String> args) {
        Maybe ret = this.rxBitcount(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBitcount(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bitcount(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bitfield(List<String> args) {
        Maybe ret = this.rxBitfield(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBitfield(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bitfield(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bitfieldRo(List<String> args) {
        Maybe ret = this.rxBitfieldRo(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBitfieldRo(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bitfieldRo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bitop(List<String> args) {
        Maybe ret = this.rxBitop(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBitop(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bitop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bitpos(List<String> args) {
        Maybe ret = this.rxBitpos(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBitpos(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bitpos(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> blpop(List<String> args) {
        Maybe ret = this.rxBlpop(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBlpop(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.blpop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> brpop(List<String> args) {
        Maybe ret = this.rxBrpop(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBrpop(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.brpop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> brpoplpush(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxBrpoplpush(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBrpoplpush(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.brpoplpush(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bzpopmax(List<String> args) {
        Maybe ret = this.rxBzpopmax(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBzpopmax(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bzpopmax(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> bzpopmin(List<String> args) {
        Maybe ret = this.rxBzpopmin(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxBzpopmin(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.bzpopmin(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> client(List<String> args) {
        Maybe ret = this.rxClient(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxClient(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.client(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> cluster(List<String> args) {
        Maybe ret = this.rxCluster(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxCluster(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.cluster(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> command(List<String> args) {
        Maybe ret = this.rxCommand(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxCommand(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.command(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> config(List<String> args) {
        Maybe ret = this.rxConfig(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxConfig(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.config(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> dbsize() {
        Maybe ret = this.rxDbsize();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxDbsize() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.dbsize((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> debug(List<String> args) {
        Maybe ret = this.rxDebug(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxDebug(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.debug(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> decr(String arg0) {
        Maybe ret = this.rxDecr(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxDecr(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.decr(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> decrby(String arg0, String arg1) {
        Maybe ret = this.rxDecrby(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxDecrby(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.decrby(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> del(List<String> args) {
        Maybe ret = this.rxDel(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxDel(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.del(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> discard() {
        Maybe ret = this.rxDiscard();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxDiscard() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.discard((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> dump(String arg0) {
        Maybe ret = this.rxDump(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxDump(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.dump(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> echo(String arg0) {
        Maybe ret = this.rxEcho(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxEcho(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.echo(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> eval(List<String> args) {
        Maybe ret = this.rxEval(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxEval(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.eval(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> evalsha(List<String> args) {
        Maybe ret = this.rxEvalsha(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxEvalsha(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.evalsha(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> exec() {
        Maybe ret = this.rxExec();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxExec() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.exec((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> exists(List<String> args) {
        Maybe ret = this.rxExists(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxExists(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.exists(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> expire(String arg0, String arg1) {
        Maybe ret = this.rxExpire(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxExpire(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.expire(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> expireat(String arg0, String arg1) {
        Maybe ret = this.rxExpireat(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxExpireat(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.expireat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> flushall(List<String> args) {
        Maybe ret = this.rxFlushall(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxFlushall(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.flushall(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> flushdb(List<String> args) {
        Maybe ret = this.rxFlushdb(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxFlushdb(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.flushdb(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> geoadd(List<String> args) {
        Maybe ret = this.rxGeoadd(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGeoadd(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.geoadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> geodist(List<String> args) {
        Maybe ret = this.rxGeodist(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGeodist(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.geodist(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> geohash(List<String> args) {
        Maybe ret = this.rxGeohash(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGeohash(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.geohash(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> geopos(List<String> args) {
        Maybe ret = this.rxGeopos(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGeopos(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.geopos(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> georadius(List<String> args) {
        Maybe ret = this.rxGeoradius(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGeoradius(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.georadius(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> georadiusRo(List<String> args) {
        Maybe ret = this.rxGeoradiusRo(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGeoradiusRo(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.georadiusRo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> georadiusbymember(List<String> args) {
        Maybe ret = this.rxGeoradiusbymember(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGeoradiusbymember(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.georadiusbymember(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> georadiusbymemberRo(List<String> args) {
        Maybe ret = this.rxGeoradiusbymemberRo(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGeoradiusbymemberRo(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.georadiusbymemberRo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> get(String arg0) {
        Maybe ret = this.rxGet(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGet(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.get(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> getbit(String arg0, String arg1) {
        Maybe ret = this.rxGetbit(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGetbit(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.getbit(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> getrange(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxGetrange(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGetrange(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.getrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> getset(String arg0, String arg1) {
        Maybe ret = this.rxGetset(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxGetset(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.getset(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hdel(List<String> args) {
        Maybe ret = this.rxHdel(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHdel(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hdel(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hello(List<String> args) {
        Maybe ret = this.rxHello(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHello(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hello(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hexists(String arg0, String arg1) {
        Maybe ret = this.rxHexists(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHexists(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hexists(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hget(String arg0, String arg1) {
        Maybe ret = this.rxHget(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHget(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hget(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hgetall(String arg0) {
        Maybe ret = this.rxHgetall(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHgetall(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hgetall(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hincrby(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxHincrby(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHincrby(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hincrby(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hincrbyfloat(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxHincrbyfloat(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHincrbyfloat(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hincrbyfloat(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hkeys(String arg0) {
        Maybe ret = this.rxHkeys(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHkeys(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hkeys(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hlen(String arg0) {
        Maybe ret = this.rxHlen(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHlen(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hmget(List<String> args) {
        Maybe ret = this.rxHmget(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHmget(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hmget(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hmset(List<String> args) {
        Maybe ret = this.rxHmset(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHmset(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hmset(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> host(List<String> args) {
        Maybe ret = this.rxHost(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHost(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.host(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hscan(List<String> args) {
        Maybe ret = this.rxHscan(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHscan(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hscan(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hset(List<String> args) {
        Maybe ret = this.rxHset(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHset(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hset(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hsetnx(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxHsetnx(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHsetnx(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hsetnx(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hstrlen(String arg0, String arg1) {
        Maybe ret = this.rxHstrlen(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHstrlen(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hstrlen(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> hvals(String arg0) {
        Maybe ret = this.rxHvals(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxHvals(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.hvals(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> incr(String arg0) {
        Maybe ret = this.rxIncr(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxIncr(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.incr(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> incrby(String arg0, String arg1) {
        Maybe ret = this.rxIncrby(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxIncrby(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.incrby(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> incrbyfloat(String arg0, String arg1) {
        Maybe ret = this.rxIncrbyfloat(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxIncrbyfloat(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.incrbyfloat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> info(List<String> args) {
        Maybe ret = this.rxInfo(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxInfo(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.info(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> keys(String arg0) {
        Maybe ret = this.rxKeys(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxKeys(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.keys(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lastsave() {
        Maybe ret = this.rxLastsave();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLastsave() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lastsave((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> latency(List<String> args) {
        Maybe ret = this.rxLatency(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLatency(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.latency(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lindex(String arg0, String arg1) {
        Maybe ret = this.rxLindex(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLindex(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lindex(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> linsert(String arg0, String arg1, String arg2, String arg3) {
        Maybe ret = this.rxLinsert(arg0, arg1, arg2, arg3);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLinsert(String arg0, String arg1, String arg2, String arg3) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.linsert(arg0, arg1, arg2, arg3, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> llen(String arg0) {
        Maybe ret = this.rxLlen(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLlen(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.llen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lolwut(List<String> args) {
        Maybe ret = this.rxLolwut(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLolwut(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lolwut(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lpop(String arg0) {
        Maybe ret = this.rxLpop(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLpop(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lpop(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lpush(List<String> args) {
        Maybe ret = this.rxLpush(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLpush(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lpush(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lpushx(List<String> args) {
        Maybe ret = this.rxLpushx(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLpushx(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lpushx(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lrange(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxLrange(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLrange(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lrem(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxLrem(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLrem(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lrem(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> lset(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxLset(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLset(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lset(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> ltrim(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxLtrim(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxLtrim(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.ltrim(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> memory(List<String> args) {
        Maybe ret = this.rxMemory(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxMemory(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.memory(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> mget(List<String> args) {
        Maybe ret = this.rxMget(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxMget(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.mget(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> migrate(List<String> args) {
        Maybe ret = this.rxMigrate(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxMigrate(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.migrate(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> module(List<String> args) {
        Maybe ret = this.rxModule(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxModule(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.module(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> monitor() {
        Maybe ret = this.rxMonitor();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxMonitor() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.monitor((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> move(String arg0, String arg1) {
        Maybe ret = this.rxMove(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxMove(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.move(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> mset(List<String> args) {
        Maybe ret = this.rxMset(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxMset(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.mset(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> msetnx(List<String> args) {
        Maybe ret = this.rxMsetnx(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxMsetnx(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.msetnx(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> multi() {
        Maybe ret = this.rxMulti();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxMulti() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.multi((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> object(List<String> args) {
        Maybe ret = this.rxObject(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxObject(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.object(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> persist(String arg0) {
        Maybe ret = this.rxPersist(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPersist(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.persist(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pexpire(String arg0, String arg1) {
        Maybe ret = this.rxPexpire(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPexpire(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pexpire(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pexpireat(String arg0, String arg1) {
        Maybe ret = this.rxPexpireat(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPexpireat(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pexpireat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pfadd(List<String> args) {
        Maybe ret = this.rxPfadd(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPfadd(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pfadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pfcount(List<String> args) {
        Maybe ret = this.rxPfcount(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPfcount(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pfcount(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pfdebug(List<String> args) {
        Maybe ret = this.rxPfdebug(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPfdebug(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pfdebug(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pfmerge(List<String> args) {
        Maybe ret = this.rxPfmerge(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPfmerge(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pfmerge(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pfselftest() {
        Maybe ret = this.rxPfselftest();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPfselftest() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pfselftest((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> ping(List<String> args) {
        Maybe ret = this.rxPing(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPing(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.ping(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> post(List<String> args) {
        Maybe ret = this.rxPost(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPost(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.post(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> psetex(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxPsetex(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPsetex(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.psetex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> psubscribe(List<String> args) {
        Maybe ret = this.rxPsubscribe(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPsubscribe(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.psubscribe(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> psync(String arg0, String arg1) {
        Maybe ret = this.rxPsync(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPsync(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.psync(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pttl(String arg0) {
        Maybe ret = this.rxPttl(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPttl(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pttl(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> publish(String arg0, String arg1) {
        Maybe ret = this.rxPublish(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPublish(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.publish(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> pubsub(List<String> args) {
        Maybe ret = this.rxPubsub(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPubsub(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.pubsub(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> punsubscribe(List<String> args) {
        Maybe ret = this.rxPunsubscribe(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxPunsubscribe(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.punsubscribe(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> randomkey() {
        Maybe ret = this.rxRandomkey();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRandomkey() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.randomkey((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> readonly() {
        Maybe ret = this.rxReadonly();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxReadonly() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.readonly((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> readwrite() {
        Maybe ret = this.rxReadwrite();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxReadwrite() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.readwrite((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> rename(String arg0, String arg1) {
        Maybe ret = this.rxRename(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRename(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.rename(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> renamenx(String arg0, String arg1) {
        Maybe ret = this.rxRenamenx(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRenamenx(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.renamenx(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> replconf(List<String> args) {
        Maybe ret = this.rxReplconf(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxReplconf(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.replconf(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> replicaof(String arg0, String arg1) {
        Maybe ret = this.rxReplicaof(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxReplicaof(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.replicaof(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> restore(List<String> args) {
        Maybe ret = this.rxRestore(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRestore(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.restore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> restoreAsking(List<String> args) {
        Maybe ret = this.rxRestoreAsking(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRestoreAsking(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.restoreAsking(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> role() {
        Maybe ret = this.rxRole();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRole() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.role((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> rpop(String arg0) {
        Maybe ret = this.rxRpop(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRpop(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.rpop(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> rpoplpush(String arg0, String arg1) {
        Maybe ret = this.rxRpoplpush(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRpoplpush(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.rpoplpush(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> rpush(List<String> args) {
        Maybe ret = this.rxRpush(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRpush(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.rpush(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> rpushx(List<String> args) {
        Maybe ret = this.rxRpushx(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxRpushx(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.rpushx(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sadd(List<String> args) {
        Maybe ret = this.rxSadd(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSadd(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> save() {
        Maybe ret = this.rxSave();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSave() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.save((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> scan(List<String> args) {
        Maybe ret = this.rxScan(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxScan(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.scan(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> scard(String arg0) {
        Maybe ret = this.rxScard(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxScard(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.scard(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> script(List<String> args) {
        Maybe ret = this.rxScript(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxScript(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.script(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sdiff(List<String> args) {
        Maybe ret = this.rxSdiff(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSdiff(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sdiff(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sdiffstore(List<String> args) {
        Maybe ret = this.rxSdiffstore(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSdiffstore(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sdiffstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> select(String arg0) {
        Maybe ret = this.rxSelect(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSelect(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.select(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> set(List<String> args) {
        Maybe ret = this.rxSet(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSet(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.set(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> setbit(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxSetbit(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSetbit(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.setbit(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> setex(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxSetex(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSetex(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.setex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> setnx(String arg0, String arg1) {
        Maybe ret = this.rxSetnx(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSetnx(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.setnx(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> setrange(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxSetrange(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSetrange(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.setrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> shutdown(List<String> args) {
        Maybe ret = this.rxShutdown(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxShutdown(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.shutdown(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sinter(List<String> args) {
        Maybe ret = this.rxSinter(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSinter(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sinter(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sinterstore(List<String> args) {
        Maybe ret = this.rxSinterstore(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSinterstore(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sinterstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sismember(String arg0, String arg1) {
        Maybe ret = this.rxSismember(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSismember(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sismember(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> slaveof(String arg0, String arg1) {
        Maybe ret = this.rxSlaveof(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSlaveof(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.slaveof(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> slowlog(List<String> args) {
        Maybe ret = this.rxSlowlog(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSlowlog(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.slowlog(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> smembers(String arg0) {
        Maybe ret = this.rxSmembers(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSmembers(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.smembers(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> smove(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxSmove(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSmove(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.smove(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sort(List<String> args) {
        Maybe ret = this.rxSort(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSort(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sort(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> spop(List<String> args) {
        Maybe ret = this.rxSpop(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSpop(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.spop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> srandmember(List<String> args) {
        Maybe ret = this.rxSrandmember(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSrandmember(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.srandmember(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> srem(List<String> args) {
        Maybe ret = this.rxSrem(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSrem(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.srem(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sscan(List<String> args) {
        Maybe ret = this.rxSscan(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSscan(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sscan(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> stralgo(List<String> args) {
        Maybe ret = this.rxStralgo(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxStralgo(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.stralgo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> strlen(String arg0) {
        Maybe ret = this.rxStrlen(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxStrlen(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.strlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> subscribe(List<String> args) {
        Maybe ret = this.rxSubscribe(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSubscribe(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.subscribe(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> substr(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxSubstr(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSubstr(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.substr(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sunion(List<String> args) {
        Maybe ret = this.rxSunion(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSunion(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sunion(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sunionstore(List<String> args) {
        Maybe ret = this.rxSunionstore(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSunionstore(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sunionstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> swapdb(String arg0, String arg1) {
        Maybe ret = this.rxSwapdb(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSwapdb(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.swapdb(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> sync() {
        Maybe ret = this.rxSync();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSync() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.sync((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> time() {
        Maybe ret = this.rxTime();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxTime() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.time((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> touch(List<String> args) {
        Maybe ret = this.rxTouch(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxTouch(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.touch(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> ttl(String arg0) {
        Maybe ret = this.rxTtl(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxTtl(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.ttl(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> type(String arg0) {
        Maybe ret = this.rxType(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxType(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.type(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> unlink(List<String> args) {
        Maybe ret = this.rxUnlink(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxUnlink(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.unlink(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> unsubscribe(List<String> args) {
        Maybe ret = this.rxUnsubscribe(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxUnsubscribe(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.unsubscribe(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> unwatch() {
        Maybe ret = this.rxUnwatch();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxUnwatch() {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.unwatch((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> wait(String arg0, String arg1) {
        Maybe ret = this.rxWait(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxWait(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.wait(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> watch(List<String> args) {
        Maybe ret = this.rxWatch(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxWatch(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.watch(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xack(List<String> args) {
        Maybe ret = this.rxXack(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXack(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xack(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xadd(List<String> args) {
        Maybe ret = this.rxXadd(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXadd(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xclaim(List<String> args) {
        Maybe ret = this.rxXclaim(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXclaim(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xclaim(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xdel(List<String> args) {
        Maybe ret = this.rxXdel(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXdel(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xdel(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xgroup(List<String> args) {
        Maybe ret = this.rxXgroup(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXgroup(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xgroup(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xinfo(List<String> args) {
        Maybe ret = this.rxXinfo(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXinfo(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xinfo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xlen(String arg0) {
        Maybe ret = this.rxXlen(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXlen(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xpending(List<String> args) {
        Maybe ret = this.rxXpending(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXpending(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xpending(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xrange(List<String> args) {
        Maybe ret = this.rxXrange(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXrange(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xrange(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xread(List<String> args) {
        Maybe ret = this.rxXread(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXread(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xread(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xreadgroup(List<String> args) {
        Maybe ret = this.rxXreadgroup(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXreadgroup(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xreadgroup(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xrevrange(List<String> args) {
        Maybe ret = this.rxXrevrange(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXrevrange(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xrevrange(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xsetid(String arg0, String arg1) {
        Maybe ret = this.rxXsetid(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXsetid(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xsetid(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> xtrim(List<String> args) {
        Maybe ret = this.rxXtrim(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxXtrim(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.xtrim(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zadd(List<String> args) {
        Maybe ret = this.rxZadd(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZadd(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zcard(String arg0) {
        Maybe ret = this.rxZcard(arg0);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZcard(String arg0) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zcard(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zcount(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxZcount(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZcount(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zcount(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zincrby(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxZincrby(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZincrby(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zincrby(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zinterstore(List<String> args) {
        Maybe ret = this.rxZinterstore(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZinterstore(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zinterstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zlexcount(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxZlexcount(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZlexcount(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zlexcount(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zpopmax(List<String> args) {
        Maybe ret = this.rxZpopmax(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZpopmax(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zpopmax(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zpopmin(List<String> args) {
        Maybe ret = this.rxZpopmin(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZpopmin(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zpopmin(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrange(List<String> args) {
        Maybe ret = this.rxZrange(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrange(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrange(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrangebylex(List<String> args) {
        Maybe ret = this.rxZrangebylex(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrangebylex(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrangebylex(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrangebyscore(List<String> args) {
        Maybe ret = this.rxZrangebyscore(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrangebyscore(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrangebyscore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrank(String arg0, String arg1) {
        Maybe ret = this.rxZrank(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrank(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrank(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrem(List<String> args) {
        Maybe ret = this.rxZrem(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrem(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrem(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zremrangebylex(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxZremrangebylex(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZremrangebylex(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zremrangebylex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zremrangebyrank(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxZremrangebyrank(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZremrangebyrank(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zremrangebyrank(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zremrangebyscore(String arg0, String arg1, String arg2) {
        Maybe ret = this.rxZremrangebyscore(arg0, arg1, arg2);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZremrangebyscore(String arg0, String arg1, String arg2) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zremrangebyscore(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrevrange(List<String> args) {
        Maybe ret = this.rxZrevrange(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrevrange(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrevrange(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrevrangebylex(List<String> args) {
        Maybe ret = this.rxZrevrangebylex(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrevrangebylex(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrevrangebylex(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrevrangebyscore(List<String> args) {
        Maybe ret = this.rxZrevrangebyscore(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrevrangebyscore(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrevrangebyscore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zrevrank(String arg0, String arg1) {
        Maybe ret = this.rxZrevrank(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZrevrank(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zrevrank(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zscan(List<String> args) {
        Maybe ret = this.rxZscan(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZscan(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zscan(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zscore(String arg0, String arg1) {
        Maybe ret = this.rxZscore(arg0, arg1);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZscore(String arg0, String arg1) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zscore(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Maybe<Response> zunionstore(List<String> args) {
        Maybe ret = this.rxZunionstore(args);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxZunionstore(List<String> args) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.zunionstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static RedisAPI api(Redis client) {
        RedisAPI ret = RedisAPI.newInstance(io.vertx.redis.client.RedisAPI.api((io.vertx.redis.client.Redis)client.getDelegate()));
        return ret;
    }

    public static RedisAPI api(RedisConnection connection) {
        RedisAPI ret = RedisAPI.newInstance(io.vertx.redis.client.RedisAPI.api((io.vertx.redis.client.RedisConnection)connection.getDelegate()));
        return ret;
    }

    public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
        return arg != null ? new RedisAPI(arg) : null;
    }
}

