/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.mqtt;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.mqtt.MqttEndpoint;

@RxGen(value=io.vertx.mqtt.MqttServer.class)
public class MqttServer {
    public static final TypeArg<MqttServer> __TYPE_ARG = new TypeArg(obj -> new MqttServer((io.vertx.mqtt.MqttServer)obj), MqttServer::getDelegate);
    private final io.vertx.mqtt.MqttServer delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttServer that = (MqttServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MqttServer(io.vertx.mqtt.MqttServer delegate) {
        this.delegate = delegate;
    }

    public MqttServer(Object delegate) {
        this.delegate = (io.vertx.mqtt.MqttServer)delegate;
    }

    public io.vertx.mqtt.MqttServer getDelegate() {
        return this.delegate;
    }

    public static MqttServer create(io.vertx.rxjava3.core.Vertx vertx, MqttServerOptions options) {
        MqttServer ret = MqttServer.newInstance(io.vertx.mqtt.MqttServer.create((Vertx)vertx.getDelegate(), (MqttServerOptions)options));
        return ret;
    }

    public static MqttServer create(io.vertx.rxjava3.core.Vertx vertx) {
        MqttServer ret = MqttServer.newInstance(io.vertx.mqtt.MqttServer.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public Single<MqttServer> listen(int port, String host) {
        Single ret = this.rxListen(port, host);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<MqttServer> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle(listenHandler -> this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>(){

            public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<MqttServer> listen(int port) {
        Single ret = this.rxListen(port);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<MqttServer> rxListen(int port) {
        return AsyncResultSingle.toSingle(listenHandler -> this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>(){

            public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<MqttServer> listen() {
        Single ret = this.rxListen();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<MqttServer> rxListen() {
        return AsyncResultSingle.toSingle(listenHandler -> this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>(){

            public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public MqttServer endpointHandler(final Handler<MqttEndpoint> handler) {
        this.delegate.endpointHandler((Handler)new Handler<io.vertx.mqtt.MqttEndpoint>(){

            public void handle(io.vertx.mqtt.MqttEndpoint event) {
                handler.handle((Object)MqttEndpoint.newInstance(event));
            }
        });
        return this;
    }

    public MqttServer exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(completionHandler -> this.delegate.close(completionHandler));
    }

    public static MqttServer newInstance(io.vertx.mqtt.MqttServer arg) {
        return arg != null ? new MqttServer(arg) : null;
    }
}

